<?php

/**
 * Finisys Testimonial Normal Widget.
 *
 *
 * @since 1.0.0
 */

use  Elementor\Widget_Base;
use  Elementor\Controls_Manager;
use  Elementor\utils;
use  Elementor\Group_Control_Typography;
use  Elementor\Group_Control_Box_Shadow;
use  Elementor\Group_Control_Background;
use  Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class Fastland_Testimonail_Loop extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'fastland-testimonial-loop';
    }

    public function get_title()
    {
        return __('Fastland Testimonial', 'fastland-hp');
    }

    public function get_icon()
    {
        return ('eicon-testimonial');
    }

    public function get_categories()
    {
        return ['fastland-addons'];
    }

    public function get_script_depends()
    {
        return ['owl-carousel', 'fastland-addon'];
    }

    public function get_style_depends()
    {
        return ['owl-carousel', 'fastland-addons'];
    }

    public function get_keywords()
    {
        return ['team', 'card', 'testimonial', 'membar', 'reviw', 'rating'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'ts_section',
            [
                'label' => __('General', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'testimonial_style',
            [
                'label'             => __('Testimonial Style', 'fastland-hp'),
                'type'              => Controls_Manager::SELECT,
                'default'           => 'style-one',
                'options'           => [
                    'style-one'   =>   __('Style One',    'fastland-hp'),
                    'style-two'   =>   __('Style Two',    'fastland-hp'),
                    'style-three' =>   __('Style Three',    'fastland-hp'),
                    'style-four'  =>   __('Style Four',    'fastland-hp'),
                    'style-five'  =>   __('Style Five',    'fastland-hp'),
                ],
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'show_slider_settings',
            [
                'label' => __('Slider Active', 'finisys'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'finisys'),
                'label_off' => __('No', 'finisys'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_responsive_control('t_slider_version', [
            'label'              => __('Slider Version', 'fastland-hp'),
            'type'               => Controls_Manager::SELECT,
            'options'            => [
                'style-one'     => 'Style One',
                'style-two'     => 'Style Two',
                'style-three'   => 'Style Three',
                'style-four'    => 'Four Four',
            ],
            'condition' => [
                'show_slider_settings' => 'yes',
            ]
        ]);



        $this->add_control(
            'show_icon',
            [
                'label' => __('Show Icon', 'finisys'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'finisys'),
                'label_off' => __('No', 'finisys'),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'finisys'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'show_icon' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'layout_gap',
            [
                'label' => __('Item Gap', 'fastland'),
                'type' => Controls_Manager::POPOVER_TOGGLE,
                'label_off' => __('Default', 'fastland'),
                'label_on' => __('Custom', 'fastland'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->start_popover();
        $this->add_responsive_control(
            'gap_right',
            [
                'label'          => __('Gap Right', 'fastland'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--tn-single' => 'margin-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fastland--tn-wraper' => 'margin-right: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'gap_bottom',
            [
                'label'          => __('Gap Bottom', 'fastland'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--tn-single' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fastland--tn-wraper' => 'margin-bottom: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_popover();
        $this->end_controls_section();

        //Query
        $this->start_controls_section(
            'query',
            [
                'label' => __('Query', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'item_per_page',
            [
                'label'       => __('Numbar Of Items', 'fastland'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'user emty value show all posts',
            ]
        );
        $this->add_responsive_control('per_line', [
            'label'              => __('Columns per row', 'fastland-hp'),
            'type'               => Controls_Manager::SELECT,
            'default'            => '4',
            'tablet_default'     => '6',
            'mobile_default'     => '12',
            'options'            => [
                '12' => '1',
                '6'  => '2',
                '4'  => '3',
                '3'  => '4',
            ],
            'frontend_available' => true,
        ]);

        $this->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'label_block' => true,
                'options' => array(
                    'latest'   =>   __('Latest Post', 'fastland-hp'),
                    'selected' =>   __('Selected posts', 'fastland-hp'),
                ),
            ]
        );
        $this->add_control(
            'post__in',
            [
                'label' => __('Post In', 'fastland-hp'),
                'type' => Controls_Manager::SELECT2,
                'options' => fastland_get_all_posts('fastland_testimonial'),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
                    'post_by' => 'selected',
                ]
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'options' => fastland_get_post_orderby_options(),
                'default' => 'date',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
        $this->add_control(
            't_word_limit',
            [
                'label' => __('Testimonial Word Limit', 'fastland-hp'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
            ]
        );
        $this->end_controls_section();


        //Slider Setting
        $this->start_controls_section(
            'slider_settings',
            [
                'label' => __('Slider Settings', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'show_slider_settings' => 'yes',
                ]
            ]
        );

        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __('Slider Items', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'default'            => 4,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_control(
            'arrows',
            [
                'label' => __('Show arrows?', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'dots',
            [
                'label' => __('Show Dots?', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'mousedrag',
            [
                'label' => __('Show MouseDrag', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __('Auto Play?', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => __('Infinite Loop', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'true',
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __('Autoplay Timeout', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __('1 Second', 'fastland-hp'),
                    '2000'  => __('2 Second', 'fastland-hp'),
                    '3000'  => __('3 Second', 'fastland-hp'),
                    '4000'  => __('4 Second', 'fastland-hp'),
                    '5000'  => __('5 Second', 'fastland-hp'),
                    '6000'  => __('6 Second', 'fastland-hp'),
                    '7000'  => __('7 Second', 'fastland-hp'),
                    '8000'  => __('8 Second', 'fastland-hp'),
                    '9000'  => __('9 Second', 'fastland-hp'),
                    '10000' => __('10 Second', 'fastland-hp'),
                    '11000' => __('11 Second', 'fastland-hp'),
                    '12000' => __('12 Second', 'fastland-hp'),
                    '13000' => __('13 Second', 'fastland-hp'),
                    '14000' => __('14 Second', 'fastland-hp'),
                    '15000' => __('15 Second', 'fastland-hp'),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrow_prev_icon',
            [
                'label' => __('Previous Icon', 'fastland'),
                'label_block' => false,
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-chevron-left',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'arrow_next_icon',
            [
                'label' => __('Next Icon', 'fastland'),
                'label_block' => false,
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-chevron-right',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $this->end_controls_section();

        //iamge
        $this->start_controls_section(
            'iamge_style',
            [
                'label' => __('Image', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'width',
            [
                'label'          => __('Width', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['px', '%', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--t-thumb img' => 'width: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'space',
            [
                'label'          => __('Max Width', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['px', '%', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--t-thumb img' => 'max-width: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label'          => __('Height', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['px', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--t-thumb img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'object-fit',
            [
                'label'     => __('Object Fit', 'fastland-hp'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'fastland-hp'),
                    'fill'    => __('Fill', 'fastland-hp'),
                    'cover'   => __('Cover', 'fastland-hp'),
                    'contain' => __('Contain', 'fastland-hp'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--t-thumb img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'image_border',
                'selector'  => '{{WRAPPER}} .fastland--t-thumb img',
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => __('Border Radius', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--t-thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--t-thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--t-thumb img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--t-thumb img' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'image_box_shadow',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .fastland--t-thumb img',
            ]
        );
        $this->end_controls_section();


        // Name
        $this->start_controls_section(
            'tn_name',
            [
                'label' => __('Name', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'name_color_hover',
            [
                'label'     => __('Hover Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typo',
                'label'    => __('Typography', 'fastland-hp'),
                'selector' => '{{WRAPPER}}  .fastland--tn-name',
            ]
        );
        $this->add_responsive_control(
            'name_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-name' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Title
        $this->start_controls_section(
            'tn_title',
            [
                'label' => __('Designation', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label'     => __('Hover Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typo',
                'label'    => __('Typography', 'fastland-hp'),
                'selector' => '{{WRAPPER}}  .fastland--tn-title',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-title' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Discription
        $this->start_controls_section(
            'discription',
            [
                'label' => __('Discription', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'dis_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-bottm p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'dis_color_hover',
            [
                'label'     => __('Hover Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-bottm p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'dis_typo',
                'label'    => __('Typography', 'fastland-hp'),
                'selector' => '{{WRAPPER}}  .fastland--tn-bottm p',
            ]
        );

        $this->add_responsive_control(
            'dis_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-bottm p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-bottm p' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //icon style 
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __('Rating', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'icon_style_tabs'
        );

        // normal
        $this->start_controls_tab(
            'tab_icon_normal_color',
            [
                'label' => __('Normal', 'fastland'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'line_icon_color',
            [
                'label'     => __('Line Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-icon i,
                 {{WRAPPER}} .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-icon svg path' => 'stroke: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_icon_hover_color',
            [
                'label' => __('Hover', 'fastland'),
            ]
        );
        $this->add_control(
            'icon_color_hover',
            [
                'label'     => __('Hover Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon i, 
                {{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color_line_hover',
            [
                'label'     => __('Hover Line Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon i, 
                {{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg path' => 'stroke: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'icon_size',
            [
                'label'          => __('Size', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--tn-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fastland--tn-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'icon_right_gap',
            [
                'label'          => __('Right Gap', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--tn-icon i' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-icon' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Quate style 
        $this->start_controls_section(
            'quate_style',
            [
                'label' => __('Quote', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'quate_style_tabs'
        );

        // normal
        $this->start_controls_tab(
            'tab_quate_normal_color',
            [
                'label' => __('Normal', 'fastland'),
            ]
        );

        $this->add_control(
            'quate_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'line_quate_color',
            [
                'label'     => __('Line Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-icon i,
                 {{WRAPPER}} .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-icon svg path' => 'stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'quate_bg_color',
            [
                'label'     => __('Background Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}:hover .fastland--tn-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'quate_hover_color',
            [
                'label' => __('Hover', 'fastland'),
            ]
        );
        $this->add_control(
            'quate_color_hover',
            [
                'label'     => __('Hover Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon i, 
                {{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'quate_bg_color_hover',
            [
                'label'     => __('Background Hover Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}:hover .fastland--tn-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'quate_color_line_hover',
            [
                'label'     => __('Hover Line Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon i, 
                {{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastland--tn-single:hover .fastland--tn-icon svg path' => 'stroke: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'hr1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_responsive_control(
            'quate_size',
            [
                'label'          => __('Font Size', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--tn-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fastland--tn-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'quate_box_size',
            [
                'label'          => __('Quate Box Size', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--tn-icon' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'quate_border',
                'selector'  => '{{WRAPPER}} .fastland--tn-icon',
            ]
        );
        $this->add_responsive_control(
            'quate_border_radius',
            [
                'label'      => __('Border Radius', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-icon' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'quate_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-icon' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        /*
   * 
    Dots
   */
        $this->start_controls_section(
            'dots_navigation',
            [
                'label' => __('Navigation - Dots', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_slider_settings' => 'yes',
                ]
            ]
        );
        $this->start_controls_tabs('_tabs_dots');

        $this->start_controls_tab(
            '_tab_dots_normal',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );
        $this->add_control(
            'dots_color',
            [
                'label' => __('Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_width',
            [
                'label' => __('Width', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_height',
            [
                'label' => __('Height', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_dots_active',
            [
                'label' => __('Active', 'fastland-hp'),
            ]
        );
        $this->add_control(
            'dots_color_active',
            [
                'label' => __('Active Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot.active span' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_dots_active_width',
            [
                'label' => __('Width', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_dots_active_height',
            [
                'label' => __('Height', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot.active span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'hrfour',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_responsive_control(
            'dots_align',
            [
                'label' => __('Alignment', 'fastland-hp'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __('Left', 'fastland-hp'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'fastland-hp'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => __('Right', 'fastland-hp'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial  .owl-dots' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'dots_position_toggle',
            [
                'label' => __('Position', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off' => __('None', 'fastland-hp'),
                'label_on' => __('Custom', 'fastland-hp'),
                'return_value' => 'yes',
            ]
        );
        $this->start_popover();

        /* 
    dots Position
    */
        $this->add_responsive_control(
            'dots_position_y',
            [
                'label' => __('Vertical', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'condition' => [
                    'dots_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial  .owl-dots' => 'top: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_position_x',
            [
                'label' => __('Horizontal', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'condition' => [
                    'dots_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .fastland--testimonial  .owl-dots' => 'right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--testimonial  .owl-dots' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_popover();

        $this->add_responsive_control(
            'dots_margin',
            [
                'label'          => __('Gap Right', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot span' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_border_radius',
            [
                'label'      => __('Border Radius', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--testimonial .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /*
   * 
    Arrows
   */
        $this->start_controls_section(
            'arrows_navigation',
            [
                'label' => __('Navigation - Arrow', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_slider_settings' => 'yes',
                ]
            ]
        );

        $this->start_controls_tabs('_tabs_arrow');

        $this->start_controls_tab(
            '_tab_arrow_normal',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => __('Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-nav i' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--testimonial .owl-nav svg path' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_color_fill',
            [
                'label' => __('Line Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-nav i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--testimonial .owl-nav svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label' => __('Background Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-next, .fastland--testimonial .owl-prev' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'arrow_shadow',
                'label' => __('Shadow', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fastland--testimonial .owl-next, {{WRAPPER}} .fastland--testimonial .owl-prev',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_arrow_hover',
            [
                'label' => __('Hover', 'fastland-hp'),
            ]
        );

        $this->add_control(
            'arrow_hover_color',
            [
                'label' => __('Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-nav *:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--testimonial .owl-nav *:hover svg path' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_fill_color',
            [
                'label' => __('Line Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-nav *:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--testimonial .owl-nav *:hover svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_hover_color',
            [
                'label' => __('Background Color Hover', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-next:hover, .fastland--testimonial .owl-prev:hover' => 'background-color: {{VALUE}}  !important;',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'arrow_hover_shadow',
                'label' => __('Shadow Hover', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fastland--testimonial .owl-next:hover, {{WRAPPER}} .fastland--testimonial .owl-prev:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'hrthere',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'arrow_position_toggle',
            [
                'label' => __('Position', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off' => __('None', 'fastland-hp'),
                'label_on' => __('Custom', 'fastland-hp'),
                'return_value' => 'yes',
            ]
        );
        $this->start_popover();

        /* 
    Arrow Position
    */
        $this->add_responsive_control(
            'arrow_position_y',
            [
                'label' => __('Vertical', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-nav button' => 'bottom: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_prev_position',
            [
                'label' => __('Prev icon Position', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -2000,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .fastland--testimonial .owl-nav button.owl-prev' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_nextv_position',
            [
                'label' => __('Next icon Position', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -2000,
                        'max' => 2000,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .fastland--testimonial .owl-nav button.owl-next' => 'right: {{SIZE}}{{UNIT}}; left:auto;',
                ],
            ]
        );


        // $this->add_responsive_control(
        //     'arrow_position_right_gap',
        //     [
        //         'label' => __('Prev Aarrow Gap', 'fastland-hp'),
        //         'type' => \Elementor\Controls_Manager::SLIDER,
        //         'size_units' => ['px'],
        //         'condition' => [
        //             'arrow_position_toggle' => 'yes'
        //         ],
        //         'range' => [
        //             'px' => [
        //                 'min' => -1000,
        //                 'max' => 2000,
        //             ],
        //         ],
        //         'selectors' => [
        //             'body:not(.rtl) {{WRAPPER}} .fastland--testimonial .owl-nav button.owl-next' => 'right: {{SIZE}}{{UNIT}};',
        //             'body.rtl {{WRAPPER}} .fastland--testimonial .owl-nav  button.owl-prev' => 'left: {{SIZE}}{{UNIT}};',
        //         ],
        //     ]
        // );
        $this->end_popover();

        $this->add_responsive_control(
            'arrow_icon_size',
            [
                'label' => __('Icon Size', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland--testimonial .owl-nav i' => 'font-size: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}}  .fastland--testimonial .owl-nav svg' => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_size_box',
            [
                'label' => __('Size', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--testimonial .owl-next, .fastland--testimonial .owl-prev' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();

        //Box Style
        $this->start_controls_section(
            'ts_style',
            [
                'label' => __('Box', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );
        // normal
        $this->start_controls_tab(
            'tn_bg_color',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );

        $this->add_control(
            'bg',
            [
                'label'     => __('Backround Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'tn_border',
                'selector'  => '{{WRAPPER}} .fastland--tn-single',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tn_shadow',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .fastland--tn-single',
            ]
        );

        $this->add_responsive_control(
            'border_radius',
            [
                'label'      => __('Border Radius', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-single' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        // hover
        $this->start_controls_tab(
            'bg_color_hover',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );

        $this->add_control(
            'bg_hover',
            [
                'label'     => __('Backround Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--tn-single:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'tn_border_hover',
                'selector'  => '{{WRAPPER}} .fastland--tn-single:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'tn_shadow_hover',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .fastland--tn-single:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_hover',
            [
                'label'      => __('Border Radius', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-single:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-single:hover' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'hrtwo',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_responsive_control(
            'margin_bottom',
            [
                'label'          => __('Bottom Gap', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--tn-single' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => __('Padding', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--tn-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--tn-single' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
    }

    protected function get_render_icon($icon)
    {
        ob_start();
        \Elementor\Icons_Manager::render_icon($icon, ['aria-hidden' => 'true']);
        return ob_get_clean();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $numabr_of_item = !empty($settings['item_per_page']) ? $settings['item_per_page'] : -1;
        $testimonial_style = $settings['testimonial_style'];



        //this code slider option
        $slider_extraSetting = array(

            'next_icon' => $this->get_render_icon($settings['arrow_next_icon']),
            'prev_icon' => $this->get_render_icon($settings['arrow_prev_icon']),
            'loop' => (isset($settings['loop']) && 'yes' === $settings['loop']) ? true : false,
            'dots' => (isset($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
            'autoplay' => (isset($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'nav' => (isset($settings['arrows']) && 'yes' === $settings['arrows']) ? true : false,
            'mousedrag' => (isset($settings['mousedrag']) && 'yes' === $settings['mousedrag']) ? true : false,
            'autoplaytimeout' => !empty($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

            //this a responsive layout
            'per_coulmn' => (isset($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (isset($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (isset($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );

        $jasondecode = wp_json_encode($slider_extraSetting);

        if (('yes' == $settings['show_slider_settings'])) {
            $this->add_render_attribute('testimonail_version', 'class', array('fastland--testimonial', 'owl-carousel', 't-style'));
            $this->add_render_attribute('testimonail_version', 'data-settings', $jasondecode);
        } else {
            $this->add_render_attribute('testimonail_version', 'class', array($testimonial_style, 'row g-0 justify-content-center'));
            //gride class
            $grid_classes = [];
            $grid_classes[] = 'col-lg-' . $settings['per_line'];
            $grid_classes[] = 'col-md-' . isset($settings['per_line_tablet']) ? $settings['per_line_tablet'] : '';
            $grid_classes[] = 'col-sm-' . isset($settings['per_line_mobile']) ? $settings['per_line_mobile'] : '';
            $grid_classes = implode(' ', $grid_classes);
            $this->add_render_attribute('tn_classes', 'class', [$grid_classes]);
        }



        $query_args = [
            'post_type'           => 'fastland_testimonial',
            'orderby' => $settings['orderby'],
            'order'   => $settings['order'],
            'posts_per_page'      => $numabr_of_item,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
        ];

        // get_type
        if ('selected' === $settings['post_by']) {
            $query_args['post__in'] = (array)$settings['post__in'];
        }

        $t_loop = new \WP_Query($query_args);

?>

        <div class="fastland--tn-wraper <?php echo esc_attr($settings['t_slider_version']); ?>">
            <div <?php echo $this->get_render_attribute_string('testimonail_version'); ?>>


                <?php while ($t_loop->have_posts()) : $t_loop->the_post();
                    $content = ($settings['t_word_limit']['size']) ? wp_trim_words(get_the_content(), $settings['t_word_limit']['size'], '') : get_the_content();
                ?>

                    <div <?php echo $this->get_render_attribute_string('tn_classes'); ?>>

                        <?php if ('style-one' == $testimonial_style) {
                            include('testimonial/style-one.php');
                        } elseif ('style-two' == $testimonial_style) {
                            include('testimonial/style-two.php');
                        } elseif ('style-three' == $testimonial_style) {
                            include('testimonial/style-three.php');
                        } elseif ('style-four' == $testimonial_style) {
                            include('testimonial/style-four.php');
                        } elseif ('style-five' == $testimonial_style) {
                            include('testimonial/style-five.php');
                        } ?>

                    </div>
                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
<?php
    }
}
$widgets_manager->register(new \Fastland_Testimonail_Loop());
