<?php
// File Security Check
if (!defined('ABSPATH')) {
	exit;
}
class FastlandCustomPosts
{
	function __construct()
	{
		add_action( 'admin_menu', array($this, 'fastland_header_footer_menu') );
		// Header
		add_action('init', array($this, 'fastland_header'));
		add_action('init', array($this, 'fastland_footer'));
		add_action('init', array($this, 'fastland_megamenu'));

		// team 
        if (fastland_check_cpt('team')) {
            add_action('init', array($this, 'fastland_team'));
        }

		// services 
        if (fastland_check_cpt('service')) {
            add_action('init', array($this, 'fastland_service'));
            add_action('init', array($this, 'fastland_service_category'));
            add_action('init', array($this, 'fastland_service_tags'));
        }

		// Portfolios 
        if (fastland_check_cpt('portfolio')) {
            add_action('init', array($this, 'fastland_portfolio'));
            add_action('init', array($this, 'fastland_portfolio_category'));
            add_action('init', array($this, 'fastland_portfolio_tags'));
        }

		// Portfolios 
        if (fastland_check_cpt('job')) {
            add_action('init', array($this, 'fastland_job'));
            add_action('init', array($this, 'fastland_job_category'));
            add_action('init', array($this, 'fastland_job_tags'));
        }

		// Testimonial
        if (fastland_check_cpt('testimonial')) {
            add_action('init', array($this, 'fastland_testimonial'));
            // add_action('init', array($this, 'fastland_portfolio_category'));
            // add_action('init', array($this, 'fastland_portfolio_tags'));
        }

	}

	public function fastland_header_footer_menu() {
		add_menu_page(
			'Header & Footer',
			'Header & Footer',
			'read',
			'header-footer',
			'',
			'dashicons-archive',
			40
		);
	 }
	 /**
	 *
	 * Fastland Header Footer Post Type
	 *
	 */
	public function fastland_header()
	{
		$labels = array(
			'name'               => _x('Header', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Header', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Header', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Header', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Header', 'fastland-hp'),
			'add_new_item'       => __('Add New Header', 'fastland-hp'),
			'new_item'           => __('New Header', 'fastland-hp'),
			'edit_item'          => __('Edit Header', 'fastland-hp'),
			'view_item'          => __('View Header', 'fastland-hp'),
			'all_items'          => __('All Headers', 'fastland-hp'),
			'search_items'       => __('Search Headers', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Headers found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Headers found in Trash.', 'fastland-hp')
		);
		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-id',
			'show_in_menu' 		 => 'header-footer',
			'rewrite'            => array('slug' => 'header'),
			'capability_type'    => 'post',
			'has_archive'        => false,
			'hierarchical'       => true,
			'menu_position'      => null,
			'supports'           => array('title','elementor', 'editor', 'thumbnail',  'page-attributes')
		);
		register_post_type('fastland_header', $args);
	}

	public function fastland_footer()
	{
		$labels = array(
			'name'               => _x('Footer', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Footer', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Footer', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Footer', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Footer', 'fastland-hp'),
			'add_new_item'       => __('Add New Footer', 'fastland-hp'),
			'new_item'           => __('New Footer', 'fastland-hp'),
			'edit_item'          => __('Edit Footer', 'fastland-hp'),
			'view_item'          => __('View Footer', 'fastland-hp'),
			'all_items'          => __('All Footers', 'fastland-hp'),
			'search_items'       => __('Search Footers', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Footers found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Footers found in Trash.', 'fastland-hp')
		);
		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-id',
			'rewrite'            => array('slug' => 'footer'),
			'capability_type'    => 'post',
			'has_archive'        => false,
			'hierarchical'       => true,
			'menu_position'      => null,
			'show_in_menu' 		 => 'header-footer',
			'supports'           => array('title','elementor', 'editor', 'thumbnail',  'page-attributes')
		);
		register_post_type('fastland_footer', $args);
	}


	public function fastland_megamenu()
	{
		$labels = array(
			'name'               => _x('Mega Menu', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Mega Menu', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Mega Menu', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Mega Menu', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Mega Menu', 'fastland-hp'),
			'add_new_item'       => __('Add New Mega Menu', 'fastland-hp'),
			'new_item'           => __('New Mega Menu', 'fastland-hp'),
			'edit_item'          => __('Edit Mega Menu', 'fastland-hp'),
			'view_item'          => __('View Mega Menu', 'fastland-hp'),
			'all_items'          => __('All Mega Menus', 'fastland-hp'),
			'search_items'       => __('Search Mega Menus', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Mega Menus found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Mega Menus found in Trash.', 'fastland-hp')
		);

		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-id',
			'rewrite'            => array('slug' => 'megamenu'),
			'capability_type'    => 'post',
			'has_archive'        => false,
			'hierarchical'       => true,
			'menu_position'      => null,
			// 'show_in_menu' 		 => 'header-footer',
			'supports'           => array('title','elementor', 'thumbnail',  'page-attributes')
		);
		register_post_type('fastland_megamenu', $args);
	}

	/**
	 *
	 * fastland Service Custom Post Type
	 *
	 */
	public function fastland_service()
	{
		$labels = array(
			'name'               => _x('Service', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Service', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Service', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Service', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Service', 'fastland-hp'),
			'add_new_item'       => __('Add New Service', 'fastland-hp'),
			'new_item'           => __('New Service', 'fastland-hp'),
			'edit_item'          => __('Edit Service', 'fastland-hp'),
			'view_item'          => __('View Service', 'fastland-hp'),
			'all_items'          => __('All Services', 'fastland-hp'),
			'search_items'       => __('Search Services', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Services found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Services found in Trash.', 'fastland-hp')
		);
		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-megaphone',
			'rewrite'            => array('slug' => 'service', 'with_front' => true, 'pages' => true, 'feeds' => true),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => true,
			'menu_position'      => null,
			'supports'           => array('elementor', 'title', 'editor', 'thumbnail', 'excerpt', 'page-attributes')
		);
		register_post_type('service', $args);
	}
	public function fastland_service_category()
	{
		$labels = array(
			'name'              => _x('Categories', 'taxonomy general name', 'fastland-hp'),
			'singular_name'     => _x('Category', 'taxonomy singular name', 'fastland-hp'),
			'search_items'      => __('Search Categories', 'fastland-hp'),
			'all_items'         => __('All Categories', 'fastland-hp'),
			'parent_item'       => __('Parent Category', 'fastland-hp'),
			'parent_item_colon' => __('Parent Category:', 'fastland-hp'),
			'edit_item'         => __('Edit Category', 'fastland-hp'),
			'update_item'       => __('Update Category', 'fastland-hp'),
			'add_new_item'      => __('Add New Category', 'fastland-hp'),
			'new_item_name'     => __('New Category Name', 'fastland-hp'),
			'menu_name'         => __('Category', 'fastland-hp'),
		);
		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array('slug' => 'service-category'),
		);
		register_taxonomy('service-category', array('service'), $args);
	}
	public function fastland_service_tags()
	{
		$labels = array(
			'name'              => _x('Tags', 'taxonomy general name', 'fastland-hp'),
			'singular_name'     => _x('Tag', 'taxonomy singular name', 'fastland-hp'),
			'search_items'      => __('Search Tags', 'fastland-hp'),
			'all_items'         => __('All Tags', 'fastland-hp'),
			'parent_item'       => __('Parent Tag', 'fastland-hp'),
			'parent_item_colon' => __('Parent Tag:', 'fastland-hp'),
			'edit_item'         => __('Edit Tag', 'fastland-hp'),
			'update_item'       => __('Update Tag', 'fastland-hp'),
			'add_new_item'      => __('Add New Tag', 'fastland-hp'),
			'new_item_name'     => __('New Tag Name', 'fastland-hp'),
			'menu_name'         => __('Tag', 'fastland-hp'),
		);
		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array('slug' => 'pf-tag'),
		);
		register_taxonomy('service-tag', array('service'), $args);
	}
	/**
	 *
	 * Fastland Team Post Type
	 *
	 */
	public function fastland_team()
	{
		$labels = array(
			'name'               => _x('Team Member', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Team Member', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Team Member', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Team Member', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Member', 'fastland-hp'),
			'add_new_item'       => __('Add New Member', 'fastland-hp'),
			'new_item'           => __('New Member', 'fastland-hp'),
			'edit_item'          => __('Edit Member', 'fastland-hp'),
			'view_item'          => __('View Member', 'fastland-hp'),
			'all_items'          => __('All Team Members', 'fastland-hp'),
			'search_items'       => __('Search Team Members', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Team Members found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Team Members found in Trash.', 'fastland-hp')
		);
		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-id',
			'rewrite'            => array('slug' => 'team', 'with_front' => true, 'pages' => true, 'feeds' => true),
			'capability_type'    => 'post',
			'has_archive'        => false,
			'hierarchical'       => true,
			'menu_position'      => null,
			'supports'           => array('title', 'editor', 'thumbnail',  'page-attributes')
		);
		register_post_type('team', $args);
	}

	/**
	 *
	 * Fastland Portfolio Post Type
	 *
	 */
	public function fastland_portfolio()
	{
		$labels = array(
			'name'               => _x('Portfolio', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Portfolio', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Portfolio', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Portfolio', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Portfolio', 'fastland-hp'),
			'add_new_item'       => __('Add New Portfolio', 'fastland-hp'),
			'new_item'           => __('New Portfolio', 'fastland-hp'),
			'edit_item'          => __('Edit Portfolio', 'fastland-hp'),
			'view_item'          => __('View Portfolio', 'fastland-hp'),
			'all_items'          => __('All Portfolios', 'fastland-hp'),
			'search_items'       => __('Search Portfolios', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Portfolios found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Portfolios found in Trash.', 'fastland-hp')
		);
		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-id',
			'rewrite'            => array('slug' => 'portfolio', 'with_front' => true, 'pages' => true, 'feeds' => true),
			'capability_type'    => 'post',
			'has_archive'        => false,
			'hierarchical'       => true,
			'menu_position'      => null,
			'supports'           => array('title', 'elementor', 'editor', 'thumbnail',  'page-attributes')
		);
		register_post_type('portfolio', $args);
	}
	public function fastland_portfolio_category()
	{
		$labels = array(
			'name'              => _x('Categories', 'taxonomy general name', 'fastland-hp'),
			'singular_name'     => _x('Category', 'taxonomy singular name', 'fastland-hp'),
			'search_items'      => __('Search Categories', 'fastland-hp'),
			'all_items'         => __('All Categories', 'fastland-hp'),
			'parent_item'       => __('Parent Category', 'fastland-hp'),
			'parent_item_colon' => __('Parent Category:', 'fastland-hp'),
			'edit_item'         => __('Edit Category', 'fastland-hp'),
			'update_item'       => __('Update Category', 'fastland-hp'),
			'add_new_item'      => __('Add New Category', 'fastland-hp'),
			'new_item_name'     => __('New Category Name', 'fastland-hp'),
			'menu_name'         => __('Category', 'fastland-hp'),
		);
		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array('slug' => 'portfolio-category'),
		);
		register_taxonomy('portfolio-category', array('portfolio'), $args);
	}
	public function fastland_portfolio_tags()
	{
		$labels = array(
			'name'              => _x('Tags', 'taxonomy general name', 'fastland-hp'),
			'singular_name'     => _x('Tag', 'taxonomy singular name', 'fastland-hp'),
			'search_items'      => __('Search Tags', 'fastland-hp'),
			'all_items'         => __('All Tags', 'fastland-hp'),
			'parent_item'       => __('Parent Tag', 'fastland-hp'),
			'parent_item_colon' => __('Parent Tag:', 'fastland-hp'),
			'edit_item'         => __('Edit Tag', 'fastland-hp'),
			'update_item'       => __('Update Tag', 'fastland-hp'),
			'add_new_item'      => __('Add New Tag', 'fastland-hp'),
			'new_item_name'     => __('New Tag Name', 'fastland-hp'),
			'menu_name'         => __('Tag', 'fastland-hp'),
		);
		$args = array(
			'hierarchical'      => false,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array('slug' => 'portfolio-tag'),
		);
		register_taxonomy('portfolio-tag', array('portfolio'), $args);
	}

	/**
	 *
	 * Fastland Job Post Type
	 *
	 */
	public function fastland_job()
	{
		$labels = array(
			'name'               => _x('Job', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Job', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Job', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Job', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Job', 'fastland-hp'),
			'add_new_item'       => __('Add New Job', 'fastland-hp'),
			'new_item'           => __('New Job', 'fastland-hp'),
			'edit_item'          => __('Edit Job', 'fastland-hp'),
			'view_item'          => __('View Job', 'fastland-hp'),
			'all_items'          => __('All Jobs', 'fastland-hp'),
			'search_items'       => __('Search Jobs', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Jobs found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Jobs found in Trash.', 'fastland-hp')
		);
		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-id',
			'rewrite'            => array('slug' => 'job', 'with_front' => true, 'pages' => true, 'feeds' => true),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => true,
			'menu_position'      => null,
			'supports'           => array('title', 'elementor', 'editor', 'thumbnail',  'page-attributes')
		);
		register_post_type('job', $args);
	}
	public function fastland_job_category()
	{
		$labels = array(
			'name'              => _x('Categories', 'taxonomy general name', 'fastland-hp'),
			'singular_name'     => _x('Category', 'taxonomy singular name', 'fastland-hp'),
			'search_items'      => __('Search Categories', 'fastland-hp'),
			'all_items'         => __('All Categories', 'fastland-hp'),
			'parent_item'       => __('Parent Category', 'fastland-hp'),
			'parent_item_colon' => __('Parent Category:', 'fastland-hp'),
			'edit_item'         => __('Edit Category', 'fastland-hp'),
			'update_item'       => __('Update Category', 'fastland-hp'),
			'add_new_item'      => __('Add New Category', 'fastland-hp'),
			'new_item_name'     => __('New Category Name', 'fastland-hp'),
			'menu_name'         => __('Category', 'fastland-hp'),
		);
		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array('slug' => 'job-category'),
		);
		register_taxonomy('job-category', array('job'), $args);
	}
	public function fastland_job_tags()
	{
		$labels = array(
			'name'              => _x('Tags', 'taxonomy general name', 'fastland-hp'),
			'singular_name'     => _x('Tag', 'taxonomy singular name', 'fastland-hp'),
			'search_items'      => __('Search Tags', 'fastland-hp'),
			'all_items'         => __('All Tags', 'fastland-hp'),
			'parent_item'       => __('Parent Tag', 'fastland-hp'),
			'parent_item_colon' => __('Parent Tag:', 'fastland-hp'),
			'edit_item'         => __('Edit Tag', 'fastland-hp'),
			'update_item'       => __('Update Tag', 'fastland-hp'),
			'add_new_item'      => __('Add New Tag', 'fastland-hp'),
			'new_item_name'     => __('New Tag Name', 'fastland-hp'),
			'menu_name'         => __('Tag', 'fastland-hp'),
		);
		$args = array(
			'hierarchical'      => false,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array('slug' => 'job-tag'),
		);
		register_taxonomy('job-tag', array('job'), $args);
	}
	
	//Testimonial
	public function fastland_testimonial()
	{
		$labels = array(
			'name'               => _x('Testimonial', 'post type general name', 'fastland-hp'),
			'singular_name'      => _x('Testimonial', 'post type singular name', 'fastland-hp'),
			'menu_name'          => _x('Testimonial', 'admin menu', 'fastland-hp'),
			'name_admin_bar'     => _x('Testimonial', 'add new on admin bar', 'fastland-hp'),
			'add_new'            => __('Add New Testimonial', 'fastland-hp'),
			'add_new_item'       => __('Add New Testimonial', 'fastland-hp'),
			'new_item'           => __('New Testimonial', 'fastland-hp'),
			'edit_item'          => __('Edit Testimonial', 'fastland-hp'),
			'view_item'          => __('View Testimonial', 'fastland-hp'),
			'all_items'          => __('All Testimonial', 'fastland-hp'),
			'search_items'       => __('Search Testimonial', 'fastland-hp'),
			'parent_item_colon'  => __('Parent :', 'fastland-hp'),
			'not_found'          => __('No Testimonial found.', 'fastland-hp'),
			'not_found_in_trash' => __('No Testimonial found in Trash.', 'fastland-hp')
		);
		$args = array(
			'labels'             => $labels,
			'description'        => __('Description.', 'fastland-hp'),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'menu_icon'          => 'dashicons-testimonial',
			'rewrite'            => array('slug' => 'fastland_testimonial', 'with_front' => true, 'pages' => true, 'feeds' => true),
			'capability_type'    => 'post',
			'has_archive'        => false,
			'hierarchical'       => true,
			'menu_position'      => null,
			'supports'           => array('title', 'editor', 'thumbnail',  'page-attributes')
		);
		register_post_type('fastland_testimonial', $args);
	}
	public function fastland_testimonial_category()
		{
			$labels = array(
				'name'              => _x('Categories', 'taxonomy general name', 'fastland-hp'),
				'singular_name'     => _x('Category', 'taxonomy singular name', 'fastland-hp'),
				'search_items'      => __('Search Categories', 'fastland-hp'),
				'all_items'         => __('All Categories', 'fastland-hp'),
				'parent_item'       => __('Parent Category', 'fastland-hp'),
				'parent_item_colon' => __('Parent Category:', 'fastland-hp'),
				'edit_item'         => __('Edit Category', 'fastland-hp'),
				'update_item'       => __('Update Category', 'fastland-hp'),
				'add_new_item'      => __('Add New Category', 'fastland-hp'),
				'new_item_name'     => __('New Category Name', 'fastland-hp'),
				'menu_name'         => __('Category', 'fastland-hp'),
			);
			$args = array(
				'hierarchical'      => true,
				'labels'            => $labels,
				'show_ui'           => true,
				'show_admin_column' => true,
				'query_var'         => true,
				'rewrite'           => array('slug' => 'portfolio-category'),
			);
			register_taxonomy('testimonial_category', array('fastland_testimonial'), $args);
		}
		public function fastland_testimonial_tags()
		{
			$labels = array(
				'name'              => _x('Tags', 'taxonomy general name', 'fastland-hp'),
				'singular_name'     => _x('Tag', 'taxonomy singular name', 'fastland-hp'),
				'search_items'      => __('Search Tags', 'fastland-hp'),
				'all_items'         => __('All Tags', 'fastland-hp'),
				'parent_item'       => __('Parent Tag', 'fastland-hp'),
				'parent_item_colon' => __('Parent Tag:', 'fastland-hp'),
				'edit_item'         => __('Edit Tag', 'fastland-hp'),
				'update_item'       => __('Update Tag', 'fastland-hp'),
				'add_new_item'      => __('Add New Tag', 'fastland-hp'),
				'new_item_name'     => __('New Tag Name', 'fastland-hp'),
				'menu_name'         => __('Tag', 'fastland-hp'),
			);
			$args = array(
				'hierarchical'      => false,
				'labels'            => $labels,
				'show_ui'           => true,
				'show_admin_column' => true,
				'query_var'         => true,
				'rewrite'           => array('slug' => 'portfolio-tag'),
			);
			register_taxonomy('testimonial_tag', array('fastland_testimonial'), $args);
		}
}
$fastlandCcases_stydyInstance = new FastlandCustomPosts;
