<?php
// File Security Check
if (!defined('ABSPATH')) {
	exit;
}
function fastland_theme_options_style()
{
	// Globalizing theme options values
	$fastland = get_option('fastland');
	//
	// Enqueueing StyleSheet file
	//
	wp_enqueue_style('fastland-theme-options-style', get_theme_file_uri( '/assets/css/theme_options_style.css'));
	$page_id = get_the_ID();
	$css_output = '';
	/*=============================================
	=            CUSTOM BACKGROUND STYLE          =
	=============================================*/

	if (isset($fastland['logo_max_width_desktop'])) {
		$css_output .= "
			.site-branding,.site-logo{
				max-width: {$fastland['logo_max_width_desktop']}px;
			}
		";
	}
	if (isset($fastland['logo_max_width_mobile'])) {
		$css_output .= "
			@media (max-width: 680px){
				.site-branding, .site-logo{
					max-width: {$fastland['logo_max_width_mobile']}px;
				}
			}
		";
	}

	// theme color set 
	if (isset($fastland['custom_accent_color']) || isset($fastland['heading_color']) || isset($fastland['text_color'])) {

		$body_bg_color = !empty($fastland['body_bg_color']) ? $fastland['body_bg_color'] : '#fff';
		$accent_color = !empty($fastland['custom_accent_color']) ? $fastland['custom_accent_color'] : '';
		$accent_colo_2r = !empty($fastland['custom_accent_color_2']) ? $fastland['custom_accent_color_2'] : '';
		$heading_color = !empty($fastland['heading_color']) ? $fastland['heading_color'] : '';
		$text_color = !empty($fastland['text_color'])? $fastland['text_color'] : '' ;

		$css_output .= "
		:root {";

			if(!empty($accent_color)){
				$css_output .= "--accent-color: {$fastland['custom_accent_color']};";
			}
			if(!empty($accent_color_2)){
				$css_output .= "--accent-color-2: {$fastland['custom_accent_color_2']};";
			}
			if(!empty($heading_color)){
				$css_output .= "--heading-color: {$fastland['heading_color']};";
			}
			if(!empty($text_color)){
				$css_output .= "--text-color: {$fastland['text_color']};";
			}

			$css_output .= "
		}

		body {
			background-color: {$body_bg_color};
		}

		";


		update_option( 'elementor_scheme_color', array($heading_color, $heading_color, $text_color, $accent_color) );

	
	}

	//
	// Header Buttons Color
	//
	$body_background_color = get_post_meta(get_the_ID(), 'body_background_color', true);

	if ($body_background_color) {
		$css_output .= "
			body.page-id-{$page_id} {
				background-color: {$body_background_color};
			}
		";
	}
	



	wp_add_inline_style('fastland-theme-options-style', $css_output);

}
add_action('wp_enqueue_scripts', 'fastland_theme_options_style');

