<?php
// File Security Check
if (!defined('ABSPATH')) {
	exit;
}



/* Theme demo data setup */
function fastland_import_files()
{
    return array(
        array(
            'import_file_name' => 'Initial Setup',
            'categories' => array('Inner Pages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/initial-setup.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/screenshot.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/',
        ),
        array(
            'import_file_name' => 'Marketing - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/marketing.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/marketing.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland',
        ),
        array(
            'import_file_name' => 'Marketing - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/marketing-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/marketing.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/marketing-onepage',
        ),


        array(
            'import_file_name' => 'Project Management - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/project-management.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/project-management.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/project-management',
        ),
        array(
            'import_file_name' => 'Project Management - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/project-management-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/project-management.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/project-management',
        ),


        array(
            'import_file_name' => 'IT Service - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/it-service.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/it-service.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/it-service',
        ),
        array(
            'import_file_name' => 'IT Service - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/it-service-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/it-service.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/it-service-onepage',
        ),


        array(
            'import_file_name' => 'SaaS Service - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/saas-service.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/saas-service.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/saas-service',
        ),
        array(
            'import_file_name' => 'SaaS Service - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/saas-service-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/saas-service.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/saas-service-onepage',
        ),



        array(
            'import_file_name' => 'Agency - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/agency.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/agency.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/agency',
        ),
        array(
            'import_file_name' => 'Agency - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/agency-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/agency.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/agency-onepage',
        ),


        array(
            'import_file_name' => 'App Presentation - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/app-presentation.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/app-presentation.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/app-presentation',
        ),
        array(
            'import_file_name' => 'App Presentation - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/app-presentation-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/app-presentation.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/app-presentation-onepage',
        ),


        array(
            'import_file_name' => 'Digital Agency - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/digital-agency.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/digital-agency.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/digital-agency',
        ),
        array(
            'import_file_name' => 'Digital Agency - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/digital-agency-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/digital-agency.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/digital-agency-onepage',
        ),


        array(
            'import_file_name' => 'Startup - Multi Page',
            'categories' => array('Multi Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/startup.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/startup.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/startup',
        ),
        array(
            'import_file_name' => 'Startup - One Page',
            'categories' => array('One Page'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/startup-onepage.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'fastland',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/fastland/inc/demo-contents/previews/startup.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'fastland'),
            'preview_url' => 'https://finestwp.co/demos/wp/fastland/startup-onepage',
        ),

        
       

    );
}
add_filter('pt-ocdi/import_files', 'fastland_import_files');




function ocdi_after_import($selected_import)
{    

    // Assign front page and posts page (blog page).
    if ('Marketing - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Marketing');
    } elseif ('Project Management - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Project Management');
    } elseif ('IT Service - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('IT Service');
    }elseif ('SaaS Service - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('SaaS Service');
    }elseif ('Agency - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Agency');
    }elseif ('App Presentation - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('App Presentation');
    }elseif ('Digital Agency - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Digital Agency');
    }elseif ('Startup - Multi Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Startup');
    }
    
    elseif ('Marketing - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Marketing OnePage');
    } elseif ('Project Management - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Project Management OnePage');
    } elseif ('IT Service - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('IT Service OnePage');
    }elseif ('SaaS Service - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('SaaS Service OnePage');
    }elseif ('Agency - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Agency OnePage');
    }elseif ('App Presentation - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('App Presentation OnePage');
    }elseif ('Digital Agency - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Digital Agency OnePage');
    }elseif ('Startup - One Page' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('Startup OnePage');
    }else{
        $front_page_id = get_page_by_title('Marketing');
    }
    // Assign front page and posts page (blog page).


    $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

    set_theme_mod('nav_menu_locations', array(
        'main-menu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function
    ));
    
    $blog_page_id  = get_page_by_title('Blog');
    update_option('show_on_front', 'page');
    update_option('page_on_front', $front_page_id->ID);
    update_option('page_for_posts', $blog_page_id->ID);

    $elem_clear_cache = new \Elementor\Core\Files\Manager();
    $elem_clear_cache->clear_cache();

}
add_action('pt-ocdi/after_import', 'ocdi_after_import');
