<?php
    $idd = get_the_ID();
    $categories = get_the_terms($idd, 'job-category');

    $jf_cat_name = '';

    if (!empty($categories)) {
        $jf_cat_name = join(' ', wp_list_pluck($categories, 'name'));
        $jf_cat_slug = join(' ', wp_list_pluck($categories, 'slug'));
    }
    ?>
      <?php if(function_exists('the_field')): ?>
        <?php 
          $job_location =  get_field('job_location');
          $job_type    =  get_field('fastlands_job_type'); 
          $salary       =  get_field('salary');
          $button_text  =  get_field('button_text');
          $button_url   =  get_field('button_url');
          $show_date   =  get_field('button_url');
        ?>
      <?php endif; ?>

      


<div class="col-lg-4 col-md-6">
    <div id="post-<?php the_ID(); ?>" class="<?php printf('fastland-job-item-wrap %s',$jf_cat_slug); ?>">
        <div class="jobs-area__tab">
            <div class="card card--single">
            <h3 class="card__heading"><?php the_title(); ?></h3>
            <ul class="card__list list-unstyled">

                <?php if(!empty( $job_location ) && function_exists('the_field') ): ?>
                <li>
                    <i class="fa fa-map-marker-alt text-electric-violet-2"></i> 
                    <?php echo esc_html($job_location)  ?>
                </li>
                <?php endif; ?>

                <?php if(!empty( $show_date ) && function_exists('the_field') ): ?>
                      <li>
                        <i class="fa fa-clock text-electric-violet-2"></i>
                         <?php _e('Posted', 'fastland')  ?> 8 <?php _e('hours ago', 'fastland' )?>
                      </li>
                <?php endif; ?>

                <?php if(!empty( $job_type ) && function_exists('the_field') ): ?>
                <li>
                    <i class="fa fa-briefcase text-electric-violet-2"></i>
                    <?php echo esc_html($job_type)  ?>
                </li>
                <?php endif; ?>


                <?php if(!empty( $salary ) &&  function_exists('the_field') ): ?>
                <li><i class="fa fa-briefcase text-electric-violet-2"></i>
                <?php echo esc_html($salary)  ?>
                </li>
                <?php endif; ?>

            </ul>
            
            <!-- <?php echo esc_url($button_url); ?> -->

            <?php if(!empty($button_text ) &&  function_exists('the_field') ): ?>
                <a class="falsland-job-btn" target="_blank" href="<?php the_permalink(); ?>"><?php echo esc_html($button_text ) ?></a>
            <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<?php

