<?php

/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class FastlandTeam extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'fastland_team';
    }
    public function get_title()
    {
        return __('FastLand Team', 'fastland-hp');
    }
    public function get_icon()
    {
        return ('eicon-person');
    }
    public function get_categories()
    {
        return ['fastland-addons'];
    }
    public function get_keywords()
    {
        return ['team', 'membar', 'portfolio'];
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'team_section',
            [
                'label' => __('Team Section', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'membar_per_page',
            [
                'label'       => __('Numbar Of Membar', 'fastland-hp'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'description' => 'user emty value show all posts',
            ]
        );

        $this->add_control(
            'post_by',
            [
                'label' => __('Post By:', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'default' => 'latest',
                'label_block' => true,
                'options' => array(
                    'latest'   =>   __('Latest Post', 'fastland-hp'),
                    'selected' =>   __('Selected posts', 'fastland-hp'),
                ),
            ]
        );
        $this->add_control(
            'post__in',
            [
                'label' => __('Post In', 'fastland-hp'),
                'type' => Controls_Manager::SELECT2,
                'options' => fastland_get_all_posts('team'),
                'multiple' => true,
                'label_block' => true,
                'condition'   => [
                    'post_by' => 'selected',
                ]
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => __('Order By', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'options' => fastland_get_post_orderby_options(),
                'default' => 'date',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'asc' => 'Ascending',
                    'desc' => 'Descending',
                ],
                'default' => 'desc',
                'label_block' => true,

            ]
        );
        $this->end_controls_section();

        //Slider Setting
        $this->start_controls_section(
            'slider_settings',
            [
                'label' => __('Slider Settings', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'per_coulmn',
            [
                'label' => __('Slider Items', 'fastland-hp'),
                'type' => Controls_Manager::SELECT,
                'default'            => 3,
                'tablet_default'     => 2,
                'mobile_default'     => 1,
                'options'            => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_control(
            'arrows',
            [
                'label' => __('Show arrows?', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'dots',
            [
                'label' => __('Show Dots?', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'mousedrag',
            [
                'label' => __('MouseDrag?', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __('Auto Play?', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'loop',
            [
                'label' => __('Infinite Loop', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'fastland-hp'),
                'label_off' => __('Hide', 'fastland-hp'),
                'return_value' => 'yes',
                'default' => 'true',
            ]
        );
        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __('Autoplay Timeout', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '5000',
                'options' => [
                    '1000'  => __('1 Second', 'fastland-hp'),
                    '2000'  => __('2 Second', 'fastland-hp'),
                    '3000'  => __('3 Second', 'fastland-hp'),
                    '4000'  => __('4 Second', 'fastland-hp'),
                    '5000'  => __('5 Second', 'fastland-hp'),
                    '6000'  => __('6 Second', 'fastland-hp'),
                    '7000'  => __('7 Second', 'fastland-hp'),
                    '8000'  => __('8 Second', 'fastland-hp'),
                    '9000'  => __('9 Second', 'fastland-hp'),
                    '10000' => __('10 Second', 'fastland-hp'),
                    '11000' => __('11 Second', 'fastland-hp'),
                    '12000' => __('12 Second', 'fastland-hp'),
                    '13000' => __('13 Second', 'fastland-hp'),
                    '14000' => __('14 Second', 'fastland-hp'),
                    '15000' => __('15 Second', 'fastland-hp'),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'arrow_prev_icon',
            [
                'label' => __('Previous Icon', 'fastland'),
                'label_block' => false,
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-chevron-left',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'arrow_next_icon',
            [
                'label' => __('Next Icon', 'fastland'),
                'label_block' => false,
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-chevron-right',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        *Image
        */
        $this->start_controls_section(
            'team_box_iamge',
            [
                'label' => __('Image', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'image_border',
                'selector'  => '{{WRAPPER}} .fastland--team-thum img',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'image_box_shadow',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .fastland--team-thum img',
            ]
        );

        $this->add_responsive_control(
            'width',
            [
                'label'          => __('Width', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--team-thum img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'space',
            [
                'label'          => __('Max Width', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', '%', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--team-thum img' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label'          => __('Height', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--team-thum img' => 'height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'object-fit',
            [
                'label'     => __('Object Fit', 'fastland-hp'),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'height[size]!' => '',
                ],
                'options'   => [
                    ''        => __('Default', 'fastland-hp'),
                    'fill'    => __('Fill', 'fastland-hp'),
                    'cover'   => __('Cover', 'fastland-hp'),
                    'contain' => __('Contain', 'fastland-hp'),
                ],
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--team-thum img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => __('Border Radius', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--team-thum img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team-thum img' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        *Name
        */
        $this->start_controls_section(
            'team_box_name',
            [
                'label' => __('Name', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'fastland_team_name_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--team-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'fastland_team_name_style',
                'label'    => __('Typography', 'fastland-hp'),
                'selector' => '{{WRAPPER}}  .fastland--team-name',
            ]
        );
        $this->add_responsive_control(
            'fastland_team_name_padding',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--team-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team-name' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        *Title
        */
        $this->start_controls_section(
            'team_box_position',
            [
                'label' => __('Designation', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'fastland_team_position_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--team-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'fastland_team_position_style',
                'label'    => __('Typography', 'fastland-hp'),
                'selector' => '{{WRAPPER}}  .fastland--team-title',
            ]
        );
        $this->add_responsive_control(
            'fastland_team_position_padding',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--team-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team-title' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /*
   * 
    Dots
   */
        $this->start_controls_section(
            'dots_navigation',
            [
                'label' => __('Navigation - Dots', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs('_tabs_dots');

        $this->start_controls_tab(
            '_tab_dots_normal',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );
        $this->add_control(
            'dots_color',
            [
                'label' => __('Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_box_width',
            [
                'label' => __('Width', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_box_height',
            [
                'label' => __('Height', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_dots_active',
            [
                'label' => __('Active', 'fastland-hp'),
            ]
        );
        $this->add_control(
            'dots_color_active',
            [
                'label' => __('Active Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot.active span' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_dots_box_active_width',
            [
                'label' => __('Width', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot.active span' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_dots_box_active_height',
            [
                'label' => __('Height', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot.active span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();



        $this->add_control(
            'hrfour',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'fastland-hp'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => __('Left', 'fastland-hp'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'fastland-hp'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => __('Right', 'fastland-hp'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'dots_position_toggle',
            [
                'label' => __('Position', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off' => __('None', 'fastland-hp'),
                'label_on' => __('Custom', 'fastland-hp'),
                'return_value' => 'yes',
            ]
        );
        $this->start_popover();

        /* 
    dots Position
    */
        $this->add_responsive_control(
            'dots_position_y',
            [
                'label' => __('Vertical', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'condition' => [
                    'dots_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-dots' => 'top: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_position_x',
            [
                'label' => __('Horizontal', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'condition' => [
                    'dots_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .fastland--team .owl-dots' => 'right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team .owl-dots' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_popover();

        $this->add_responsive_control(
            'dots_margin',
            [
                'label'          => __('Gap Right', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'range'          => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot span' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team .owl-dots .owl-dot span' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_border_radius',
            [
                'label'      => __('Border Radius', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--team .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team .owl-dots .owl-dot span' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /*
   * 
    Arrows
   */
        $this->start_controls_section(
            'arrows_navigation',
            [
                'label' => __('Navigation - Arrow', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('_tabs_arrow');

        $this->start_controls_tab(
            '_tab_arrow_normal',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => __('Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-nav i' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--team .owl-nav svg path' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_color_fill',
            [
                'label' => __('Line Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-nav i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--team .owl-nav svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label' => __('Background Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-next, .fastland--team .owl-prev' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'arrow_shadow',
                'label' => __('Shadow', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fastland--team .owl-next, {{WRAPPER}} .fastland--team .owl-prev',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            '_tab_arrow_hover',
            [
                'label' => __('Hover', 'fastland-hp'),
            ]
        );

        $this->add_control(
            'arrow_hover_color',
            [
                'label' => __('Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-nav *:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--team .owl-nav *:hover svg path' => 'stroke: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_fill_color',
            [
                'label' => __('Line Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-nav *:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .fastland--team .owl-nav *:hover svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_hover_color',
            [
                'label' => __('Background Color Hover', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-next:hover, .fastland--team .owl-prev:hover' => 'background-color: {{VALUE}}  !important;',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'arrow_hover_shadow',
                'label' => __('Shadow Hover', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fastland--team .owl-next:hover, {{WRAPPER}} .fastland--team .owl-prev:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'hrthere',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'arrow_position_toggle',
            [
                'label' => __('Position', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off' => __('None', 'fastland-hp'),
                'label_on' => __('Custom', 'fastland-hp'),
                'return_value' => 'yes',
            ]
        );
        $this->start_popover();

        /* 
Arrow Position
*/
        $this->add_responsive_control(
            'arrow_position_y',
            [
                'label' => __('Vertical', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-nav' => 'top: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_position_x',
            [
                'label' => __('Horizontal', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .fastland--team .owl-nav' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team .owl-nav' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'arrow_position_right_gap',
            [
                'label' => __('Prev Aarrow Gap', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'condition' => [
                    'arrow_position_toggle' => 'yes'
                ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                    ],
                ],
                'selectors' => [
                    'body:not(.rtl) {{WRAPPER}} .fastland--team .owl-nav button.owl-next' => 'margin-right: {{SIZE}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team .owl-nav  button.owl-prev' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_popover();

        $this->add_responsive_control(
            'arrow_icon_size',
            [
                'label' => __('Icon Size', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland--team .owl-nav i' => 'font-size: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}}  .fastland--team .owl-nav svg' => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_size_box',
            [
                'label' => __('Size', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 150,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland--team .owl-next, .fastland--team .owl-prev' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        *Content Box
        */
        $this->start_controls_section(
            'social_links',
            [
                'label' => __('Social Profile', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'social_links_size',
            [
                'label'          => __('Size', 'fastland-hp'),
                'type'           => Controls_Manager::SLIDER,
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .fastlandteam-socail-links i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .fastlandteam-socail-links svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => __('Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastlandteam-socail-links i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastlandteam-socail-links svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastlandteam-socail-links svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'line_icon_color',
            [
                'label'     => __('Line Color', 'fastland-hp'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastlandteam-socail-links i,
                     {{WRAPPER}} .fastlandteam-socail-links svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .fastlandteam-socail-links svg path' => 'stroke: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_links_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastlandteam-socail-links i, .fastlandteam-socail-links svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastlandteam-socail-links i, .fastlandteam-socail-links svg' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        *Content Box
        */
        $this->start_controls_section(
            'team_content_box',
            [
                'label' => __('Content Box', 'fastland-hp'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'fd_addons_pricing_table_promo_background',
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .fastland--team-content-hover',
            ]
        );

        $this->add_responsive_control(
            'fastland_team_content',
            [
                'label'      => __('Padding', 'fastland-hp'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .fastland--team-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .fastland--team-content' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function get_render_icon($icon)
    {
        ob_start();
        \Elementor\Icons_Manager::render_icon($icon, ['aria-hidden' => 'true']);
        return ob_get_clean();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        //this code course slider option
        $slider_extraSetting = array(

            'next_icon' => $this->get_render_icon($settings['arrow_next_icon']),
            'prev_icon' => $this->get_render_icon($settings['arrow_prev_icon']),
            'loop' => (isset($settings['loop']) && 'yes' === $settings['loop']) ? true : false,
            'autoplay' => (isset($settings['autoplay']) && 'yes' === $settings['autoplay']) ? true : false,
            'nav' => (isset($settings['arrows']) && 'yes' === $settings['arrows']) ? true : false,
            'dots' => (isset($settings['dots']) && 'yes' === $settings['dots']) ? true : false,
            'mousedrag' => (isset($settings['mousedrag']) && 'yes' === $settings['mousedrag']) ? true : false,
            'autoplaytimeout' => isset($settings['autoplaytimeout']) ? $settings['autoplaytimeout'] : '5000',

            //this a responsive layout
            'per_coulmn' => (isset($settings['per_coulmn'])) ? $settings['per_coulmn'] : 3,
            'per_coulmn_tablet' => (isset($settings['per_coulmn_tablet'])) ? $settings['per_coulmn_tablet'] : 2,
            'per_coulmn_mobile' => (isset($settings['per_coulmn_mobile'])) ? $settings['per_coulmn_mobile'] : 1
        );
        $jasondecode = wp_json_encode($slider_extraSetting);
        $this->add_render_attribute('team_version', 'class', array('fastland--team', 'owl-carousel'));
        $this->add_render_attribute('team_version', 'data-settings', $jasondecode);

        // Query
        $numabr_of_membar = isset($settings['membar_per_page']) ? $settings['membar_per_page'] : -1;
        $query_args = [
            'post_type'           => 'team',
            'orderby' => $settings['orderby'],
            'order'   => $settings['order'],
            'posts_per_page'      => $numabr_of_membar,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
        ];

        // get_type
        if ('selected' === $settings['post_by']) {
            $query_args['post__in'] = (array)$settings['post__in'];
        }

        $fastland_teams = new \WP_Query($query_args);
?>
        <div class="fastland--team-wraper">
            <div <?php echo $this->get_render_attribute_string('team_version'); ?>>

                <?php while ($fastland_teams->have_posts()) : $fastland_teams->the_post();  ?>
                    <div class="fastland--team-single ">
                        <div class="fastland--team-thum">
                            <?php the_post_thumbnail('large'); ?>
                        </div>
                        <div class="fastland--team-content-hover">
                            <div class="fastland--team-content">
                                <h3 class="fastland--team-name"><?php the_title() ?></h3>
                                <?php if (function_exists('the_field')) : ?>
                                    <span class="fastland--team-title"><?php the_field('position') ?></span>
                                <?php endif; ?>

                                <?php if (function_exists('the_field')) :
                                    $social_links = get_field('social_links');
                                ?>
                                    <div class="fastlandteam-socail-links">
                                        <?php foreach ($social_links as  $social_link) :
                                        ?>
                                            <a href="<?php echo esc_url($social_link['url']); ?>">
                                                <?php echo $social_link['icon'] ?>
                                            </a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile;
                wp_reset_postdata(); ?>
            </div>
        </div>
<?php
    }
}
$widgets_manager->register(new \FastlandTeam());
