<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package fastland
 */

get_header();
?>

<div class="error-404 not-found">
	<div class="container">
		<div class="row justify-content-center text-center">
			<div class="col-md-6">
				<img src="<?php echo esc_url( get_theme_file_uri('/assets/img/404.png') );  ?>" alt="<?php echo esc_attr('404 page') ?>">

				<h1><?php echo esc_html__( '404', 'fastland' ) ?></h1>
				<h4><?php echo esc_html__( 'Page not found', 'fastland' ) ?></h4>
				<p><?php echo esc_html__('The page you are looking for is not available or doesn’t belong to this website!', 'fastland') ?></p>
				<a href="<?php echo esc_url(home_url()) ?>" class="fastland-btn"><?php echo esc_html__( 'Go back', 'fastland' ) ?></a>
			</div>
		</div>
	</div>
</div><!-- .error-404 -->


<?php
get_footer();
