<?php
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'acf_add_local_field_group' ) ):

    acf_add_local_field_group( array(
        'key'                   => 'group_5b5ab6357a14d',
        'title'                 => 'Page Options',
        'fields'                => array(
            array(
                'key'               => 'field_5b5db8adfad44',
                'label'             => 'General',
                'name'              => '',
                'type'              => 'tab',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'placement'         => 'left',
                'endpoint'          => 0,
            ),
            array(
                'key'               => 'field_5c721ec24addf',
                'label'             => 'Body Background Color',
                'name'              => 'body_background_color',
                'type'              => 'color_picker',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => '',
            ),
            array(
                'key'               => 'field_5b5db828d1eb4',
                'label'             => 'Header',
                'name'              => '',
                'type'              => 'tab',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'placement'         => 'left',
                'endpoint'          => 0,
            ),

            array(
                'key'               => 'field_5c71891eb2114',
                'label'             => 'Logo',
                'name'              => '',
                'type'              => 'tab',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'placement'         => 'top',
                'endpoint'          => 0,
            ),
            array(
                'key'               => 'field_5c718923b2115',
                'label'             => 'Use Custom Logo',
                'name'              => 'use_custom_logo',
                'type'              => 'true_false',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'message'           => '',
                'default_value'     => 0,
                'ui'                => 0,
                'ui_on_text'        => '',
                'ui_off_text'       => '',
            ),
            array(
                'key'               => 'field_5c71894cb2116',
                'label'             => 'Select Logo',
                'name'              => 'select_logo',
                'type'              => 'image',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field'    => 'field_5c718923b2115',
                            'operator' => '==',
                            'value'    => '1',
                        ),
                    ),
                ),
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'return_format'     => 'url',
                'preview_size'      => 'full',
                'library'           => 'all',
                'min_width'         => '',
                'min_height'        => '',
                'min_size'          => '',
                'max_width'         => '',
                'max_height'        => '',
                'max_size'          => '',
                'mime_types'        => '',
            ),

        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'page',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
    ) );

    acf_add_local_field_group( array(
        'key'                   => 'group_5b82b1e19608e',
        'title'                 => 'Post Page Layout',
        'fields'                => array(
            array(
                'key'               => 'field_5b82b1e86dd24',
                'label'             => 'Use Custom Page Layout?',
                'name'              => 'use_custom_page_layout',
                'type'              => 'true_false',
                'instructions'      => 'Check this to override theme default single page layout function to any custom layout for this page only.',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'message'           => 'Yes',
                'default_value'     => 0,
                'ui'                => 0,
                'ui_on_text'        => '',
                'ui_off_text'       => '',
            ),
            array(
                'key'               => 'field_5b82b1fd6dd25',
                'label'             => 'Select Custom Layout',
                'name'              => 'select_custom_layout',
                'type'              => 'select',
                'instructions'      => 'Select custom page layout for this posts page.',
                'required'          => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field'    => 'field_5b82b1e86dd24',
                            'operator' => '==',
                            'value'    => '1',
                        ),
                    ),
                ),
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'choices'           => array(
                    'fullpage'      => 'Full Page',
                    'left-sidebar'  => 'Left Sidebar',
                    'right-sidebar' => 'Right Sidebar',
                ),
                'default_value'     => false,
                'allow_null'        => 0,
                'multiple'          => 0,
                'ui'                => 0,
                'return_format'     => 'value',
                'ajax'              => 0,
                'placeholder'       => '',
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'post',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'side',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
        'modified'              => false,
    ) );

    acf_add_local_field_group( array(
        'key'                   => 'group_5f69fd565b256',
        'title'                 => 'Team Meta',
        'fields'                => array(
            array(
                'key'               => 'field_5f69fd73be1bc',
                'label'             => 'General',
                'name'              => '',
                'type'              => 'tab',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'placement'         => 'left',
                'endpoint'          => 0,
            ),
            array(
                'key'               => 'field_5f69fd83be1bd',
                'label'             => 'Position',
                'name'              => 'position',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => '',
                'placeholder'       => 'Founder',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
            array(
                'key'               => 'field_5f69fdfe6c023',
                'label'             => 'Social Links',
                'name'              => 'social_links',
                'type'              => 'repeater',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'collapsed'         => '',
                'min'               => 0,
                'max'               => 0,
                'layout'            => 'table',
                'button_label'      => '',
                'sub_fields'        => array(
                    array(
                        'key'               => 'field_5f69fe0f6c024',
                        'label'             => 'icon',
                        'name'              => 'icon',
                        'type'              => 'font-awesome',
                        'instructions'      => '',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                        'icon_sets'         => array(
                            0 => 'fas',
                            1 => 'far',
                            2 => 'fab',
                        ),
                        'custom_icon_set'   => '',
                        'default_label'     => '',
                        'default_value'     => '',
                        'save_format'       => 'element',
                        'allow_null'        => 0,
                        'show_preview'      => 1,
                        'enqueue_fa'        => 0,
                        'fa_live_preview'   => '',
                        'choices'           => array(
                        ),
                    ),
                    array(
                        'key'               => 'field_5f69feb807fcb',
                        'label'             => 'URL',
                        'name'              => 'url',
                        'type'              => 'url',
                        'instructions'      => '',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                        'default_value'     => 'https://facebook.com',
                        'placeholder'       => 'https://facebook.com',
                    ),
                ),
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'team',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
    ) );

//project start
    acf_add_local_field_group( array(
        'key'                   => 'group_5f0a920bd543d',
        'title'                 => 'Portfolio Option',
        'fields'                => array(
            array(
                'key'           => 'client_name',
                'label'         => 'Client Name',
                'name'          => 'client_name',
                'type'          => 'text',
                'instructions'  => '',
                'required'      => 0,
                'wrapper'       => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value' => 'Maveland Inc.',
                'placeholder'   => '',
                'prepend'       => '',
                'append'        => '',
                'maxlength'     => '',
            ),
            array(
                'key'           => 'project_name',
                'label'         => 'Project Name',
                'name'          => 'project_name',
                'type'          => 'text',
                'instructions'  => '',
                'required'      => 0,
                'wrapper'       => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value' => 'Systemio',
                'placeholder'   => '',
                'prepend'       => '',
                'append'        => '',
                'maxlength'     => '',
            ),
            array(
                'key'           => 'duration',
                'label'         => 'Project Duration',
                'name'          => 'duration',
                'type'          => 'text',
                'instructions'  => '',
                'required'      => 0,
                'wrapper'       => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value' => '2 weeks',
                'placeholder'   => '',
                'prepend'       => '',
                'append'        => '',
                'maxlength'     => '',
            ),
            array(
                'key'               => 'finishing_date',
                'label'             => 'Finishing Date',
                'name'              => 'finishing_date',
                'type'              => 'date_picker',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'display_format'    => 'F j, Y',
                'return_format'     => 'F j, Y',
                'first_day'         => 1,
            ),
            array(
                'key'               => 'field_5f0a93936a3ae',
                'label'             => 'Portfolio Grid',
                'name'              => 'image_width',
                'type'              => 'select',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'choices'           => array(
                    4  => '4 column',
                    3  => '3 column',
                    6  => '6 column',
                    12 => 'Fulwidth',
                ),
                'default_value'     => 3,
                'allow_null'        => 0,
                'multiple'          => 0,
                'ui'                => 0,
                'return_format'     => 'value',
                'ajax'              => 0,
                'placeholder'       => '',
            ),
            array(
                'key'               => 'field_5f0b0fc730f1b',
                'label'             => 'Image Height',
                'name'              => 'image_height',
                'type'              => 'select',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'choices'           => array(
                    'normal' => 'Normal',
                    'big'    => 'Big',
                ),
                'default_value'     => 'normal',
                'allow_null'        => 0,
                'multiple'          => 0,
                'ui'                => 0,
                'return_format'     => 'value',
                'ajax'              => 0,
                'placeholder'       => '',
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'portfolio',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'side',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
    ) );
//end project meta

//Header Footer Include/Eclude Options
    acf_add_local_field_group( array(
        'key'                   => 'group_600e8b288c563',
        'title'                 => 'Header Footer Include/Exclude Permission',
        'fields'                => array(
            array(
                'key'               => 'field_600e8b3a91509',
                'label'             => 'Include Rules',
                'name'              => 'include_rules',
                'type'              => 'repeater',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'collapsed'         => '',
                'min'               => 0,
                'max'               => 0,
                'layout'            => 'table',
                'button_label'      => 'Add Include Rule',
                'sub_fields'        => array(
                    array(
                        'key'               => 'field_600e8bd99150a',
                        'label'             => 'Include On',
                        'name'              => 'include_on',
                        'type'              => 'select',
                        'instructions'      => '',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                        'choices'           => array(
                            'all'      => 'Entire Website',
                            'specific' => 'Specific Pages',
                            'archive'  => 'Archive Pages',
                        ),
                        'default_value'     => false,
                        'allow_null'        => 0,
                        'multiple'          => 0,
                        'ui'                => 0,
                        'return_format'     => 'value',
                        'ajax'              => 0,
                        'placeholder'       => '',
                    ),
                    array(
                        'key'               => 'field_600e8cc79150b',
                        'label'             => 'Pages',
                        'name'              => 'pages',
                        'type'              => 'post_object',
                        'instructions'      => '',
                        'required'          => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field'    => 'field_600e8bd99150a',
                                    'operator' => '==',
                                    'value'    => 'specific',
                                ),
                            ),
                        ),
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                        'post_type'         => array(
                            0 => 'page',
                            1 => 'post',
                            2 => 'portfolio',
                        ),
                        'taxonomy'          => '',
                        'allow_null'        => 0,
                        'multiple'          => 1,
                        'return_format'     => 'id',
                        'ui'                => 1,
                    ),
                ),
            ),
            array(
                'key'               => 'field_600e8d139150c',
                'label'             => 'Exclude Rules',
                'name'              => 'exclude_rules',
                'type'              => 'repeater',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'collapsed'         => '',
                'min'               => 0,
                'max'               => 0,
                'layout'            => 'table',
                'button_label'      => 'Add Exclude Rule',
                'sub_fields'        => array(
                    array(
                        'key'               => 'field_600e8d139150d',
                        'label'             => 'Exclude On',
                        'name'              => 'exclude_on',
                        'type'              => 'select',
                        'instructions'      => '',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                        'choices'           => array(
                            'all'      => 'Entire Website',
                            'specific' => 'Specific Pages',
                            'archive'  => 'Archive Pages',
                        ),
                        'default_value'     => false,
                        'allow_null'        => 0,
                        'multiple'          => 0,
                        'ui'                => 0,
                        'return_format'     => 'value',
                        'ajax'              => 0,
                        'placeholder'       => '',
                    ),
                    array(
                        'key'               => 'field_600e8d139150e',
                        'label'             => 'Pages',
                        'name'              => 'pages',
                        'type'              => 'post_object',
                        'instructions'      => '',
                        'required'          => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field'    => 'field_600e8d139150d',
                                    'operator' => '==',
                                    'value'    => 'specific',
                                ),
                            ),
                        ),
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                        'post_type'         => array(
                            0 => 'page',
                            1 => 'post',
                            2 => 'portfolio',
                        ),
                        'taxonomy'          => '',
                        'allow_null'        => 0,
                        'multiple'          => 1,
                        'return_format'     => 'id',
                        'ui'                => 1,
                    ),
                ),
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'fastland_header',
                ),
            ),
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'fastland_footer',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
    ) );

//Main Menu
    acf_add_local_field_group( array(
        'key'                   => 'group_5fe431f037a11',
        'title'                 => 'Menu Item Option',
        'fields'                => array(
            array(
                'key'               => 'field_5fe43201d9712',
                'label'             => 'Hide this menu',
                'name'              => 'hide_this_menu',
                'type'              => 'true_false',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'message'           => '',
                'default_value'     => 0,
                'ui'                => 0,
                'ui_on_text'        => '',
                'ui_off_text'       => '',
            ),
            array(
                'key'               => 'field_5fe43201',
                'label'             => 'Mark as megamenu title',
                'name'              => 'is_it_title',
                'type'              => 'true_false',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'message'           => '',
                'default_value'     => 0,
                'ui'                => 0,
                'ui_on_text'        => '',
                'ui_off_text'       => '',
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'nav_menu_item',
                    'operator' => '==',
                    'value'    => 'all',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
    ) );

    acf_add_local_field_group( array(
        'key'                   => 'group_603b382c4e046',
        'title'                 => 'Megamenu Options',
        'fields'                => array(
            array(
                'key'               => 'field_603b3849b275f',
                'label'             => 'Select Megamenu',
                'name'              => 'select_megamenu',
                'type'              => 'post_object',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'post_type'         => array(
                    0 => 'fastland_megamenu',
                ),
                'taxonomy'          => '',
                'allow_null'        => 1,
                'multiple'          => 0,
                'return_format'     => 'id',
                'ui'                => 1,
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'nav_menu_item',
                    'operator' => '==',
                    'value'    => 'all',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
    ) );

    acf_add_local_field_group( array(
        'key'                   => 'group_6076f1a68a0fe',
        'title'                 => 'Service Category',
        'fields'                => array(
            array(
                'key'               => 'field_6076f1b50b7a6',
                'label'             => 'Category Icon',
                'name'              => 'category_icon',
                'type'              => 'font-awesome',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'icon_sets'         => array(
                    0 => 'fas',
                    1 => 'far',
                    2 => 'fab',
                ),
                'custom_icon_set'   => '',
                'default_label'     => '',
                'default_value'     => '',
                'save_format'       => 'element',
                'allow_null'        => 0,
                'show_preview'      => 1,
                'enqueue_fa'        => 0,
                'fa_live_preview'   => '',
                'choices'           => array(
                ),
            ),
            array(
                'key'               => 'field_6076f20b0b7a7',
                'label'             => 'Icon Color',
                'name'              => 'icon_color',
                'type'              => 'color_picker',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => '',
                'enable_opacity'    => false,
                'return_format'     => 'string',
            ),
            array(
                'key'               => 'field_6076f3ccbf7b3',
                'label'             => 'Background Color',
                'name'              => 'background_color',
                'type'              => 'color_picker',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => '',
                'enable_opacity'    => false,
                'return_format'     => 'string',
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'taxonomy',
                    'operator' => '==',
                    'value'    => 'service-category',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
        'show_in_rest'          => false,
    ) );

    acf_add_local_field_group( array(
        'key'                   => 'group_607a16764349a',
        'title'                 => 'Service Meta',
        'fields'                => array(
            array(
                'key'               => 'field_607a16764ae73',
                'label'             => 'Select Icon',
                'name'              => 'icon',
                'type'              => 'font-awesome',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'icon_sets'         => array(
                    0 => 'fas',
                    1 => 'far',
                    2 => 'fab',
                ),
                'custom_icon_set'   => '',
                'default_label'     => '',
                'default_value'     => '',
                'save_format'       => 'element',
                'allow_null'        => 0,
                'show_preview'      => 1,
                'enqueue_fa'        => 0,
                'fa_live_preview'   => '',
                'choices'           => array(
                ),
            ),
            array(
                'key'               => 'field_607a16764aedf',
                'label'             => 'Background Color',
                'name'              => 'background_color',
                'type'              => 'color_picker',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => '',
                'enable_opacity'    => false,
                'return_format'     => 'string',
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'service',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
        'show_in_rest'          => false,
    ) );

    acf_add_local_field_group( array(
        'key'                   => 'group_608288d625d32',
        'title'                 => 'Job Meta',
        'fields'                => array(
            array(
                'key'               => 'field_608288dd297e4',
                'label'             => 'Job Location',
                'name'              => 'job_location',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => 'South Haven, USA',
                'placeholder'       => 'Type Job location',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
            array(
                'key'               => 'field_60828b4e297e6',
                'label'             => 'Salary',
                'name'              => 'salary',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => '91,000 INR',
                'placeholder'       => '',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
            array(
                'key'               => 'field_60828c40289ff',
                'label'             => 'Button Text',
                'name'              => 'button_text',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => 'Apply',
                'placeholder'       => '',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
            array(
                'key'               => 'field_60828c5628a00',
                'label'             => 'Button Url',
                'name'              => 'button_url',
                'type'              => 'url',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => 'https://finestwp.co/demos/wp/fastland',
                'placeholder'       => '',
            ),
            array(
                'key'               => 'field_6082b155439a4',
                'label'             => 'Job Type',
                'name'              => 'fastlands_job_type',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => 'Full-Time',
                'placeholder'       => '',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
            array(
                'key'               => 'field_6084f0120ab54',
                'label'             => 'Show Date',
                'name'              => 'show_date',
                'type'              => 'true_false',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'message'           => '',
                'default_value'     => 1,
                'ui'                => 1,
                'ui_on_text'        => '',
                'ui_off_text'       => '',
            ),
            array(
                'key'               => 'field_6406fa81fb0fe',
                'label'             => 'Job Details Button',
                'name'              => 'job_details_button',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 1,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => 'Apply for this position',
                'placeholder'       => 'Apply for this position',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
            array(
                'key'               => 'field_6406faa8fb0ff',
                'label'             => '',
                'name'              => '',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => '',
                'placeholder'       => '',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'job',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
        'show_in_rest'          => 0,
    ) );
    acf_add_local_field_group( array(
        'key'                   => 'group_6075e4b703200',
        'title'                 => 'Testimonial',
        'fields'                => array(
            array(
                'key'               => 'field_6075e4c157efc',
                'label'             => 'Designation',
                'name'              => 'designation',
                'type'              => 'text',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'default_value'     => 'Web Developer',
                'placeholder'       => '',
                'prepend'           => '',
                'append'            => '',
                'maxlength'         => '',
            ),
            array(
                'key'               => 'field_6075e4dc57efd',
                'label'             => 'Review Rating',
                'name'              => 'review_rating',
                'type'              => 'select',
                'instructions'      => '',
                'required'          => 0,
                'conditional_logic' => 0,
                'wrapper'           => array(
                    'width' => '',
                    'class' => '',
                    'id'    => '',
                ),
                'choices'           => array(
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                ),
                'default_value'     => 5,
                'allow_null'        => 0,
                'multiple'          => 0,
                'ui'                => 0,
                'return_format'     => 'value',
                'ajax'              => 0,
                'placeholder'       => '',
            ),
        ),
        'location'              => array(
            array(
                array(
                    'param'    => 'post_type',
                    'operator' => '==',
                    'value'    => 'fastland_testimonial',
                ),
            ),
        ),
        'menu_order'            => 0,
        'position'              => 'normal',
        'style'                 => 'default',
        'label_placement'       => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen'        => '',
        'active'                => true,
        'description'           => '',
        'show_in_rest'          => false,
    ) );

endif;
