<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package fastland
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function fastland_body_classes( $classes ) {
    // Adds a class of hfeed to non-singular pages.
    if ( !is_singular() ) {
        $classes[] = 'hfeed';
    }

    // Adds a class of no-sidebar when there is no sidebar present.
    if ( !is_active_sidebar( 'sidebar-1' ) ) {
        $classes[] = 'no-sidebar';
    }

    return $classes;
}
add_filter( 'body_class', 'fastland_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function fastland_pingback_header() {
    if ( is_singular() && pings_open() ) {
        printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
    }
}
add_action( 'wp_head', 'fastland_pingback_header' );

function fastland_dd( $var ) {
    echo '<pre>';
    print_r( $var );
    echo '</pre>';
}

/**
 * Detect Homepage
 *
 * @return boolean value
 */
function fastland_detect_homepage() {
    // If front page is set to display a static page, get the URL of the posts page.
    $homepage_id = get_option( 'page_on_front' );

    // current page id
    $current_page_id = ( is_page( get_the_ID() ) ) ? get_the_ID() : '';

    if ( $homepage_id == $current_page_id ) {
        return true;
    } else {
        return false;
    }
}

/**
 *   Get the site logo for Bufet
 *
 */
function fastland_get_site_logo() {
    $logo     = '';
    $fastland = get_option( 'fastland' );
    $logo_url = '';

    $custom_logo = get_post_meta( get_the_ID(), 'use_custom_logo', true );
    $page_logo   = get_post_meta( get_the_ID(), 'select_logo', true );

    if ( !empty( $custom_logo ) ) {
        $img_url  = wp_get_attachment_image_src( $page_logo, 'full' );
        $logo_url = esc_url( $img_url[0] );
        $logo     = '<img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '" class="navbar-brand__regular">';
    } else if ( !empty( $fastland['logo']['url'] ) ) {
        $logo_url = esc_url( $fastland['logo']['url'] );
        $logo     = '<img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '" class="navbar-brand__regular">';
    } else {
        if ( has_custom_logo() ) {
            $core_logo_id = get_theme_mod( 'custom_logo' );
            $logo_url     = wp_get_attachment_image_src( $core_logo_id, 'full' );
            $logo         = '<img src="' . esc_url( $logo_url[0] ) . '" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '" class="navbar-brand__regular">';
        } else {
            $logo = '<h1 class="navbar-brand__regular">' . get_bloginfo( 'name' ) . '</h1>';
        }
    }

    return $logo;
}

/**
 * Get the site logo for Bufet
 */
function fastland_get_site_sticky_logo() {

    $fastland = get_option( 'fastland' );

    $logo     = '';
    $logo_url = '';

    $custom_logo      = get_post_meta( get_the_ID(), 'use_custom_logo', true );
    $page_sticky_logo = get_post_meta( get_the_ID(), 'select_sticky_logo', true );

    if ( !empty( $custom_logo ) && $page_sticky_logo ) {
        $img_url  = wp_get_attachment_image_src( $page_sticky_logo, 'full' );
        $logo_url = esc_url( $img_url[0] );
        $logo     = '<img src="' . esc_url( $logo_url ) . ' ?>" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '" class="navbar-brand__sticky">';
    } else if ( !empty( $fastland['sticky_logo']['url'] ) ) {
        $logo_url = esc_url( $fastland['sticky_logo']['url'] );
        $logo     = '<img src="' . esc_url( $logo_url ) . '" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '" class="navbar-brand__sticky">';
    }
    return $logo;
}

add_action( 'wp_ajax_cloadmore', 'fastland_comments_loadmore_handler' ); // wp_ajax_{action}
add_action( 'wp_ajax_nopriv_cloadmore', 'fastland_comments_loadmore_handler' ); // wp_ajax_nopriv_{action}

function fastland_comments_loadmore_handler() {

    // maybe it isn't the best way to declare global $post variable, but it is simple and works perfectly!
    global $post;
    $post = get_post( $_POST['post_id'] );
    setup_postdata( $post );

    wp_list_comments(
        array(
            'page'       => $_POST['cpage'], // current comment page
            'per_page' => get_option( 'comments_per_page' ),
            'style'      => 'ol',
            'short_ping' => true,
        )
    );
    die; // don't forget this thing if you don't want "0" to be displayed
}

/**
 * fastland Is edit mode in elementor
 *
 */
function fastland_is_edit_mode() {

    return isset( $_GET['elementor-preview'] );
}
function fastland_header_settings() {

    if ( defined( 'ELEMENTOR_PRO_VERSION' ) && fastland_is_edit_mode() ) {
        return;
    } else {
        $fastland = get_option( 'fastland' );

        $check_header_post = get_posts( ['post_type' => 'fastland_header'] );

        if ( 0 != count( $check_header_post ) ) {
            printf( '<header class="site-header fastland-elementor-header">' );
            fastland_header_footer_template_query( 'fastland_header' );
            printf( '</header>' );
        } else {
            get_template_part( 'template-parts/headers/header-style-1' );
        }
    }

}

/**
 * fastland Footer Settings
 *
 */
function fastland_footer_settings() {
    if ( defined( 'ELEMENTOR_PRO_VERSION' ) && fastland_is_edit_mode() ) {
        return;
    } else {
        $check_footer_post = get_posts( ['post_type' => 'fastland_footer'] );

        if ( 0 != count( $check_footer_post ) ) {

            fastland_header_footer_template_query( 'fastland_footer' );
        } else {
            fastland_raw_footer();
        }
    }
}

/**
 * fastland Raw Footer
 *
 */
function fastland_raw_footer() {
    $fastland = get_option( 'fastland' );

    if ( isset( $fastland['footer_copyright'] ) ) {
        echo '<div class="fastland-copyright text-center">' . $fastland['footer_copyright'] . '</div>';
    } else {
        echo '<div class="fastland-copyright text-center">' . esc_html__( 'Copyright 2021, All Rights Reserved', 'fastland' ) . '</div>';
    }
}

/**
 * fastland Footer Query
 *
 */
function fastland_header_footer_template_query( $post_type, $post_id = '' ) {

    global $post;
    $current_page_id = isset( $post->ID ) ? $post->ID : false;

    // Query for blog posts
    $args = array(
        'post_type'      => $post_type,
        'posts_per_page' => -1,
    );
    if ( empty( $post_id ) ) {
        $argc['p'] = $post_id;
    }

    $footer_query = new WP_Query( $args );

    if ( $footer_query->have_posts() ):
        while ( $footer_query->have_posts() ):
            $footer_query->the_post();
            $output   = '';
            $excluded = false;

            if (  get_field( 'exclude_rules', get_the_ID() ) ) {

                while ( the_repeater_field( 'exclude_rules', get_the_ID() ) ) {
                    $specific_pages = get_sub_field( 'pages' ) ? get_sub_field( 'pages' ) : [];
                    $entire_website = get_sub_field( 'exclude_on' );
                    $archive        = 'archive' == $entire_website ? is_archive() || is_home() || is_search() : false;

                    if ( 'all' == $entire_website || in_array( $current_page_id, $specific_pages ) || $archive ) {
                        $excluded = true;
                    }
                }
            }

            if ( !$excluded && get_field( 'include_rules', get_the_ID() ) ) {

                while ( the_repeater_field( 'include_rules', get_the_ID() ) ) {
                    $specific_pages = get_sub_field( 'pages' ) ? get_sub_field( 'pages' ) : [];
                    $entire_website = get_sub_field( 'include_on' );
                    $archive        = 'archive' == $entire_website ? is_archive() || is_home() || is_search() : false;

                    if ( 'all' == $entire_website || in_array( $current_page_id, $specific_pages ) || $archive ) {

                        ob_start();
                        the_content();
                        $content = ob_get_clean();

                        $output = $content;
                    }
                }
            }

            if ( $output ) {
                printf( '%s', $output );
            }

        endwhile;
    endif;
}

/**
 * fastland get archive post type
 *
 */
function fastland_get_archive_post_type() {
    $postname = isset( get_queried_object()->name ) ? get_queried_object()->name : '';
    return is_archive() ? $postname : '';
}

function fastland_update_elementor_scheme( $colors = array() ) {
    global $fastland;
    if ( class_exists( 'ReduxFrameworkPlugin' ) ):
        $accent_color  = $fastland['custom_accent_color'];
        $heading_color = $fastland['heading_color'];
        $text_color    = $fastland['text_color'];
        $colors        = [
            "1" => "$heading_color",
            "2" => "$heading_color",
            "3" => "$text_color",
            "4" => "$accent_color",
        ];
        return $colors;
    endif;
    return false;
}
add_action( 'after_switch_theme', 'fastland_update_elementor_scheme' );

if ( !function_exists( 'is_shop' ) && !class_exists( 'woocommerce' ) ) {
    function is_shop() {
        return false;
    }
}

function fastland_preloader() {
    $fastland = get_option( 'fastland' );

    $preloader = '
    <div class="fastland-preloader-wrap">
        <div class="fastland-preloader">
            <img src="' . get_template_directory_uri() . '/assets/img/preloader.gif" alt="' . get_bloginfo( 'name' ) . '" />
        </div>
    </div>
    ';

    if ( isset( $fastland['enable_preloader'] ) ) {
        if ( true == $fastland['enable_preloader'] ) {
            printf( $preloader );
        }
    } else {
        printf( $preloader );
    }
}

/**
 * Checking post type enablee or disabled
 */
if ( !function_exists( 'fastland_check_cpt' ) ) {

    function fastland_check_cpt( $opt_id ) {
        $fastland = get_option( 'fastland' );
        if ( isset( $fastland[$opt_id] ) ) {
            if ( true == $fastland[$opt_id] ) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }
    }
}
