<?php

/**
 * Enqueue scripts and styles.
 */
function fastland_scripts() {
    wp_enqueue_style( 'fastland-font-awesome', get_theme_file_uri( '/assets/css/all.min.css' ), array(), '4.7.0' );
	wp_enqueue_style('select2', get_theme_file_uri( '/assets/css/select2.min.css'), array(), null);
    wp_enqueue_style( 'bootstrap', get_theme_file_uri( '/assets/css/bootstrap.min.css' ), array(), '4.0' );
    wp_enqueue_style( 'nice-select', get_theme_file_uri( '/assets/css/nice-select.min.css' ), array(), 'null' );
    wp_enqueue_style( 'fastland-core', get_theme_file_uri( '/assets/css/core.css' ), array(), FASTLAND_THEME_VERSION );
    wp_enqueue_style( 'fastland-gutenberg', get_theme_file_uri( '/assets/css/gutenberg.css' ), array(), FASTLAND_THEME_VERSION );
    wp_enqueue_style( 'fastland-custom', get_theme_file_uri( '/assets/css/theme-style.css' ), array(), FASTLAND_THEME_VERSION );
    wp_enqueue_style( 'fastland-style', get_stylesheet_uri(), array(), FASTLAND_THEME_VERSION );
    wp_enqueue_style( 'fastland-responsive', get_theme_file_uri( '/assets/css/theme-responsive.css' ), array(), FASTLAND_THEME_VERSION );

    wp_enqueue_script( 'jquery-masonry' );

	wp_enqueue_script('select2', get_theme_file_uri( '/assets/js/select2.min.js'), array('jquery'), null, true);
    wp_enqueue_script( 'nice-select', get_theme_file_uri( '/assets/js/jquery.nice-select.min.js' ), array( 'jquery' ), null, true );
    wp_enqueue_script( 'fastland-main', get_theme_file_uri( '/assets/js/fastland-main.js' ), array( 'jquery' ), FASTLAND_THEME_VERSION, true );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'fastland_scripts' );

/**
 * Registers an editor stylesheet for the theme.
 */
function fastland_theme_add_editor_styles() {
    add_editor_style( get_theme_file_uri( '/assets/css/editor-style.css' ) );
}
add_action( 'admin_init', 'fastland_theme_add_editor_styles' );

function paul_guten_block_editor_assets() {
    wp_enqueue_style(
        'paul-editor-style',
        get_theme_file_uri( '/assets/css/editor-style.css' ),
        array(),
        '1.0'
    );

    wp_enqueue_style( 'fastland-gutenberg', '//fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap', array(), FASTLAND_THEME_VERSION );
    wp_enqueue_style( 'fastland-gutenberg', get_theme_file_uri( '/assets/css/gutenberg.css' ), array(), FASTLAND_THEME_VERSION );
}
add_action( 'enqueue_block_editor_assets', 'paul_guten_block_editor_assets' );
