<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package fastland
 */

get_header();

global $fastlandObj;
if (have_posts()) {
	$fastlandObj->fastland_breadcrumb_bridge();
}

$fastland = get_option('fastland');
$grid = (isset($fastland['blog_grid'])) ? $fastland['blog_grid'] : 'one-column';

?>

<div class="content-block sp-80">
	<div class="container">
		<div class="row blog-content-row justify-content-center">

			<?php
			// If Redux Framework Active
			if (have_posts()) :

				if (class_exists('ReduxFrameworkPlugin')) :
					// var_dump($fastland['blog_layout']);
					$fastlandObj->postMarkupGenerator($fastland['blog_layout'], $grid);

				else : // If Redux Framework Is Not Active

					$fastlandObj->postMarkupGenerator(null, $grid);

				endif;
			else :

				get_template_part('template-parts/contents/content-none');
			endif;
			?>
		</div>
	</div>
</div>


<?php
get_footer();
