
<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package fastland
 */ 
      global $post;
      $idd = get_the_ID();
      $job_location =   get_post_meta( $idd, 'job_location', true);
      $job_type     =   get_post_meta( $idd, 'fastlands_job_type',true ); 
      $salary       =   get_post_meta( $idd, 'salary', true);
      $button_text  =   get_post_meta( $idd, 'button_text', true);
      $button_url   =   get_post_meta( $idd, 'button_url', true);
      $show_date   =    get_post_meta( $idd, 'show_date', true);
      $jdb_text   =    get_post_meta( $idd, 'job_details_button', "Apply for this position");
      


?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
            <div class="card card-jobs flex-row justify-content-between align-items-center flex-wrap text-center text-md-start">
                <div class="card-jobs__content">
                <h2 class="card-jobs__content__heading"><?php the_title(); ?></h2>
                <ul class="card-jobs__content__details list-unstyled d-flex align-items-center flex-wrap justify-content-center justify-md-content-start">
                    <?php if(!empty( $job_location) && function_exists('the_field') ): ?>
                    <li>
                        <i class="fa fa-map-marker-alt text-electric-violet-2"></i> 
                        <?php echo esc_html($job_location);  ?>
                    </li>
                    <?php endif; ?>

                    <li>

                    <?php if(!empty( $show_date ) && function_exists('the_field') ): ?>
                      <li>
                        <i class="fa fa-clock text-electric-violet-2"></i>
                        <?php _e('Posted', 'fastland')  ?> <?php echo esc_html( human_time_diff( get_the_time('U'), current_time('timestamp') ) ) . ' ago'; ?>
                      </li>
                      <?php endif; ?>

                    <?php if(!empty( $job_type ) && function_exists('the_field') ): ?>
                    <li>
                        <i class="fa fa-briefcase text-electric-violet-2"></i>
                        <?php echo esc_html($job_type)  ?>
                    </li>
                    <?php endif; ?>


                    </ul>
                </div>
                <div class="card-job__btn mx-auto mx-md-0 mt-2 mt-md-0">
                    <a  href="<?php echo esc_url($button_url) ?>"  class="falsland-job-btn"><?php echo esc_html($button_text) ?></a>
                    <a  href="<?php echo get_permalink($post->ID); ?>" id="copy-btn" class="falsland-job-btn border"><?php _e('Share', 'fastland') ?></a>
                </div>
            </div>
            </div>
        </div>

        <!-- content -->
        <div class="row justify-content-center">
          <div class="col-xl-8 col-lg-10">
            <div class="career-deatils__content">
              <div class="career-details-box">
                <?php the_content(); ?>

                <button class="falsland-job-btn" href="<?php echo esc_url($button_url) ?>"><?php echo esc_html__( $jdb_text, 'html' ); ?></button>    
               </div>
            </div>
          </div>
        </div>
        <!-- content ned -->
    </div>
</article><!-- #post-<?php the_ID(); ?> -->
