<?php

/**
 * Tab
 *
 *
 * @since 1.0.0
 */

use Elementor\Controls_Manager;
use Elementor\DIVIDER;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\utils;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
  exit;
}

class FastlandFeatured extends \Elementor\Widget_Base
{
  /**
   * Retrieve the widget name.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget name.
   */
  public function get_name()
  {
    return 'fastland-featured';
  }
  /**
   * Retrieve the widget title.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget title.
   */
  public function get_title()
  {
    return __('Fastland Featured', 'fastland');
  }
  /**
   * Retrieve the widget icon.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return string Widget icon.
   */
  public function get_icon()
  {
    return 'eicon-tabs';
  }

  /**
   * Retrieve the list of categories the widget belongs to.
   *
   * Used to determine where to display the widget in the editor.
   *
   * Note that currently Elementor supports only one category.
   * When multiple categories passed, Elementor uses the first one.
   *
   * @since 1.0.0
   *
   * @access public
   *
   * @return array Widget categories.
   */
  public function get_categories()
  {
    return ['fastland-addons'];
  }
  public function get_keywords()
  {
    return ['brand', 'featured', 'fastland', 'promo', 'logo'];
  }
  /**
   * Register the widget controls.
   *
   * Adds different input fields to allow the user to change and customize the widget settings.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function register_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Tabs', 'fastland'),
      ]
    );

    // one
    $this->add_control(
      'h_one',
      [
        'label' => __('Item One', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_one',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // two
    $this->add_control(
      'h_two',
      [
        'label' => __('Item Two', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_two',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // three
    $this->add_control(
      'h_three',
      [
        'label' => __('Item Three', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_three',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // four
    $this->add_control(
      'h_four',
      [
        'label' => __('Item Four', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_four',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // five
    $this->add_control(
      'h_five',
      [
        'label' => __('Item Five', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_five',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // six
    $this->add_control(
      'h_six',
      [
        'label' => __('Item Six', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_six',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // seven
    $this->add_control(
      'h_seven',
      [
        'label' => __('Item Seven', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_seven',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // eight
    $this->add_control(
      'h_eight',
      [
        'label' => __('Item Eight', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_eight',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );

    // nine
    $this->add_control(
      'h_nine',
      [
        'label' => __('Item Nine', 'fastland'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );

    $this->add_control(
      'fi_nine',
      [
        'label'     => __('Image', 'fastland'),
        'type'      => Controls_Manager::MEDIA,
      ]
    );
    $this->end_controls_section();



    //Icon
    // $this->start_controls_section('featured_style',
    //     [
    //         'label' => __('Style', 'fastland'),
    //         'tab'   => Controls_Manager::TAB_STYLE,
    //     ]
    // );
    // $this->end_controls_section();

  }
  //End Repetare Content
  /**
   * Render the widget output on the frontend.
   *
   * Written in PHP and used to generate the final HTML.
   *
   * @since 1.0.0
   *
   * @access protected
   */
  protected function render()
  {
    $settings = $this->get_settings();

    // iamges
    $fi_one   = wp_get_attachment_image_url($settings['fi_one']['id'], 'full');
    $fi_two   = wp_get_attachment_image_url($settings['fi_two']['id'], 'full');
    $fi_three = wp_get_attachment_image_url($settings['fi_three']['id'], 'full');
    $fi_four  = wp_get_attachment_image_url($settings['fi_four']['id'], 'full');
    $fi_five  = wp_get_attachment_image_url($settings['fi_five']['id'], 'full');
    $fi_six   = wp_get_attachment_image_url($settings['fi_six']['id'], 'full');
    $fi_seven = wp_get_attachment_image_url($settings['fi_seven']['id'], 'full');
    $fi_eight = wp_get_attachment_image_url($settings['fi_eight']['id'], 'full');
    $fi_nine  = wp_get_attachment_image_url($settings['fi_nine']['id'], 'full');

    // line
    $s_one   = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-1.png';
    $s_two   = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-2.png';
    $s_three = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-3.png';
    $s_four  = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-4.png';
    $s_five  = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-5.png';
    $s_six   = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-6.png';
    $s_seven = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-7.png';
    $s_eight = plugin_dir_url(dirname(__FILE__)) . 'assets/img/brand-line-8.png';

?>
    <div class="row justify-content-center">
      <div class="col-xl-5 col-lg-6 col-md-9">
        <div class="brand-image-group brand-image-group--l2">

          <?php if ($fi_one) : ?>
            <div class="brand-image-group--l2__image--main circle-126">
              <div class="img-0">
                <img class="w-100" src="<?php echo esc_url($fi_one) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <!-- Image -->
          <?php if ($fi_two) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-1 circle-91">
              <div class="brand-logo-1">
                <img class="w-100" src="<?php echo esc_url($fi_two) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <?php if ($fi_three) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-2 circle-103">
              <div class="brand-logo-2">
                <img class="w-100" src="<?php echo esc_url($fi_three) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <?php if ($fi_four) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-3 circle-98">
              <div class="brand-logo-3">
                <img class="w-100" src="<?php echo esc_url($fi_four) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <?php if ($fi_five) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-4 circle-99">
              <div class="brand-logo-4">
                <img class="w-100" src="<?php echo esc_url($fi_five) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <?php if ($fi_six) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-5 circle-95">
              <div class="brand-logo-5">
                <img class="w-100" src="<?php echo esc_url($fi_six) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <?php if ($fi_seven) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-6 circle-113">
              <div class="brand-logo-6">
                <img class="w-100" src="<?php echo esc_url($fi_seven) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <?php if ($fi_eight) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-7 circle-88">
              <div class="brand-logo-7">
                <img class="w-100" src="<?php echo esc_url($fi_eight) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>

          <?php if ($fi_nine) : ?>
            <div class="brand-image-group--l2__single brand-image-group--l2__img-8 circle-108">
              <div class="brand-logo-8">
                <img class="w-100" src="<?php echo esc_url($fi_nine) ?>" alt="">
              </div>
            </div>
          <?php endif; ?>


          <!-- Image Line -->
          <?php if ($fi_two) : ?>
            <div class="brand-image-group--l2__line-1">
              <img class="w-100" src="<?php echo esc_url($s_one) ?>" alt="">
            </div>
          <?php endif; ?>

          <?php if ($fi_three) : ?>
            <div class="brand-image-group--l2__line-2">
              <img class="w-100" src="<?php echo esc_url($s_two) ?>" alt="">
            </div>
          <?php endif; ?>

          <?php if ($fi_four) : ?>
            <div class="brand-image-group--l2__line-3">
              <img class="w-100" src="<?php echo esc_url($s_three) ?>" alt="">
            </div>
          <?php endif; ?>

          <?php if ($fi_five) : ?>
            <div class="brand-image-group--l2__line-4">
              <img class="w-100" src="<?php echo esc_url($s_four) ?>" alt="">
            </div>
          <?php endif; ?>

          <?php if ($fi_six) : ?>
            <div class="brand-image-group--l2__line-5">
              <img class="w-100" src="<?php echo esc_url($s_five) ?>" alt="">
            </div>
          <?php endif; ?>

          <?php if ($fi_seven) : ?>
            <div class="brand-image-group--l2__line-6">
              <img class="w-100" src="<?php echo esc_url($s_six) ?>" alt="">
            </div>
          <?php endif; ?>

          <?php if ($fi_eight) : ?>
            <div class="brand-image-group--l2__line-7">
              <img class="w-100" src="<?php echo esc_url($s_seven) ?>" alt="">
            </div>
          <?php endif; ?>

          <?php if ($fi_nine) : ?>
            <div class="brand-image-group--l2__line-8">
              <img class="w-100" src="<?php echo esc_url($s_eight) ?>" alt="">
            </div>
          <?php endif; ?>


        </div>
      </div>
    </div>
<?php
  }
}
$widgets_manager->register(new \FastlandFeatured());
