<?php
if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly
/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class fastland_job_loop extends \Elementor\Widget_Base
{
    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'fastland-job';
    }

    public function get_script_depends()
    {
        return ['isotope', 'fastland-addon'];
    }
    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('job', 'fastland-ts');
    }
    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }
    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['fastland-addons'];
    }
    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => __('Genarel', 'fastland-ts'),
            ]
        );
        $this->add_control(
            'layout_type',
            [
                'label' => __('Layout type', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'masonry' => 'Masonry',
                    'normal' => 'Normal',
                ),
                'default' => 'normal',
            ]
        );

        $this->add_control(
            'all_text',
            [
                'label' => __('Filter first item text', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('All', 'fastland-ts'),
                'condition' => [
                    'enable_filtering' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'heading_text',
            [
                'label' => __('Heading', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Department', 'fastland-ts'),
                'condition' => [
                    'enable_filtering' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'enable_filtering',
            [
                'label' => __('Enable Filtering??', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_category',
            [
                'label' => __('Show category?', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'post_grid',
            [
                'label' => __('Post Column', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'options' => array(
                    'col-md-12' => '1 Column',
                    'col-md-6' =>  '2 Column',
                    'col-md-4' =>  '3 Column',
                    'col-md-3' =>  '4 Column',
                ),
                'default' => 'col-md-6',
            ]
        );

        $this->add_responsive_control(
            'column_verti_gap',
            [
                'label' => __('Column Vertical Gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .jobs-area__tab .card--single' => 'margin-right:{{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'column_hori_gap',
            [
                'label' => __('Column Horizontal Gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'desktop_default' => [
                    'size' => 30,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-job-item-wrap' => 'padding-bottom: {{SIZE}}{{UNIT}} ;',
                ]
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_query',
            [
                'label' => __('Query', 'fastland-ts'),
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts per page', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );
        $this->add_control(
            'source',
            [
                'label'         => __('Source', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => [
                    'job' => 'job',
                    'manual_selection' => 'Manual Selection',
                    'related' => 'Related',
                    'meta' => 'Meta',
                ],
                'default' =>    'job',
            ]
        );
        $this->add_control(
            'job_type',
            [
                'label'         => __('job type', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => fastland_get_meta_field_keys('job', 'job_type'),
                'default'     =>    fastland_get_meta_field_keys('job', 'job_type', 'value'),
                'condition'   => [
                    'source'  => 'meta'
                ],
            ]
        );
        $this->add_control(
            'manual_selection',
            [
                'label'         => __('Manual Selection', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get specific template posts', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_slug_and_id('job'),
                'default' =>    [],
                'condition' => [
                    'source' => 'manual_selection'
                ],
            ]
        );
        $this->start_controls_tabs(
            'include_exclude_tabs'
        );
        $this->start_controls_tab(
            'include_tabs',
            [
                'label' => __('Include', 'fastland-ts'),
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'include_by',
            [
                'label'         => __('Include by', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'label_block'   => true,
                'multiple'      => true,
                'options'       => [
                    'tags'  => 'Tags',
                    'category'  => 'Category',
                    'author' => 'Author',
                ],
                'default' =>    [],
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'include_categories',
            [
                'label'         => __('Include categories', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific category(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('job-category'),
                'default' =>    [],
                'condition' => [
                    'include_by' => 'category',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'include_tags',
            [
                'label'         => __('Include Tags', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('job-tag'),
                'default' =>    [],
                'condition' => [
                    'include_by' => 'tags',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'include_authors',
            [
                'label'         => __('Include authors', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_author_slug_and_id('job'),
                'default' =>    [],
                'condition' => [
                    'include_by' => 'author',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'exclude_tabs',
            [
                'label' => __('Exclude', 'fastland-ts'),
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'exclude_by',
            [
                'label'         => __('Exclude by', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'label_block'   => true,
                'multiple'      => true,
                'options'       => [
                    'tags'  => 'tags',
                    'category'  => 'Category',
                    'author' => 'Author',
                    'current_post' => 'Current Post',
                ],
                'default' =>    [],
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'exclude_categories',
            [
                'label'         => __('Exclude categories', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific category(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('job-category'),
                'default' =>    [],
                'condition' => [
                    'exclude_by' => 'category',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'exclude_tags',
            [
                'label'         => __('Exclude Tags', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('job-tag'),
                'default' =>    [],
                'condition' => [
                    'exclude_by' => 'tags',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'exclude_authors',
            [
                'label'         => __('Exclude authors', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_author_slug_and_id('job'),
                'default' =>    [],
                'condition' => [
                    'exclude_by' => 'author',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'orderby',
            [
                'label'         => __('Order By', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => [
                    'date'   => 'Date',
                    'title'    => 'title',
                    'menu_order'    => 'Menu Order',
                    'rand'    => 'Random',
                ],
                'default' =>    'date',
            ]
        );
        $this->add_control(
            'order',
            [
                'label'         => __('Order', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => [
                    'ASC'   => 'ASC',
                    'DESC'    => 'DESC',
                ],
                'default' =>    'DESC',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'section_filter_style',
            [
                'label' => __('Filter', 'fastland-ts'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_filtering' => 'yes'
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Filter Typography', 'fastland-ts'),
                'name' => 'filter_typo',
                'selector' => '{{WRAPPER}} .jf-isotope-nav li',
            ]
        );
        $this->add_control(
            'filter_color',
            [
                'label' => __('Filter Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jf-isotope-nav li' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'filter_hover_color',
            [
                'label' => __('Filter Hover Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jf-isotope-nav li:hover,{{WRAPPER}} .jf-isotope-nav li.active' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'isotop_filter_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .jobs-filter__menu ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .jobs-filter__menu ul li' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        Heading
        */
        $this->start_controls_section(
            'heading_top',
            [
                'label' => __('Filter Heading', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Typography', 'fastland-ts'),
                'name' => 'heading_typo',
                'selector' => '{{WRAPPER}} .jobs-filter__title',
            ]
        );
        $this->add_control(
            'heading_color',
            [
                'label' => __('Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jobs-filter__title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'heading_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .jobs-filter__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .jobs-filter__title' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        Title
        */
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => __('Title', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Title Typography', 'fastland-ts'),
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .jobs-area__tab .card__heading',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card__heading' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => __('Hover', 'fastland-hp'),
            ]
        );
        $this->add_control(
            'title_color_hover',
            [
                'label' => __('Title Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card__heading:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'titel_margin',
            [
                'label'      => __('Margin', 'fastland-hp'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .jobs-area__tab .card__heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .jobs-area__tab .card__heading' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /* 
        Button
        */
        $this->start_controls_section(
            'meta',
            [
                'label' => __('Job Meta', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card__list li i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_icon_size',
            [
                'label' => __('Icon Size', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .jobs-area__tab .card__list li i' => 'font-size:{{SIZE}}{{UNIT}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_margin',
            [
                'label' => __('Icon Margin', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card__list li i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .jobs-area__tab .card__list li i' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'meta_text',
            [
                'label' => __('Text', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Typography', 'fastland-ts'),
                'name' => 'meta_typo',
                'selector' => '{{WRAPPER}} .jobs-area__tab .card__list li',
            ]
        );

        $this->add_control(
            'meta_text_color',
            [
                'label' => __('Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card__list li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_list_margin_bottom',
            [
                'label' => __('Bottom Gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .jobs-area__tab .card__list li' => 'margin-bottom:{{SIZE}}{{UNIT}}',
                ]
            ]
        );
        $this->end_controls_section();

        /* 
        Button
        */
        $this->start_controls_section(
            'button',
            [
                'label' => __('Button', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Typography', 'fastland-ts'),
                'name' => 'button_typo',
                'selector' => '{{WRAPPER}} .falsland-job-btn',
            ]
        );

        $this->start_controls_tabs(
            'button_tabs'
        );

        $this->start_controls_tab(
            'button_normal_tab',
            [
                'label' => __('Normal', 'fastland-ts'),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __('Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .falsland-job-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __('Background Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .falsland-job-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'      => 'button_border',
                'selector'  => '{{WRAPPER}} .falsland-job-btn',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .falsland-job-btn',
                'separator' => 'after',
            ]
        );
        $this->end_controls_tab();

        // hover
        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => __('Hover', 'fastland-ts'),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label' => __('Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .falsland-job-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_bg_color_hover',
            [
                'label' => __('Background Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .falsland-job-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'      => 'button_border_hover',
                'selector'  => '{{WRAPPER}} .falsland-job-btn:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow_hover',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .falsland-job-btn:hover',
                'separator' => 'after',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_responsive_control(
            'button_radius',
            [
                'label' => __('Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .falsland-job-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .falsland-job-btn' => 'border-radius: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => __('Margin', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .falsland-job-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .falsland-job-btn' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .falsland-job-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .falsland-job-btn' => 'padding: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /* Content Box */
        $this->start_controls_section(
            'section_content_style',
            [
                'label' => __('Content Box', 'fastland-ts'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'box_tabs'
        );

        $this->start_controls_tab(
            'box_normal_tab',
            [
                'label' => __('Normal', 'fastland-ts'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'      => 'box_border',
                'selector'  => '{{WRAPPER}} .jobs-area__tab .card--single',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_box_shadow',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .jobs-area__tab .card--single',
            ]
        );
        $this->end_controls_tab();

        // hover
        $this->start_controls_tab(
            'box_tab_hover',
            [
                'label' => __('Hover', 'fastland-ts'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'      => 'box_border_hover',
                'selector'  => '{{WRAPPER}} .jobs-area__tab .card--single:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_box_shadow_hover',
                'exclude'  => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .jobs-area__tab .card--single:hover',
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'content_align',
            [
                'label' => __('Align', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'fastland-hp'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'fastland-hp'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'fastland-hp'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'separator' => 'before',
                'devices' => ['desktop', 'tablet', 'mobile'],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card--single' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_bg_color',
            [
                'label' => __('Content Background Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card--single' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __('Content Padding', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card--single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    'body.rtl {{WRAPPER}} .jobs-area__tab .card--single' => 'margin: {{TOP}}{{UNIT}} {{LEFT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_radius',
            [
                'label' => __('Content Box Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .jobs-area__tab .card--single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_radius',
            [
                'label' => __('Box Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    ' {{WRAPPER}} .fastland-job-item ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings();
        $heading_text = $settings['heading_text'];
        $paged = get_query_var('paged') ? get_query_var('paged') : 1;
        $job_data = [];
        $job_data['settings'] = $this->get_settings();
        $job_data = json_encode($job_data);

        // Including the query 
        include('queries/job-query.php');

        if ($settings['enable_filtering']) {
            $this->add_render_attribute('enabel_filter', 'class', array('col-xl-8 offset-xl-1 col-lg-9 col-md-12'));
        } else {
            $this->add_render_attribute('enabel_filter', 'class', array('col-lg-12'));
        }

        if ($the_query->have_posts()) :
?>
            <div class="row justify-content-center">

                <?php if ($settings['enable_filtering']) : ?>
                    <div class="col-lg-3 col-md-4 col-xs-8">
                        <div class="jobs-filter">
                            <?php if ($heading_text) : ?>
                                <h3 class="jobs-filter__title"><?php echo esc_html($heading_text); ?></h3>
                            <?php endif; ?>

                            <div class="jobs-filter__menu">
                                <ul class="jf-isotope-nav">
                                    <li data-filter="<?php echo esc_attr('*') ?>" class="active"><?php echo esc_html($settings['all_text'])  ?></li>
                                    <?php
                                    if (0 != count($settings['include_categories'])) :
                                        foreach ($settings['include_categories'] as $cat) :
                                            $jf_term = get_term_by('slug', $cat, 'job-category');
                                    ?>
                                            <li data-filter=".<?php echo esc_attr($jf_term->slug) ?>"><?php echo esc_html($jf_term->name) ?></li>
                                            <?php
                                        endforeach;
                                    else :
                                        $jf_terms = get_terms('job-category');
                                        if (!empty($jf_terms)) :
                                            foreach ($jf_terms as $jf_term) : ?>
                                                <li data-filter=".<?php echo esc_attr($jf_term->slug) ?>"><?php echo esc_html($jf_term->name) ?></li>
                                    <?php
                                            endforeach;
                                        endif;
                                    endif;
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div <?php echo $this->get_render_attribute_string('enabel_filter'); ?>>
                    <div class="fastland-job-wrap layout-mode-<?php echo esc_attr($settings['layout_type']); ?>">
                        <?php
                        // including the item
                        include('contents/job-content.php');
                        ?>
                    </div>
                </div>
            </div>

<?php endif;
        wp_reset_postdata();
    }
}

$widgets_manager->register(new \fastland_job_loop());
