<?php
if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly
/**
 * Elementor Hello World
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class fastland_portfolio_loop extends \Elementor\Widget_Base
{
    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'fastland-portfolio';
    }

    public function get_script_depends()
    {
        return ['isotope', 'fastland-addon'];
    }
    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Portfolio', 'fastland-ts');
    }
    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-gallery-grid';
    }
    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['fastland-addons'];
    }
    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_layout',
            [
                'label' => __('Layout', 'fastland-ts'),
            ]
        );
        $this->add_control(
            'layout_type',
            [
                'label' => __('Layout type', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'masonry' => 'Masonry',
                    'normal' => 'Normal',
                ),
                'default' => 'masonry',
            ]
        );
        $this->add_control(
            'content_position',
            [
                'label' => __('Content Position', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'on-image' => 'On Image',
                    'below-image' => 'Below Image',
                    'disabled' => 'Hidden',
                ),
                'default' => 'on-image',
            ]
        );
        $this->add_control(
            'enable_filtering',
            [
                'label' => __('Enable Filtering??', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'enable_loadmore',
            [
                'label' => __('Enable Loadmore?', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'loadmore_text',
            [
                'label' => __('Loadmore Text', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Load more works', 'fastland-ts'),
                'condition' => [
                    'enable_loadmore' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'loadmore_align',
            [
                'label' => __('Loadmore Align', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'fastland-ts'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('top', 'fastland-ts'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'fastland-ts'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'condition' => [
                    'enable_loadmore' => 'yes'
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );
        $this->add_control(
            'loadmore_gap',
            [
                'label' => __('Loadmore Top Gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 400,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-loadmore-wrap' => 'margin-top:{{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'enable_loadmore' => 'yes'
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_width_nd_height',
            [
                'label' => __('Width & Height', 'fastland-ts'),
            ]
        );
        $this->add_control(
            'all_text',
            [
                'label' => __('Filter first item text', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('All WOrks', 'fastland-ts'),
                'condition' => [
                    'enable_filtering' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'use_meta_grid',
            [
                'label' => __('Use grid from meta?', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'post_grid',
            [
                'label' => __('Post Column', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'options' => array(
                    'col-md-12' => '1 Column',
                    'col-md-6' => '2 Column',
                    'col-md-4' => '3 Column',
                    'col-md-3' => '4 Column',
                ),
                'default' => 'col-md-4',
                'condition' => [
                    'use_meta_grid!' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'column_verti_gap',
            [
                'label' => __('Column Vertical Gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'desktop_default' => [
                    'size' => 15,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-portfolio-item-wrap' => 'padding: 0 {{SIZE}}{{UNIT}} 0;',
                ]
            ]
        );
        $this->add_responsive_control(
            'column_hori_gap',
            [
                'label' => __('Column Horizontal Gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'desktop_default' => [
                    'size' => 30,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-portfolio-item-wrap' => 'padding-bottom: {{SIZE}}{{UNIT}} ;',
                ]
            ]
        );
        $this->add_control(
            'use_custom_height',
            [
                'label' => __('Use custom height?', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_responsive_control(
            'normal_image_height',
            [
                'label' => __('Normal Image Height', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-portfolio-item-wrap.height-normal .fastland-portfolio-item img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'use_custom_height' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'big_image_height',
            [
                'label' => __('Big Image Height', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-portfolio-item-wrap.height-big .fastland-portfolio-item img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'use_custom_height' => 'yes'
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_query',
            [
                'label' => __('Query', 'fastland-ts'),
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts per page', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );
        $this->add_control(
            'source',
            [
                'label'         => __('Source', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => [
                    'portfolio' => 'Portfolio',
                    'manual_selection' => 'Manual Selection',
                    'related' => 'Related',
                ],
                'default' =>    'portfolio',
            ]
        );
        $this->add_control(
            'manual_selection',
            [
                'label'         => __('Manual Selection', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get specific template posts', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_slug_and_id('portfolio'),
                'default' =>    [],
                'condition' => [
                    'source' => 'manual_selection'
                ],
            ]
        );
        $this->start_controls_tabs(
            'include_exclude_tabs'
        );
        $this->start_controls_tab(
            'include_tabs',
            [
                'label' => __('Include', 'fastland-ts'),
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'include_by',
            [
                'label'         => __('Include by', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'label_block'   => true,
                'multiple'      => true,
                'options'       => [
                    'tags'  => 'Tags',
                    'category'  => 'Category',
                    'author' => 'Author',
                ],
                'default' =>    [],
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'include_categories',
            [
                'label'         => __('Include categories', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific category(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('portfolio-category'),
                'default' =>    [],
                'condition' => [
                    'include_by' => 'category',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'include_tags',
            [
                'label'         => __('Include Tags', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('portfolio-tag'),
                'default' =>    [],
                'condition' => [
                    'include_by' => 'tags',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'include_authors',
            [
                'label'         => __('Include authors', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_author_slug_and_id('portfolio'),
                'default' =>    [],
                'condition' => [
                    'include_by' => 'author',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'exclude_tabs',
            [
                'label' => __('Exclude', 'fastland-ts'),
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'exclude_by',
            [
                'label'         => __('Exclude by', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'label_block'   => true,
                'multiple'      => true,
                'options'       => [
                    'tags'  => 'tags',
                    'category'  => 'Category',
                    'author' => 'Author',
                    'current_post' => 'Current Post',
                ],
                'default' =>    [],
                'condition' => [
                    'source!' => 'manual_selection'
                ],
            ]
        );
        $this->add_control(
            'exclude_categories',
            [
                'label'         => __('Exclude categories', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific category(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('portfolio-category'),
                'default' =>    [],
                'condition' => [
                    'exclude_by' => 'category',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'exclude_tags',
            [
                'label'         => __('Exclude Tags', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_taxonomy_slug_and_name('portfolio-tag'),
                'default' =>    [],
                'condition' => [
                    'exclude_by' => 'tags',
                    'source!' => 'related'
                ],
            ]
        );
        $this->add_control(
            'exclude_authors',
            [
                'label'         => __('Exclude authors', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT2,
                'description'   => __('Get templates for specific tag(s)', 'fastland-ts'),
                'label_block'   => true,
                'multiple'      => true,
                'options'       => fastland_cpt_author_slug_and_id('portfolio'),
                'default' =>    [],
                'condition' => [
                    'exclude_by' => 'author',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'orderby',
            [
                'label'         => __('Order By', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => [
                    'date'   => 'Date',
                    'title'    => 'title',
                    'menu_order'    => 'Menu Order',
                    'rand'    => 'Random',
                ],
                'default' =>    'date',
            ]
        );
        $this->add_control(
            'order',
            [
                'label'         => __('Order', 'fastland-ts'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'options'       => [
                    'ASC'   => 'ASC',
                    'DESC'    => 'DESC',
                ],
                'default' =>    'DESC',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_filter_style',
            [
                'label' => __('Filter', 'fastland-ts'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_filtering' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'filter_align',
            [
                'label' => __('Filter Align', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'fastland-ts'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('top', 'fastland-ts'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'fastland-ts'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .pf-isotope-nav' => 'text-align: {{VALUE}};',
                ],
                'toggle' => true,
                'condition' => [
                    'enable_filtering' => 'yes'
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Filter Typography', 'fastland-ts'),
                'name' => 'filter_typo',
                'selector' => '{{WRAPPER}} .pf-isotope-nav li',
            ]
        );
        $this->add_control(
            'filter_color',
            [
                'label' => __('Filter Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pf-isotope-nav li' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'filter_hover_color',
            [
                'label' => __('Filter Hover Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pf-isotope-nav li:hover,{{WRAPPER}} .pf-isotope-nav li.active' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'fastland-ts'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_category',
            [
                'label' => __('Show category?', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_title_icon',
            [
                'label' => __('Show Icon?', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'title_icon',
            [
                'label' => __('Choose Title Icon', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'show_title_icon' => 'yes',
                ]
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_image',
            [
                'label' => __('Image', 'fastland-ts'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'image_hover_tabs'
        );
        $this->start_controls_tab(
            'image_normal_tab',
            [
                'label' => __('Normal', 'fastland-ts'),
            ]
        );
        $this->add_responsive_control(
            'image_radius',
            [
                'label' => __('Image Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    ' {{WRAPPER}} .fastland-portfolio-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_shadow',
                'label' => __('Button Shadow', 'fastland-ts'),
                'selector' => '{{WRAPPER}} .fastland-portfolio-item img',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'label' => __('Border', 'fastland-ts'),
                'selector' => '{{WRAPPER}} .fastland-portfolio-item img',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'image_hover_tab',
            [
                'label' => __('Hover', 'fastland-ts'),
            ]
        );
        $this->add_responsive_control(
            'image_hover_radius',
            [
                'label' => __('Box Image Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    ' {{WRAPPER}} .fastland-portfolio-item:hover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_hover_shadow',
                'label' => __('Button Shadow', 'fastland-ts'),
                'selector' => '{{WRAPPER}} .fastland-portfolio-item:hover img',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_hover_border',
                'label' => __('Border', 'fastland-ts'),
                'selector' => '{{WRAPPER}} .fastland-portfolio-item:hover img',
            ]
        );
        $this->add_control(
            'enable_hover_rotate',
            [
                'label' => __('Rotate animation on hover?', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'fastland-ts'),
                'label_off' => __('No', 'fastland-ts'),
                'return_value' => 'fastland-hover-rotate',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'image_hover_animation',
            [
                'label' => __('Hover Animation', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
                // 'prefix_class' => 'elementor-animation-',
                'condition' => [
                    'enable_hover_rotate!' => 'fastland-hover-rotate'
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_category_style',
            [
                'label' => __('Category', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_category' => 'yes',
                ]
            ]
        );
        $this->start_controls_tabs(
            'category_style_tabs'
        );
        $this->start_controls_tab(
            'category_style_normal_tab',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Category Typography', 'fastland-ts'),
                'name' => 'category_typo',
                'selector' => '{{WRAPPER}} .fastland-pf-category',
            ]
        );
        $this->add_control(
            'category_color',
            [
                'label' => __('Category Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-category' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'category_gap',
            [
                'label' => __('Category Gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 400,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-pf-category' => 'margin-bottom:{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'category_style_hover_tab',
            [
                'label' => __('Hover', 'fastland-hp'),
            ]
        );
        $this->add_control(
            'category_color_hover',
            [
                'label' => __('Category Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-category:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => __('Title', 'fastland-hp'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );
        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => __('Normal', 'fastland-hp'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Title Typography', 'fastland-ts'),
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .fastland-portfolio-title',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-portfolio-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'title_icon_line_color',
            [
                'label' => __('Title Icon Line Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-icon svg path' => 'stroke: {{VALUE}}',
                    '{{WRAPPER}} .title-icon i' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_title_icon' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'title_icon_fill_color',
            [
                'label' => __('SVG Fill Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-icon svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => [
                    'show_title_icon' => 'yes',
                ]
            ]
        );
        $this->add_responsive_control(
            'title_icon_rotate',
            [
                'label' => __('Rotate icon', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .title-icon svg, {{WRAPPER}} .title-icon i' => 'transform: rotate( {{SIZE}}deg );',
                ],
                'condition' => [
                    'show_title_icon' => 'yes',
                ]
            ]
        );
        $this->add_responsive_control(
            'title_icon_size',
            [
                'label' => __('icon Size', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -360,
                        'max' => 360,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .title-icon  svg' => 'width: {{SIZE}}{{UNIT}} ;',
                    '{{WRAPPER}} .title-icon  i' => 'font-size: {{SIZE}}{{UNIT}} ;',
                ],
                'condition' => [
                    'show_title_icon' => 'yes',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => __('Hover', 'fastland-hp'),
            ]
        );
        $this->add_control(
            'title_color_hover',
            [
                'label' => __('Title Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-portfolio-title:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'title_icon_line_color_hover',
            [
                'label' => __('Title Icon Line Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-portfolio-title:hover .title-icon svg path' => 'stroke: {{VALUE}}',
                    '{{WRAPPER}} .fastland-portfolio-title:hover .title-icon i' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_title_icon' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'title_icon_fill_color_hover',
            [
                'label' => __('SVG Fill Color', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-portfolio-title:hover .title-icon svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => [
                    'show_title_icon' => 'yes',
                ]
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'section_content_style',
            [
                'label' => __('Content Box', 'fastland-ts'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'content_align',
            [
                'label' => __('Align', 'fastland-hp'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'fastland-hp'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('top', 'fastland-hp'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'fastland-hp'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'prefix_class' => 'content-align%s-',
                'toggle' => true,
            ]
        );
        $this->add_control(
            'content_bg_color',
            [
                'label' => __('Content Background Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-portfolio-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_gap',
            [
                'label' => __('Content gap', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 400,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-portfolio-content.content-postion-on-image' => 'left:{{SIZE}}{{UNIT}};right:{{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'content_position' => 'on-image',
                ]
            ]
        );
        $this->add_control(
            'content_y_position',
            [
                'label' => __('Content Y Position', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}  .fastland-portfolio-content.content-postion-on-image' => 'bottom:{{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'content_position' => 'on-image',
                ]
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __('Content Padding', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .fastland-portfolio-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_radius',
            [
                'label' => __('Content Box Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .fastland-portfolio-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_radius',
            [
                'label' => __('Box Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    ' {{WRAPPER}} .fastland-portfolio-item ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_loadmore',
            [
                'label' => __('Loadmore', 'fastland-ts'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_loadmore' => 'yes'
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Typography', 'fastland-ts'),
                'name' => 'loadmore_typo',
                'selector' => '{{WRAPPER}} .fastland-pf-loadmore-btn',
            ]
        );
        $this->start_controls_tabs(
            'loadmore_hover_tabs'
        );
        $this->start_controls_tab(
            'loadmore_normal_tab',
            [
                'label' => __('Normal', 'fastland-ts'),
            ]
        );
        $this->add_control(
            'loadore_color',
            [
                'label' => __('Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-loadmore-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'loadmore_background_color',
            [
                'label' => __('Filter background Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-loadmore-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'loadmore_border',
                'label' => __('Border', 'fastland-ts'),
                'selector' => '{{WRAPPER}} .fastland-pf-loadmore-btn',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'loadmore_hover_tab',
            [
                'label' => __('Hover', 'fastland-ts'),
            ]
        );
        $this->add_control(
            'loadore_hover_color',
            [
                'label' => __('Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-loadmore-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'loadmore_hover_bg_color',
            [
                'label' => __('Filter background Color', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-loadmore-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'loadmore_hover_border',
                'label' => __('Border', 'fastland-ts'),
                'selector' => '{{WRAPPER}} .fastland-pf-loadmore-btn:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Button Padding', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => '22',
                    'right' => '38',
                    'bottom' => '21',
                    'left' => '38',
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-loadmore-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_radius',
            [
                'label' => __('Border Radius', 'fastland-ts'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => '33',
                    'right' => '33',
                    'bottom' => '33',
                    'left' => '33',
                ],
                'selectors' => [
                    '{{WRAPPER}} .fastland-pf-loadmore-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_shadow',
                'label' => __('Button Shadow', 'fastland-ts'),
                'selector' => '{{WRAPPER}} .fastland-pf-loadmore-btn',
                'fields_options' =>
                [
                    'box_shadow_type' =>
                    [
                        'default' => 'yes',
                    ],
                    'box_shadow' => [
                        'default' =>
                        [
                            'horizontal' => 0,
                            'vertical' => 0,
                            'blur' => 0,
                            'spread' => 0,
                            'color' => 'rgba(3, 3, 3, 0.14)',
                        ],
                    ],
                ],
            ]
        );
        $this->end_controls_section();
    }
    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings();
        $paged = get_query_var('paged') ? get_query_var('paged') : 1;
        $portfolio_data = [];
        $portfolio_data['settings'] = $this->get_settings();
        $portfolio_data = json_encode($portfolio_data);
        // Including the query 
        include('queries/portfolio-query.php');
        if ($the_query->have_posts()) :
            if ($settings['enable_filtering']) :
?>
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <ul class="pf-isotope-nav text-<?php echo esc_attr($settings['filter_align']); ?>">
                                <li data-filter="<?php echo esc_attr('*') ?>" class="active"><?php echo esc_html($settings['all_text'])  ?></li>
                                <?php
                                if (0 != count($settings['include_categories'])) :
                                    foreach ($settings['include_categories'] as $cat) :
                                        $pf_term = get_term_by('slug', $cat, 'portfolio-category');
                                ?>
                                        <li data-filter=".<?php echo esc_attr($pf_term->slug) ?>"><?php echo esc_html($pf_term->name) ?></li>
                                        <?php
                                    endforeach;
                                else :
                                    $pf_terms = get_terms('portfolio-category');
                                    if (!empty($pf_terms)) :
                                        foreach ($pf_terms as $pf_term) : ?>
                                            <li data-filter=".<?php echo esc_attr($pf_term->slug) ?>"><?php echo esc_html($pf_term->name) ?></li>
                                <?php
                                        endforeach;
                                    endif;
                                endif;
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="container-fluid">
                <div class="row fastland-portfolio-wrap layout-mode-<?php echo esc_attr($settings['layout_type'] . ' ' . $settings['enable_hover_rotate']) . ' enable-filter-' . $settings['enable_filtering']  ?>">
                    <?php
                    // including the item
                    include('contents/portfolio-content.php');
                    ?>
                </div>
            </div>
            <?php
            $total_posts = $the_query->found_posts;
            if ('yes' == $settings['enable_loadmore'] && '-1' != $settings['posts_per_page'] && $total_posts >= $settings['posts_per_page']) :
                $posts_per_page = $settings['posts_per_page'];
                $page_amount = ceil($total_posts / $posts_per_page);
                $ajaxurl = admin_url('admin-ajax.php');
                $nonce = wp_create_nonce('fastland_loadmore_callback');
            ?>
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-12">
                            <div class="fastland-loadmore-wrap text-<?php echo $settings['loadmore_align']; ?>">
                                <span id="load-next-portfolios-message"></span>
                                <span class="fastland-pf-loadmore-btn" data-url="<?php echo esc_url($ajaxurl) ?>" data-referrar="<?php echo $nonce; ?>" data-total-page="<?php echo $page_amount; ?>" data-paged="<?php echo $paged; ?>" data-portfolio-settings='<?php echo $portfolio_data ?>'><?php echo $settings['loadmore_text'] ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
<?php endif;
        wp_reset_postdata();
    }
}

$widgets_manager->register(new \fastland_portfolio_loop());
