<?php

namespace Finest_Addons\Widgets;

if (!defined('ABSPATH')) exit;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Widget_Base;

class Finest_Animated_Text extends Widget_Base
{

	public function get_name()
	{
		return 'finest-animated';
	}

	public function get_title()
	{
		return esc_html__('Animated Text', 'fd-addons');
	}

	public function get_icon()
	{
		return 'eicon-animated-headline';
	}

	public function get_categories()
	{
		return ['fd-addons'];
	}

	public function get_keywords()
	{
		return ['fd-addons', 'fancy', 'heading', 'animate', 'animation'];
	}

	// public function get_script_depends() {
	// 	return [ 'animated-heading' ];
	// }

	protected function register_controls()
	{

		/*
	    * Animated Text Content
	    */
		$this->start_controls_section(
			'fd_addons_section_animated_text_content',
			[
				'label' => esc_html__('Content', 'fd-addons')
			]
		);

		$this->add_control(
			'fd_addons_animated_text_before_text',
			[
				'label'   => esc_html__('Before Text', 'fd-addons'),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__('This is', 'fd-addons')
			]
		);

		$this->add_control(
			'fd_addons_animated_text_animated_heading',
			[
				'label'       => esc_html__('Animated Text', 'fd-addons'),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Enter your animated text with comma separated.', 'fd-addons'),
				'description' => __('<b>Write animated heading with comma separated. Example: Exclusive, Addons, Elementor</b>', 'fd-addons'),
				'default'     => esc_html__('Finestdevs, Addons, Elementor', 'fd-addons'),
				'dynamic'     => ['active' => true]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_after_text',
			[
				'label'   => esc_html__('After Text', 'fd-addons'),
				'type'    => Controls_Manager::TEXTAREA,
				'default' => esc_html__('For You.', 'fd-addons')
			]
		);

		$this->add_control(
			'fd_addons_animated_text_animated_heading_tag',
			[
				'label'   => esc_html__('HTML Tag', 'fd-addons'),
				'type'    => Controls_Manager::CHOOSE,
				'default' => 'h3',
				'toggle'  => false,
				'options' => [
					'h1'  => [
						'title' => __('H1', 'fd-addons'),
						'icon'  => 'eicon-editor-h1'
					],
					'h2'  => [
						'title' => __('H2', 'fd-addons'),
						'icon'  => 'eicon-editor-h2'
					],
					'h3'  => [
						'title' => __('H3', 'fd-addons'),
						'icon'  => 'eicon-editor-h3'
					],
					'h4'  => [
						'title' => __('H4', 'fd-addons'),
						'icon'  => 'eicon-editor-h4'
					],
					'h5'  => [
						'title' => __('H5', 'fd-addons'),
						'icon'  => 'eicon-editor-h5'
					],
					'h6'  => [
						'title' => __('H6', 'fd-addons'),
						'icon'  => 'eicon-editor-h6'
					]
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_animated_heading_alignment',
			[
				'label'   => esc_html__('Alignment', 'fd-addons'),
				'type'    => Controls_Manager::CHOOSE,
				'toggle'  => false,
				'options' => [
					'fd-addons-animated-text-align-left'   => [
						'title' => __('Left', 'fd-addons'),
						'icon'  => 'eicon-text-align-left'
					],
					'fd-addons-animated-text-align-center' => [
						'title' => __('Center', 'fd-addons'),
						'icon'  => 'eicon-text-align-center'
					],
					'fd-addons-animated-text-align-right'  => [
						'title' => __('Right', 'fd-addons'),
						'icon'  => 'eicon-text-align-right'
					]
				],
				'default' => 'fd-addons-animated-text-align-center'
			]
		);

		$this->end_controls_section();

		/*
	    * Animated Text Container Style
	    */
		$this->start_controls_section(
			'fd_addons_section_animated_text_animation_tyle',
			[
				'label' => esc_html__('Animation', 'fd-addons'),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'fd_addons_animated_text_animated_heading_animated_type',
			[
				'label'   => esc_html__('Animation Type', 'fd-addons'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'fd-addons-typed-animation',
				'options' => [
					'fd-addons-typed-animation'   => __('Typed', 'fd-addons'),
					'fd-addons-morphed-animation' => __('Animate', 'fd-addons')
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_animated_heading_animation_style',
			[
				'label'   => esc_html__('Animation Style', 'fd-addons'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'fadeIn',
				'options' => [
					'fadeIn'            => __('Fade In', 'fd-addons'),
					'fadeInUp'          => __('Fade In Up', 'fd-addons'),
					'fadeInDown'        => __('Fade In Down', 'fd-addons'),
					'fadeInLeft'        => __('Fade In Left', 'fd-addons'),
					'fadeInRight'       => __('Fade In Right', 'fd-addons'),
					'zoomIn'            => __('Zoom In', 'fd-addons'),
					'zoomInUp'          => __('Zoom In Up', 'fd-addons'),
					'zoomInDown'        => __('Zoom In Down', 'fd-addons'),
					'zoomInLeft'        => __('Zoom In Left', 'fd-addons'),
					'zoomInRight'       => __('Zoom In Right', 'fd-addons'),
					'slideInDown'       => __('Slide In Down', 'fd-addons'),
					'slideInUp'         => __('Slide In Up', 'fd-addons'),
					'slideInLeft'       => __('Slide In Left', 'fd-addons'),
					'slideInRight'      => __('Slide In Right', 'fd-addons'),
					'bounce'            => __('Bounce', 'fd-addons'),
					'bounceIn'          => __('Bounce In', 'fd-addons'),
					'bounceInUp'        => __('Bounce In Up', 'fd-addons'),
					'bounceInDown'      => __('Bounce In Down', 'fd-addons'),
					'bounceInLeft'      => __('Bounce In Left', 'fd-addons'),
					'bounceInRight'     => __('Bounce In Right', 'fd-addons'),
					'flash'             => __('Flash', 'fd-addons'),
					'pulse'             => __('Pulse', 'fd-addons'),
					'rotateIn'          => __('Rotate In', 'fd-addons'),
					'rotateInDownLeft'  => __('Rotate In Down Left', 'fd-addons'),
					'rotateInDownRight' => __('Rotate In Down Right', 'fd-addons'),
					'rotateInUpRight'   => __('rotate In Up Right', 'fd-addons'),
					'rotateIn'          => __('Rotate In', 'fd-addons'),
					'rollIn'            => __('Roll In', 'fd-addons'),
					'lightSpeedIn'      => __('Light Speed In', 'fd-addons')
				],
				'condition' => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-morphed-animation'
				]
			]
		);

		$this->end_controls_section();

		/*
	    * Animated Text Settings
	    */
		$this->start_controls_section(
			'fd_addons_section_animated_text_settings',
			[
				'label' => esc_html__('Settings', 'fd-addons'),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'fd_addons_animated_text_animation_speed',
			[
				'label'     => __('Animation Speed', 'fd-addons'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1000,
				'min'       => 100,
				'max'       => 10000,
				'condition' => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-morphed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_type_speed',
			[
				'label'   => __('Type Speed', 'fd-addons'),
				'type'    => Controls_Manager::NUMBER,
				'default' => 60,
				'min'     => 10,
				'max'     => 200,
				'step'    => 10,
				'condition' => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_start_delay',
			[
				'label'     => __('Start Delay', 'fd-addons'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1000,
				'min'       => 1000,
				'max'       => 10000,
				'condition' => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_back_type_speed',
			[
				'label'     => __('Back Type Speed', 'fd-addons'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 60,
				'min'       => 10,
				'max'       => 200,
				'step'      => 10,
				'condition' => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_back_delay',
			[
				'label'     => __('Back Delay', 'fd-addons'),
				'type'      => Controls_Manager::NUMBER,
				'default'   => 1000,
				'min'       => 1000,
				'max'       => 10000,
				'condition' => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_loop',
			[
				'label'        => __('Loop', 'fd-addons'),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __('ON', 'fd-addons'),
				'label_off'    => __('OFF', 'fd-addons'),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_show_cursor',
			[
				'label'        => __('Show Cursor', 'fd-addons'),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __('ON', 'fd-addons'),
				'label_off'    => __('OFF', 'fd-addons'),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_fade_out',
			[
				'label'        => __('Fade Out', 'fd-addons'),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __('ON', 'fd-addons'),
				'label_off'    => __('OFF', 'fd-addons'),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_smart_backspace',
			[
				'label'        => __('Smart Backspace', 'fd-addons'),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __('ON', 'fd-addons'),
				'label_off'    => __('OFF', 'fd-addons'),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'fd_addons_animated_text_animated_heading_animated_type' => 'fd-addons-typed-animation'
				]
			]
		);

		$this->end_controls_section();

		/*
	    * Animated Text pre animated Text Style
		*/
		$this->start_controls_section(
			'fd_addons_pre_animated_text_style',
			[
				'label'     => esc_html__('Pre Animated text', 'fd-addons'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'fd_addons_animated_text_before_text!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'fd_addons_pre_animated_text_typography',
				'fields_options'   => [
					'font_size'    => [
						'default'  => [
							'unit' => 'px',
							'size' => 30
						]
					],
					'font_weight'  => [
						'default'  => '600'
					]
				],
				'selector' => '{{WRAPPER}} .fd-addons-animated-text-pre-heading',
			]
		);

		$this->add_control(
			'fd_addons_pre_animated_text_color',
			[
				'label'     => esc_html__('Color', 'fd-addons'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => [
					'{{WRAPPER}} .fd-addons-animated-text-pre-heading' => 'color: {{VALUE}}'
				]
			]
		);

		$this->end_controls_section();

		/*
	    * Animated Text animated Text Style
	    */
		$this->start_controls_section(
			'fd_addons_animated_text_style',
			[
				'label' => esc_html__('Animated text', 'fd-addons'),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'fd_addons_animated_text_typography',
				'fields_options'   => [
					'font_size'    => [
						'default'  => [
							'unit' => 'px',
							'size' => 30
						]
					],
					'font_weight'  => [
						'default'  => '600'
					]
				],
				'selector' => '{{WRAPPER}} .fd-addons-animated-text-animated-heading, {{WRAPPER}} span.typed-cursor'
			]
		);

		$this->add_control(
			'fd_addons_animated_text_color',
			[
				'label'     => esc_html__('Color', 'fd-addons'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222',
				'selectors' => [
					'{{WRAPPER}} .fd-addons-animated-text-animated-heading, {{WRAPPER}} span.typed-cursor' => 'color: {{VALUE}}'
				]
			]
		);

		$this->add_control(
			'fd_addons_animated_text_spacing',
			[
				'label'      => __('Spacing', 'fd-addons'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'default'    => [
					'unit'   => 'px',
					'size'   => 8
				],
				'range'      => [
					'px'     => [
						'min' => 0,
						'max' => 50
					]
				],
				'selectors'  => [
					'{{WRAPPER}} .fd-addons-animated-text-animated-heading' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};'
				]
			]
		);

		$this->end_controls_section();

		/*
	    * Animated Text post animated Text Style
	    */
		$this->start_controls_section(
			'fd_addons_post_animated_text_style',
			[
				'label'     => esc_html__('Post Animated text', 'fd-addons'),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'fd_addons_animated_text_after_text!' => ''
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'fd_addons_post_animated_text_typography',
				'fields_options'   => [
					'font_size'    => [
						'default'  => [
							'unit' => 'px',
							'size' => 30
						]
					],
					'font_weight'  => [
						'default'  => '600'
					]
				],
				'selector' => '{{WRAPPER}} .fd-addons-animated-text-post-heading'
			]
		);

		$this->add_control(
			'fd_addons_post_animated_text_color',
			[
				'label'     => esc_html__('Color', 'fd-addons'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#222222',
				'selectors' => [
					'{{WRAPPER}} .fd-addons-animated-text-post-heading' => 'color: {{VALUE}}'
				]
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings      = $this->get_settings_for_display();
		$id            = substr($this->get_id_int(), 0, 3);
		$type_heading  = explode(',', $settings['fd_addons_animated_text_animated_heading']);
		$before_text   = $settings['fd_addons_animated_text_before_text'];
		$heading_text  = $settings['fd_addons_animated_text_animated_heading'];
		$after_text    = $settings['fd_addons_animated_text_after_text'];
		$heading_tag   = $settings['fd_addons_animated_text_animated_heading_tag'];
		$heading_align = $settings['fd_addons_animated_text_animated_heading_alignment'];

		$this->add_render_attribute('fd_addons_typed_animated_string', 'class', 'fd-addons-typed-strings');
		$this->add_render_attribute(
			'fd_addons_typed_animated_string',
			[
				'data-type_string'       => esc_attr(json_encode($type_heading)),
				'data-heading_animation' => esc_attr($settings['fd_addons_animated_text_animated_heading_animated_type'])
			]
		);

		if ($settings['fd_addons_animated_text_animated_heading_animated_type'] === 'fd-addons-typed-animation') {
			$this->add_render_attribute(
				'fd_addons_typed_animated_string',
				[
					'data-type_speed'      => esc_attr($settings['fd_addons_animated_text_type_speed']),
					'data-back_type_speed' => esc_attr($settings['fd_addons_animated_text_back_type_speed']),
					'data-loop'            => esc_attr($settings['fd_addons_animated_text_loop']),
					'data-show_cursor'     => esc_attr($settings['fd_addons_animated_text_show_cursor']),
					'data-fade_out'        => esc_attr($settings['fd_addons_animated_text_fade_out']),
					'data-smart_backspace' => esc_attr($settings['fd_addons_animated_text_smart_backspace']),
					'data-start_delay'     => esc_attr($settings['fd_addons_animated_text_start_delay']),
					'data-back_delay'      => esc_attr($settings['fd_addons_animated_text_back_delay'])
				]
			);
		}

		if ($settings['fd_addons_animated_text_animated_heading_animated_type'] === 'fd-addons-morphed-animation') {
			$this->add_render_attribute(
				'fd_addons_typed_animated_string',
				[
					'data-animation_style' => esc_attr($settings['fd_addons_animated_text_animated_heading_animation_style']),
					'data-animation_speed' => esc_attr($settings['fd_addons_animated_text_animation_speed'])
				]
			);
		}

		$this->add_render_attribute(
			'fd_addons_animated_text_animated_heading',
			[
				'id'    => 'fd-addons-animated-text-' . $id,
				'class' => 'fd-addons-animated-text-animated-heading'
			]
		);

		$this->add_render_attribute('fd_addons_animated_text_before_text', 'class', 'fd-addons-animated-text-pre-heading');
		$this->add_inline_editing_attributes('fd_addons_animated_text_before_text');

		$this->add_render_attribute('fd_addons_animated_text_after_text', 'class', 'fd-addons-animated-text-post-heading');
		$this->add_inline_editing_attributes('fd_addons_animated_text_after_text');

		echo '<div class="fd-addons-animated-text ' . esc_attr($heading_align) . '">';

		do_action('fd_addons_animated_text_wrapper_before');

		echo '<' . esc_attr($heading_tag) . ' ' . $this->get_render_attribute_string('fd_addons_typed_animated_string') . '>';

		do_action('fd_addons_animated_text_content_before');

		$before_text ? printf('<span ' . $this->get_render_attribute_string('fd_addons_animated_text_before_text') . '>%s</span>', wp_kses_post($before_text)) : '';

		if ('fd-addons-typed-animation' === $settings['fd_addons_animated_text_animated_heading_animated_type']) {
			echo '<span id="fd-addons-animated-text-' . esc_attr($id) . '" class="fd-addons-animated-text-animated-heading"></span>';
		}

		if ('fd-addons-morphed-animation' === $settings['fd_addons_animated_text_animated_heading_animated_type']) {
			echo '<span ' . $this->get_render_attribute_string('fd_addons_animated_text_animated_heading') . '>' . wp_kses_post($heading_text) . '</span>';
		}

		$after_text ? printf('<span ' . $this->get_render_attribute_string('fd_addons_animated_text_after_text') . '>%s</span>', wp_kses_post($after_text)) : '';

		do_action('fd_addons_animated_text_content_after');

		echo '</' . esc_attr($heading_tag) . '>';

		do_action('fd_addons_animated_text_wrapper_after');

		echo '</div>';
	}
}
$widgets_manager->register(new \Finest_Addons\Widgets\Finest_Animated_Text());
