<?php

namespace Finest_Addons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}
/**
 * Elementor oEmbed Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class Price_Table extends \Elementor\Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve oEmbed widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'fd-addons-price-table';
    }

    /**
     * Get widget title.
     *
     * Retrieve oEmbed widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Pricing Table', 'fd-addons');
    }

    /**
     * Get widget icon.
     *
     * Retrieve oEmbed widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-price-table';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the oEmbed widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['fd-addons'];
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the oEmbed widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function search_keyword()
    {
        return ['Price', 'pricing table', 'pricing'];
    }

    /**
     * Register oEmbed widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        /**
         * Content tab
         */
        $this->start_controls_section(
            'price_tabs',
            [
                'label' => __('Price Tabs', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'first_tab_title',
            [
                'label'   => __('First tab title', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Monthly '),
            ]
        );

        $this->add_control(
            'second_tab_title',
            [
                'label'   => __('Second tab title', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Yearly '),
            ]
        );

        $this->add_control(
            'price_offer',
            [
                'label'   => __('Offer text', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html('Save 20% '),
            ]
        );
        $this->add_control(
            'switcher_style',
            [
                'label'   => __('Switcher Style', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'style-1' => __('Style 1', 'fd-addons'),
                    'style-2' => __('Style 2', 'fd-addons'),
                ],
            ]
        );
        $this->add_responsive_control(
            'tab_align',
            [
                'label'     => __('Align', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'flex-start' => [
                        'title' => __('Left', 'fd-addons'),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center'     => [
                        'title' => __('top', 'fd-addons'),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'flex-end'   => [
                        'title' => __('Right', 'fd-addons'),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'center',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-tabs' => 'justify-content:{{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'price_tables',
            [
                'label' => __('Price tables', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'pricing_grid',
            [
                'label'          => __('Columns', 'fd-addons'),
                'type'           => \Elementor\Controls_Manager::SELECT,
                'options'        => array(
                    '12' => '1 Column',
                    '6'  => '2 Column',
                    '4'  => '3 Column',
                    '3'  => '4 Column',
                ),
                'default'        => 4,
                'tablet_default' => 6,
                'mobile_default' => 12,
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label'      => __('Column Gap', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .pricing-box-wrap>div' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .pricing-box-wrap'     => 'margion-left: -{{SIZE}}{{UNIT}}; margion-right: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'focused',
            [
                'label'        => __('Make it focsed', 'fd-addons'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __('Not Focused', 'fd-addons'),
                'label_off'    => __('Focused', 'fd-addons'),
                'return_value' => 'focused',

            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'   => __('Price title', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => 'Personal',
            ]
        );

        $repeater->add_control(
            'price_badge',
            [
                'label' => __('Price Badge', 'fd-addons'),
                'type'  => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'price_currency',
            [
                'label'   => __('Price Currency', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('$', 'fd-addons'),
            ]
        );

        $repeater->add_control(
            'price_monthly',
            [
                'label'   => __('Montly Price', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('99', 'fd-addons'),
            ]
        );

        $repeater->add_control(
            'price_duration_monthly',
            [
                'label'   => __('Montly Price Duration text', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('per month', 'fd-addons'),
            ]
        );

        $repeater->add_control(
            'price_subtitle_monthly',
            [
                'label'   => __('Montly Price Subtitle', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('billed monthly', 'fd-addons'),
            ]
        );

        $repeater->add_control(
            'price_yearly',
            [
                'label'   => __('Yearly  Price', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('180', 'fd-addons'),
            ]
        );

        $repeater->add_control(
            'price_duration_yearly',
            [
                'label'   => __('Yearly Price Duration text', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('per year', 'fd-addons'),
            ]
        );

        $repeater->add_control(
            'price_subtitle_yearly',
            [
                'label'   => __('Yearly Price Subtitle', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => __('billed Yearly', 'fd-addons'),
            ]
        );

        $repeater->add_control(
            'features',
            [
                'label' => __('Features', 'fd-addons'),
                'type'  => \Elementor\Controls_Manager::WYSIWYG,
            ]
        );

        $repeater->add_control(
            'show_btn',
            [
                'label'        => __('Show Button', 'fd-addons'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __('Show', 'fd-addons'),
                'label_off'    => __('Hide', 'fd-addons'),
                'default'      => 'true',
                'return_value' => 'true',
            ]
        );

        $repeater->add_control(
            'btn_icon',
            [
                'label'     => __('Button Icon', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value'   => '',
                    'library' => '',
                ],
                'condition' => [
                    'show_btn' => 'true',
                ],
            ]
        );

        $repeater->add_control(
            'button_label',
            [
                'label'     => __('Button text', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::TEXTAREA,
                'default'   => 'Learn More',
                'condition' => [
                    'show_btn' => 'true',
                ],
            ]
        );

        $repeater->add_control(
            'button_url',
            [
                'label'     => __('Button URL', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::URL,
                'condition' => [
                    'show_btn' => 'true',
                ],
            ]

        );

        $repeater->add_control(
            'bottom_info',
            [
                'label'   => __('Bottom Info', 'fd-addons'),
                'type'    => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'No credit card required',
            ]
        );

        $this->add_control(
            'pricing_list',
            [
                'label'       => __('Repeater List', 'fd-addons'),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_responsive_control(
            'content_align',
            [
                'label'     => __('Align', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'flex-start' => [
                        'title' => __('Left', 'fd-addons'),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center'     => [
                        'title' => __('top', 'fd-addons'),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'flex-end'   => [
                        'title' => __('Right', 'fd-addons'),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'center',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align:{{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        /**
         * Style tab
         */
        $this->start_controls_section(
            'pricing_tabs_tyle',
            [
                'label' => __('Pricing Tabs', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'tabs_title_typo',
                'label'    => __('Title typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .first-tabs-title,{{WRAPPER}} .second-tabs-title',
            ]
        );

        $this->add_control(
            'tabs_title_color',
            [
                'label'     => __('Title Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .first-tabs-title, {{WRAPPER}} .second-tabs-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'tabs_title_active_color',
            [
                'label'     => __('Title Active Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .first-tabs-title.active, {{WRAPPER}} .second-tabs-title.active' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'switcher_style' => 'style-2',
                ],
            ]
        );
        $this->add_control(
            'tabs_title_active_bg_color',
            [
                'label'     => __('Title Active Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .first-tabs-title.active, {{WRAPPER}} .second-tabs-title.active' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'switcher_style' => 'style-2',
                ],
            ]
        );

        $this->add_control(
            'switcher_divide',
            [
                'type'      => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'switcher_style' => 'style-1',
                ],
            ]
        );

        $this->add_control(
            'switcher_bg_color',
            [
                'label'     => __('Switcher Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #pricing-dynamic-deck--head .btn-toggle' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'switcher_style' => 'style-1',
                ],
            ]
        );

        $this->add_control(
            'switcher_bg_active_color',
            [
                'label'     => __('Switcher Active Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #pricing-dynamic-deck--head .btn-toggle.active' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'switcher_style' => 'style-1',
                ],
            ]
        );

        $this->add_control(
            'switcher_circle_color',
            [
                'label'     => __('Switcher Circle Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #pricing-dynamic-deck--head .btn-toggle span' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'switcher_style' => 'style-1',
                ],
            ]
        );

        $this->add_control(
            'offer_divide',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'offer_typo',
                'label'    => __('Offer typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-price-offer',
            ]
        );

        $this->add_control(
            'offer_color',
            [
                'label'     => __('Offer Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-price-offer' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'offer_bg_color',
            [
                'label'     => __('Offer Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-price-offer' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_padding',
            [
                'label'      => __('Offer Text Padding', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-price-offer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'offer_radius',
            [
                'label'      => __('Offer Text Radius', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-price-offer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'Price_Badge',
            [
                'label' => __('Price Badge', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'price_badge_style_tabs'
        );

        $this->start_controls_tab(
            'price_badge_normal_tab',
            [
                'label' => __('Normal', 'fd-addons'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'badge_typo',
                'label'    => __('Badge Typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-badge',
            ]
        );

        $this->add_control(
            'badge_color',
            [
                'label'     => __('Badge Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-badge' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'badge_bg_color',
            [
                'label'     => __('Badge Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-badge' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'badge_radius',
            [
                'label'      => __('Badge Radius', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default'    => [
                    'top'    => '8',
                    'right'  => '8',
                    'bottom' => '8',
                    'left'   => '8',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'badge_padding',
            [
                'label'      => __('Badge Padding', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-badge' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'badge_x_postion',
            [
                'label'      => __('Badge X Position', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-badge' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'badge_y_postion',
            [
                'label'      => __('Badge Y Position', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-badge' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'price_badge_active_tab',
            [
                'label' => __('Active', 'fd-addons'),
            ]
        );

        $this->add_control(
            'badge_color_active',
            [
                'label'     => __('Badge Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-badge' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'badge_bg_color_active',
            [
                'label'     => __('Badge Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-badge' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'Title_style',
            [
                'label' => __('Title', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'price_title_style_tabs'
        );

        $this->start_controls_tab(
            'price_title_normal_tab',
            [
                'label' => __('Normal', 'fd-addons'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typo',
                'label'    => __('Title typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-title',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __('Title Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'price_title_active_tab',
            [
                'label' => __('Active', 'fd-addons'),
            ]
        );
        $this->add_control(
            'title_color_active',
            [
                'label'     => __('Title Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'price_style',
            [
                'label' => __('Price', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'price_style_tabs'
        );

        $this->start_controls_tab(
            'price_normal_tab',
            [
                'label' => __('Normal', 'fd-addons'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'price_typo',
                'label'    => __('Price typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-area .fd-addons-pricing-item .fd-addons-price h2',
            ]
        );
        $this->add_control(
            'price_color',
            [
                'label'     => __('Price Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-area .fd-addons-pricing-item .fd-addons-price h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'price_currency_typo',
                'label'    => __('Price Currency Typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-area .fd-addons-pricing-item .fd-addons-price .price-currency',
            ]
        );
        $this->add_control(
            'price_currency_color',
            [
                'label'     => __('Currency Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-area .fd-addons-pricing-item .fd-addons-price .price-currency' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'dura_style_divider',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'price_dur_typo',
                'label'    => __('Price Duration typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-price span.fd-addons-pricing-duration',
            ]
        );

        $this->add_control(
            'duration_color',
            [
                'label'     => __('Duration Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-duration' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'subtitle_style_divider',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'price_subtitle_typo',
                'label'    => __('Price Subtitle typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-price span.price-subtitle',
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label'     => __('Subtitle Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'pricing_subtitle_border',
                'label'    => __('Price Border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .price-subtitle',
            ]
        );

        $this->add_control(
            'price_wrap_bg_color',
            [
                'label'     => __('Price Wrap Backgrounr', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-price-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'pricing_wrap_border',
                'label'    => __('Price Border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-price-wrap',
            ]
        );

        $this->add_control(
            'price_toggle',
            [
                'label'        => __('Price Advanced Options', 'fd-addons'),
                'type'         => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off'    => __('Default', 'fd-addons'),
                'label_on'     => __('Custom', 'fd-addons'),
                'return_value' => 'yes',
            ]
        );
        $this->start_popover();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'        => 'pricing_border',
                'label'       => __('Price Border', 'fd-addons'),
                'label_block' => true,
                'selector'    => '{{WRAPPER}} .fd-addons-price',
            ]
        );

        $this->add_responsive_control(
            'price_subtitle_padding',
            [
                'label'      => __('Price Subtitle Margin', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .price-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_subtitle_gap',
            [
                'label'      => __('Price Subtitle Margin', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .price-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'pricing_padding',
            [
                'label'      => __('Price Padding', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_wrap_padding',
            [
                'label'      => __('Price Wrap Padding', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-price-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_wrap_gap',
            [
                'label'      => __('Price Gap', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-price-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_popover();
        $this->end_controls_tab();
        $this->start_controls_tab(
            'price_active_tab',
            [
                'label' => __('Active', 'fd-addons'),
            ]
        );
        $this->add_control(
            'price_color_active',
            [
                'label'     => __('Price Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-area .fd-addons-pricing-item .fd-addons-price h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'price_currency_color_active',
            [
                'label'     => __('Currency Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused = .fd-addons-pricing-area .fd-addons-pricing-item .fd-addons-price .price-currency' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'duration_color_active',
            [
                'label'     => __('Duration Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-duration' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'subtitle_color_active',
            [
                'label'     => __('Subtitle Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .price-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'price_wrap_bg_color_active',
            [
                'label'     => __('Price Wrap Backgrounr', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused  .fd-addons-price-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'pricing_wrap_border_active',
                'label'    => __('Price Border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-item.focused  .fd-addons-price-wrap',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
        $this->start_controls_section(
            'feature_style',
            [
                'label' => __('Feature', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'price_features_style_tabs'
        );

        $this->start_controls_tab(
            'price_features_normal_tab',
            [
                'label' => __('Normal', 'fd-addons'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'features_typo',
                'label'    => __('Features typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-features',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'features_strong_typo',
                'label'    => __('Features Strong typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-features strong',
            ]
        );

        $this->add_control(
            'features_color',
            [
                'label'     => __('Features Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-features' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'features_strong_color',
            [
                'label'     => __('Features Strong Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-features strong' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'features_icon_color',
            [
                'label'     => __('Features Icon Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-features i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'feature_border',
                'label'    => __('Feature Border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-features',
            ]
        );

        $this->add_responsive_control(
            'features_align',
            [
                'label'     => __('Align', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __('Left', 'fd-addons'),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('top', 'fd-addons'),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __('Right', 'fd-addons'),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'center',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-features' => 'text-align:{{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'feature_icon_gap',
            [
                'label'      => __('Icon Gap', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-features i' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'feature_item_gap',
            [
                'label'      => __('Item gap', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-features p:not(:last-child),{{WRAPPER}} .fd-addons-pricing-features ul li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'feature_padding',
            [
                'label'      => __('Padding', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-features' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'feature_gap',
            [
                'label'      => __('Margin', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-features' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'price_features_active_tab',
            [
                'label' => __('Active', 'fd-addons'),
            ]
        );
        $this->add_control(
            'features_color_active',
            [
                'label'     => __('Features Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-features' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'features_strong_color_active',
            [
                'label'     => __('Features Strong Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-features strong' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'features_icon_color_active',
            [
                'label'     => __('Features Icon Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-pricing-features i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'button_style',
            [
                'label' => __('Button', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'button_style_tabs'
        );

        $this->start_controls_tab(
            'button_style_normal_tab',
            [
                'label' => __('Normal', 'fd-addons'),
            ]
        );

        $this->add_control(
            'boxed_btn_color',
            [
                'label'     => __('Button Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-btn-wrapper .fd-addons-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'boxed_btn_background',
            [
                'label'     => __('Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-btn-wrapper .fd-addons-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'button_border',
                'label'    => __('Border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-btn-wrapper .fd-addons-btn',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_shadow',
                'label'    => __('Button Shadow', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-btn-wrapper .fd-addons-btn',
            ]
        );

        $this->add_responsive_control(
            'button_radius',
            [
                'label'      => __('Border Radius', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-btn-wrapper .fd-addons-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_padding',
            [
                'label'      => __('Button Padding', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-btn-wrapper .fd-addons-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_style_active_tab',
            [
                'label' => __('Active', 'fd-addons'),
            ]
        );

        $this->add_control(
            'btn_active_color',
            [
                'label'     => __('Button Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused.fd-addons-pricing-item.focused  .fd-addons-btn-wrapper .fd-addons-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_active_background',
            [
                'label'     => __('Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-btn-wrapper .fd-addons-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'button_active_border',
                'label'    => __('Border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-btn-wrapper .fd-addons-btn',
            ]
        );

        $this->add_control(
            'btn_hover_animation',
            [
                'label' => __('Hover Animation', 'fd-addons'),
                'type'  => \Elementor\Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_active_shadow',
                'label'    => __('Button Shadow', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-btn-wrapper .fd-addons-btn',
            ]
        );

        $this->add_responsive_control(
            'button_active_radius',
            [
                'label'      => __('Border Radius', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused .fd-addons-btn-wrapper .fd-addons-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'bottom_text',
            [
                'label' => __('Bottom Info', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'bottom_typo',
                'label'    => __('typography', 'fd-addons'),
                'selector' => '{{WRAPPER}} .pricing-bottom-info',
            ]
        );

        $this->add_control(
            'bottom_info_olor',
            [
                'label'     => __('Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pricing-bottom-info' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'bottom_info_gap',
            [
                'label'      => __('Gap', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}}  .pricing-bottom-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'Box',
            [
                'label' => __('Box', 'fd-addons'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'style_tabs'
        );

        $this->start_controls_tab(
            'box_normal_tab',
            [
                'label' => __('Normal', 'fd-addons'),
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label'     => __('Box Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => __('Foucsed Box Shadow', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-item',

            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => __('box_border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-item',
            ]
        );
        $this->add_responsive_control(
            'box_radius',
            [
                'label'      => __('Box Radius', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => __('Box Padding', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'box_active_tab',
            [
                'label' => __('Active', 'fd-addons'),
            ]
        );
        $this->add_control(
            'box_active_bg_color',
            [
                'label'     => __('Box Background Color', 'fd-addons'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_active_shadow',
                'label'    => __('Foucsed Box Shadow', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-item.focused',

            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_active_border',
                'label'    => __('box_border', 'fd-addons'),
                'selector' => '{{WRAPPER}} .fd-addons-pricing-item.focused',
            ]
        );

        $this->add_responsive_control(
            'box_active_radius',
            [
                'label'      => __('Box Radius', 'fd-addons'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .fd-addons-pricing-item.focused' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    /**
     * Render oEmbed widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $popular_post_key       = array();
        $popular_meta_value_num = array();
        $settings               = $this->get_settings_for_display();
        $pricing_grid_desktop   = $settings['pricing_grid'];
        $pricing_grid_tablet    = isset($settings['pricing_grid_tablet']) ? $settings['pricing_grid_tablet'] : '';
        $pricing_grid_mobile    = isset($settings['pricing_grid_mobile']) ? $settings['pricing_grid_mobile'] : '';
        $pricing_grid           = sprintf('col-lg-%s col-md-%s col-%s', esc_attr($pricing_grid_desktop), esc_attr($pricing_grid_tablet), esc_attr($pricing_grid_mobile));
?>

        <?php if ($settings['pricing_list']) : ?>
            <div class="fd-addons-pricing-area pricing-style-classic">

                <div class="row">
                    <div class="col-12 text-center">
                        <div class="fd-addons-pricing-tabs <?php echo esc_attr($settings['switcher_style']) ?>">
                            <?php if ('style-2' == $settings['switcher_style']) : ?>
                                <div class="fd-addons-pricing-tab">
                                    <a href="javascript:" class="tabs-title first-tabs-title active" data-pricing-tab-trigger data-target="#fd-addons-dynamic-deck">
                                        <?php echo esc_html($settings['first_tab_title']); ?>
                                    </a>
                                    <a href="javascript:" class="tabs-title second-tabs-title" data-pricing-tab-trigger data-target="#fd-addons-dynamic-deck">
                                        <?php echo esc_html($settings['second_tab_title']); ?>
                                    </a>
                                </div>
                            <?php else : ?>
                                <span class="first-tabs-title"><?php echo $settings['first_tab_title'] ?></span>
                                <div class="fd-addons-price-tabs-switcher">
                                    <div id="pricing-dynamic-deck--head">
                                        <a href="javascript:" class="btn-toggle active mx-3" data-pricing-trigger data-target="#fd-addons-dynamic-deck"><span class="round"></span></a>
                                    </div>
                                </div>
                                <span class="second-tabs-title"><?php echo $settings['second_tab_title'] ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['price_offer'])) : ?>
                                <span class="fd-addons-price-offer"><?php echo $settings['price_offer'] ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row pricing-box-wrap justify-content-center" id="fd-addons-dynamic-deck" data-pricing-dynamic data-value-active="monthly">
                    <?php foreach ($settings['pricing_list'] as $pricing) : ?>
                        <div class="<?php echo esc_attr($pricing_grid); ?> fd-addons-pricing-item-wrap">
                            <div class="fd-addons-pricing-item <?php echo $pricing['focused'] ?>">
                                <!-- classic pricing -->

                                <div class="fd-addons-price-wrap">
                                    <span class="fd-addons-pricing-title"><?php echo $pricing['title'] ?></span>
                                    <?php if ($pricing['price_badge']) : ?>
                                        <span class="fd-addons-pricing-badge"><?php echo $pricing['price_badge'] ?></span>
                                    <?phP endif; ?>
                                    <div class="fd-addons-price fd-addons-price-monthly">
                                        <h2 class="dynamic-value" data-active="<?php echo $pricing['price_monthly'] ?>" data-monthly="<?php echo $pricing['price_monthly'] ?>" data-yearly="<?php echo $pricing['price_yearly'] ?>"><span class="price-currency"><?php echo esc_html($pricing['price_currency']) ?></span></h2>
                                        <span class="fd-addons-pricing-duration dynamic-value" data-active="<?php echo $pricing['price_duration_monthly'] ?>" data-monthly="<?php echo $pricing['price_duration_monthly'] ?>" data-yearly="<?php echo $pricing['price_duration_yearly'] ?>"></span>
                                    </div>
                                    <?php if ($pricing['price_subtitle_monthly'] || $pricing['price_subtitle_yearly']) : ?>
                                        <span class="price-subtitle dynamic-value" data-active="<?php echo esc_attr($pricing['price_subtitle_monthly']) ?>" data-monthly="<?php echo esc_attr($pricing['price_subtitle_monthly']) ?>" data-yearly="<?php echo esc_attr($pricing['price_subtitle_yearly']) ?>"></span>
                                    <?php endif; ?>
                                </div><!--  end of fd-addons-price-wrap  -->

                                <div class="fd-addons-pricing-head-filler"></div>

                                <div class="fd-addons-pricing-features">
                                    <?php echo $pricing['features'] ?>
                                </div>
                                <!-- minimal pricing -->
                                <?php if ('true' == $pricing['show_btn']) : ?>
                                    <div class="fd-addons-btn-wrapper">
                                        <a class="fd-addons-btn <?php printf('%s', esc_attr('elementor-animation-' . $settings['btn_hover_animation'])) ?>" href="<?php echo $pricing['button_url']['url'] ?>"><?php echo $pricing['button_label'] ?> <?php \Elementor\Icons_Manager::render_icon($pricing['btn_icon'], ['aria-hidden' => 'true']); ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ('' != $pricing['bottom_info']) {
                                    printf('<span class="pricing-bottom-info">%s</span>', $pricing['bottom_info']);
                                } ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
<?php
    }
}

$widgets_manager->register(new \Finest_Addons\Widgets\Price_Table());
