<?php 

class Gigas_Custom_Sidebars {
	
	private static $_instance = null;

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'gigas_addon_admin_menu' ) );	
		add_action( 'wp_ajax_gigas-custom-sidebar-export', array( $this, 'gigas_custom_sidebar_export' ) );
	}
	
	public static function gigas_addon_admin_menu(){
		add_submenu_page( 
			'gigas-welcome', 
			esc_html__( 'Custom Sidebars', 'gigas-addon' ),
			esc_html__( 'Custom Sidebars', 'gigas-addon' ), 
			'manage_options', 
			'gigas-sidebars', 
			array( 'Gigas_Custom_Sidebars', 'gigas_sidebar_admin_page' )
		);
	}
	
	public static function gigas_sidebar_admin_page(){
			
		$gigas_theme = wp_get_theme();
	?>
		<div class="gigas-settings-wrap">
			<div class="gigas-header-bar">
				<div class="gigas-header-left">
					<div class="gigas-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="gigas-logo">
					</div><!-- .gigas-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Gigas Custom Sidebars', 'gigas-addon' ); ?><span class="gigas-version"><?php echo esc_attr( $gigas_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<a href="<?php echo admin_url('admin.php?page=gigas-options'); ?>"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>
						<a href="<?php echo admin_url('admin.php?page=gigas-plugins')?>"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="https://docs.zozothemes.com/gigas/" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="https://zozothemes.com/forum/" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .gigas-header-left -->
				<div class="gigas-header-right">
					<a href="<?php echo esc_url( 'https://wordpress.zozothemes.com/gigas/' ); ?>" target="_blank" class="button gigas-btn"><?php esc_html_e( 'Live Demo', 'gigas-addon' ); ?></a>
				</div><!-- .gigas-header-right -->
			</div><!-- .gigas-header-bar -->
			
			<div class="gigas-settings-tabs gigas-custom-sidebar-wrap">
				<div id="gigas-general" class="gigas-settings-tab active">
					<div class="container">
						<div class="row">
							<div class="col-4">
								<div class="media admin-box">
									<div class="admin-box-icon mr-3">
										<span class="dashicons dashicons-welcome-widgets-menus"></span>								
									</div>
									<div class="media-body admin-box-info">
										<h3 class="admin-box-title"><?php esc_html_e( 'Add New Sidebar', 'gigas-addon' ); ?></h3>
										<div class="admin-box-content">
											<?php esc_html_e( 'You can add new custom sidebar here. Also we give you option to remove or delete custom sidebars.', 'gigas-addon' ); ?>
										</div>
										<?php
											$sidebars = '';
											$sidebar_opt_name = 'gigas_custom_sidebars';
											$sidebars = get_option( $sidebar_opt_name );
											
											if ( isset( $_POST['gigas_custom_sidebar_nonce'] ) && wp_verify_nonce( $_POST['gigas_custom_sidebar_nonce'], 'gigas-()@)(*^#@!' ) 
											) {
												if (isset($_POST['gigas_sidebar_name']) && !empty($_POST['gigas_sidebar_name'])) {
													$sidebar_name = sanitize_text_field($_POST['gigas_sidebar_name']); // Sanitize
													$sidebar_slug = sanitize_title($sidebar_name);

													if (!empty($sidebars)) {
														$sidebars[$sidebar_slug] = $sidebar_name;
													}else{
														$sidebars = array( $sidebar_slug => $sidebar_name );
													}	
													update_option( 'gigas_custom_sidebars', $sidebars );
												}
											}
											
											if ( isset( $_POST['gigas_custom_sidebar_remove_nonce'] ) && wp_verify_nonce( $_POST['gigas_custom_sidebar_remove_nonce'], 'gigas-()I*^*^%@!' ) 
											) {
												$remove_sidebar = isset($_POST['gigas_sidebar_remove_name']) && !empty($_POST['gigas_sidebar_remove_name']) ? sanitize_text_field($_POST['gigas_sidebar_remove_name']) : ''; // Sanitize
												unset($sidebars[$remove_sidebar]);
												update_option('gigas_custom_sidebars', $sidebars);
												$sidebars = get_option($sidebar_opt_name);
											}
											
										?>
										<form action="" method="post" enctype="multipart/form-data">
											<?php wp_nonce_field( 'gigas-()@)(*^#@!', 'gigas_custom_sidebar_nonce' ); ?>
											<input type="input" name="gigas_sidebar_name" class="custom-sidebar-name" value="" />
										</form>
										<a href="#" class="gigas-btn btn-default custom-sidebar-create"><?php esc_html_e( 'Add Sidebar', 'gigas-addon' ); ?></a>
 										<a href="widgets.php" class="gigas-btn btn-default custom-view-sidebar"><?php esc_html_e( 'View Sidebar', 'gigas-addon' ); ?></a>
									</div>
								</div>
							</div>
							<div class="col-8">
								<div class="admin-box">
									<h3 class="admin-box-title sidebar-title"><?php esc_html_e( 'Custom Sidebars', 'gigas-addon' ); ?></h3>
									<?php if( !empty( $sidebars ) ): ?>
									<form action="" method="post" enctype="multipart/form-data">
									<?php wp_nonce_field( 'gigas-()I*^*^%@!', 'gigas_custom_sidebar_remove_nonce' ); ?>
									<input type="hidden" name="gigas_sidebar_remove_name" id="gigas-sidebar-remove-name" value="" />									
									<table class="gigas-admin-table gigas-custom-sidebar-table">
										<thead>
											<tr>
												<td><?php esc_html_e( 'Name', 'gigas-addon' ); ?></td>
												<td><?php esc_html_e( 'Slug', 'gigas-addon' ); ?></td>
												<td><?php esc_html_e( 'Delete', 'gigas-addon' ); ?></td>
											</tr>
										</thead>
										<tbody>
										<?php
											foreach( $sidebars as $sidebar_slug => $sidebar_name ){
											?>
												<tr>
													<td><?php echo esc_html( $sidebar_name ); ?></td>
													<td><?php echo esc_html( $sidebar_slug ); ?></td>
													<td class="text-center"><a href="#" data-sidebar="<?php echo esc_attr( $sidebar_slug ); ?>" class="gigas-sidebar-remove"><span class="dashicons dashicons-trash"></span></a></td>
												</tr>
											<?php
											}
										?>
										</tbody>
									</table>
									</form>
									<a href="#" class="gigas-btn btn-default custom-sidebar-export"><?php esc_html_e( 'Export as JSON', 'gigas-addon' ); ?></a>
									<?php else: ?>
										<p><?php esc_html_e( 'Sorry! No custom sidebars available.', 'gigas-addon' ); ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
	<?php
	}
		
	public static function rmdir_recurse($path) {
		$path = rtrim($path, '/').'/';
		$handle = opendir($path);
		while(false !== ($file = readdir($handle))) {
			if($file != '.' and $file != '..' ) {
				$fullpath = $path.$file;
				if(is_dir($fullpath)) self::rmdir_recurse($fullpath); else unlink($fullpath);
			}
		}
		closedir($handle);
		rmdir($path);
	}	
	
	public static function gigas_custom_sidebar_export(){
		$nonce = $_POST['nonce'];  
		if ( ! wp_verify_nonce( $nonce, 'gigas-()@)(*^#@!' ) )
			wp_die ( esc_html__( 'Not Ok', 'gigas-addon' ) );
		
		$sidebars = get_option( 'gigas_custom_sidebars' );
		if( !empty( $sidebars ) ){
			//wp_send_json( $sidebars );
			echo json_encode( $sidebars );
		}else{
			echo '';
		}	
		wp_die();
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Gigas_Custom_Sidebars::get_instance();