<?php 
class Gigas_Demo_Importer {
	
	private static $_instance = null;
	
	public static $ins_demo_stat;
	
	public static $ins_demo_id;
	public function __construct() {
		
		$this->set_installed_demo_details();
		
		add_action( 'admin_menu', array( $this, 'gigas_addon_admin_menu' ) );
		
		add_action( 'admin_enqueue_scripts', array( $this, 'gigas_enqueue_admin_script' ) );
		
	}
	
	public static function gigas_addon_admin_menu(){
		add_submenu_page( 
			'gigas-welcome', 
			esc_html__( 'Demo Importer', 'gigas-addon' ),
			esc_html__( 'Demo Importer', 'gigas-addon' ), 
			'manage_options', 
			'gigas-importer', 
			array( 'Gigas_Demo_Importer', 'gigas_demo_import_admin_page' )
		);
	}
	
	private function set_installed_demo_details(){
		self::$ins_demo_stat = get_theme_mod( 'gigas_demo_installed' );
		self::$ins_demo_id = get_theme_mod( 'gigas_installed_demo_id' );
	}
	
	public function gigas_enqueue_admin_script(){
		
		if( isset( $_GET['page'] ) && $_GET['page'] == 'gigas-importer' ){
		
			wp_enqueue_style( 'gigas-confirm', GIGAS_ADDON_URL . 'admin/extension/demo-importer/assets/css/jquery-confirm.min.css' );
			wp_enqueue_script( 'gigas-confirm', GIGAS_ADDON_URL . 'admin/extension/demo-importer/assets/js/jquery-confirm.min.js', array( 'jquery' ), '1.0', true ); 
			
			wp_enqueue_script( 'gigas-import-scripts', GIGAS_ADDON_URL . 'admin/extension/demo-importer/assets/js/demo-import.js', array( 'jquery' ), '1.7.5', true ); 
			wp_enqueue_style( 'bootstrap-icons', GIGAS_URI . '/assets/css/bootstrap-icons.css', array(), '1.9.1', 'all' );
			
			//Import Localize Script
			$demo_import_args = array(
				'admin_ajax_url' => esc_url( admin_url('admin-ajax.php') ),
				'nonce' => wp_create_nonce('gigas-options-import'),		
				'proceed' => esc_html__('Proceed', 'gigas'),
				'cancel' => esc_html__('Cancel', 'gigas'),
				'process' => esc_html__( 'Processing', 'gigas-addon' ),
				'uninstalling' => esc_html__('Uninstalling...', 'gigas'),
				'uninstalled' => esc_html__('Uninstalled.', 'gigas'),
				'unins_pbm' => esc_html__('Uninstall Problem!.', 'gigas'),
				'downloading' => esc_html__('Demo import process running...', 'gigas'), 
				'gigas_import_url' => admin_url( 'admin.php?page=gigas-importer' ),
				'regenerate_thumbnails_url' => admin_url( 'plugin-install.php?tab=plugin-information&plugin=regenerate-thumbnails' )				
			);
			$demo_import_args = apply_filters( 'gigas_demo_import_args', $demo_import_args );
			wp_localize_script( 'gigas-import-scripts', 'gigas_admin_ajax_var', $demo_import_args );
		}
		
	}
	
	public static function gigas_demo_div_generater( $demo_array ){
		
		$ins_demo_stat = self::$ins_demo_stat;
		$ins_demo_id = self::$ins_demo_id;
		
		$demo_class = '';
		if( $ins_demo_stat == 1 ){
			if( $ins_demo_id == $demo_array['demo_id'] ){
				$demo_class .= ' demo-actived';
			}else{
				$demo_class .= ' demo-inactive';
			}
		}else{
			$demo_class .= ' demo-active';
		}
	
		$revslider = isset( $demo_array['revslider'] ) && $demo_array['revslider'] != '' ? $demo_array['revslider'] : '';
		$media_parts = isset( $demo_array['media_parts'] ) && $demo_array['media_parts'] != '' ? $demo_array['media_parts'] : '';
		
		?>
		
		
		<div class="admin-box demo-wrap">
			<div class="install-plugin-wrap theme zozothemes-demo-item<?php echo esc_attr( $demo_class ); ?>">
				<div class="install-plugin-inner">
				
					<div class="zozo-demo-import-loader zozo-preview-<?php echo esc_attr( $demo_array['demo_id'] ); ?>"><i class="dashicons dashicons-admin-generic"></i></div>
					
					<div class="installation-progress">
						<span class="progress-text"></span>
						<div class="progress">
							<div class="progress-bar" style="width:0%"></div>
						</div>
					</div>
				
					<div class="theme-screenshot zozotheme-screenshot">
						<a href="<?php echo esc_url( $demo_array['demo_url'] ); ?>" target="_blank"><img src="<?php echo esc_url( GIGAS_ADDON_URL . 'admin/extension/demo-importer/assets/images/demo/' . $demo_array['demo_img'] ); ?>" class="demo-img" /></a>
					</div>
					<div class="install-plugin-right">
						<div class="install-plugin-right-inner">
							<h3 class="theme-name" id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>"><?php echo esc_attr( $demo_array['demo_name'] ); ?></h3>
							
							<a href="#" class="theme-demo-install-custom"><?php esc_html_e( "Custom Choice", "gigas" ); ?></a>
							
							<div class="theme-demo-install-parts" id="<?php echo esc_attr( 'demo-install-parts-'. $demo_array['demo_id'] ); ?>">
							
								<div class="demo-install-instructions">
									<ul class="install-instructions">
										<li><strong><?php esc_html_e( "General", "gigas" ); ?></strong></li>
										<li><?php esc_html_e( 'Choose "Media" -> All the media\'s are ready to be import.', "gigas" ); ?></li>
										<li><?php esc_html_e( 'Choose "Theme Options" -> Theme options are ready to be import.', "gigas" ); ?></li>
										<li><?php esc_html_e( 'Choose "Widgets" -> Custom sidebars and widgets are ready to be import.', "gigas" ); ?></li>
										<?php if( $revslider ) : ?>
										<li><?php esc_html_e( 'Choose "Revolution Sliders" -> Revolution slides are ready to be import.', "gigas" ); ?></li>
										<?php endif; ?>
										<li><?php esc_html_e( 'Choose "All Posts" -> Posts, menus, custom post types are ready to be import.', "gigas" ); ?></li>
										<li><p class="lead"><strong>*</strong><?php esc_html_e( 'If you check "All Posts" and Uncheck any of page, then menu will not imported.', "gigas" ); ?></p></li>
										
										<li><strong><?php esc_html_e( "Pages", "gigas" ); ?></strong></li>
										<li><?php esc_html_e( 'Choose pages which you want to show on your site. If you choose all the pages and check "All Post" menu will be import. If any one will not check even page or All posts, then menu will not import.', "gigas" ); ?></li>
									</ul>
								</div>
							
								<div class="zozo-col-3">
									<h5><?php esc_html_e( "General", "gigas" ); ?></h5>
									<?php
									if( isset( $demo_array['general'] )	 ){
										echo '<ul class="general-install-parts-list">';
										foreach( $demo_array['general'] as $key => $value ){
											echo '<li><input type="checkbox" value="'. esc_attr( $key ) .'" data-text="'. esc_attr( $value ) .'" /> '. esc_html( $value ) .'</li>';
										}
										echo '</ul>';
									}						
									?>
								</div><!-- .zozo-col-3 -->
								<div class="zozo-col-3">
									<h5><?php esc_html_e( "Pages", "gigas" ); ?></h5>
									<?php
									if( isset( $demo_array['pages'] )	 ){
										echo '<ul class="page-install-parts-list">';
										foreach( $demo_array['pages'] as $key => $value ){
											echo '<li><input type="checkbox" value="'. esc_attr( $key ) .'" data-text="'. esc_attr( $value ) .'" /> '. esc_html( $value ) .'</li>';
										}
										echo '</ul>';
									}						
									?>
								</div><!-- .zozo-col-3 -->
								<a href="#" class="theme-demo-install-checkall"><?php esc_html_e( "Check/Uncheck All", "gigas" ); ?></a>
								<p><?php esc_html_e( "Leave empty/uncheck all to full install.", "gigas" ); ?></p>
							</div><!-- .theme-demo-install-parts -->
							<div class="theme-actions theme-buttons">
								<a class="button button-primary button-install-demo" data-demo-id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>" data-revslider="<?php echo esc_attr( $revslider ); ?>" data-media="<?php echo esc_attr( $media_parts ); ?>" href="#">
								<?php esc_html_e( "Import", "gigas" ); ?>
								</a>
								<a class="button button-primary button-uninstall-demo" data-demo-id="<?php echo esc_attr( $demo_array['demo_id'] ); ?>" href="#">
								<?php esc_html_e( "Uninstall", "gigas" ); ?>
								</a>
								<a class="button button-primary button-preview-demo" target="_blank" href="<?php echo esc_url( $demo_array['demo_url'] ); ?>">
								<?php esc_html_e( "Preview", "gigas" ); ?>
								</a>
							</div>
							
						</div><!-- .install-plugin-right-inner -->
					</div><!-- .install-plugin-right -->
				</div>
			</div><!-- .admin-box -->
		<?php
	}
	
	public static function gigas_demo_import_admin_page(){
		$gigas_theme = wp_get_theme();
	?>
		<div class="gigas-settings-wrap">
		
			<?php wp_nonce_field( 'gigas_demo_import_*&^^$#(*', 'gigas_demo_import_nonce' ); ?>
		
			<div class="gigas-header-bar">
				<div class="gigas-header-left">
					<div class="gigas-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="gigas-logo">
					</div><!-- .gigas-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Gigas Demo Importer', 'gigas-addon' ); ?></h2>
					<div class="nav-theme-options">
						<a href="<?php echo admin_url('admin.php?page=gigas-options'); ?>"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>
						<a href="<?php echo admin_url('admin.php?page=gigas-plugins')?>"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="https://docs.zozothemes.com/gigas/" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="https://zozothemes.com/forum/" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .gigas-header-left -->
				<div class="gigas-header-right">
					<a href="<?php echo esc_url( 'https://wordpress.zozothemes.com/gigas/' ); ?>" target="_blank" class="button gigas-btn"><?php esc_html_e( 'Live Demo', 'gigas-addon' ); ?></a>
				</div><!-- .gigas-header-right -->
			</div><!-- .gigas-header-bar -->
			
			<div class="gigas-settings-tabs gigas-demo-import-wrap">
				<div id="gigas-general" class="gigas-settings-tab active">
					<div class="container">
						<div class="row">
							<div class="col-6">							
							<?php
								
								//Demo Classic
								$demo_array = array(
									'demo_id' 	=> 'demo',
									'demo_name' => esc_html__( 'Gigas Main Demo', 'gigas-addon' ),
									'demo_img'	=> 'demo-1.jpg',
									'demo_url'	=> 'https://wordpress.zozothemes.com/gigas/',
									'revslider'	=> '6',
									'media_parts'	=> '43',
									'general'	=> array(
										'media' 		=> esc_html__( "Media", "gigas" ),
										'theme-options' => esc_html__( "Theme Options", "gigas" ),
										'widgets' 		=> esc_html__( "Widgets", "gigas" ),
										'revslider' 	=> esc_html__( "Revolution Sliders", "gigas" ),
										'post' 			=> esc_html__( "All Posts", "gigas" )
									),
									'pages'=> array(
										'1'		=> esc_html__( "Contact Us", "gigas" ),
										'2'	=> esc_html__( "Our Services", "gigas" ),						
										'3'	=> esc_html__( "About  Us", "gigas" ),
										'4'	=> esc_html__( "Pricing", "gigas" ),
										'5'	=> esc_html__( "Frequently asked question", "gigas" ),
										'6'	=> esc_html__( "Our Team", "gigas" ),
										'7'	=> esc_html__( "Blog", "gigas" ),
										'8'	=> esc_html__( "Blog Grid 3 Columns", "gigas" ),
										'9'	=> esc_html__( "Blog List", "gigas" ),
										'10'	=> esc_html__( "Shop", "gigas" ),
										'11' 	=> esc_html__( "Cart", "gigas" ),
										'12'		=> esc_html__( "My account", "gigas" ),
										'13' 	=> esc_html__( "Portfolio", "gigas" ),
										'14' 	=> esc_html__( "Career", "gigas" ),
										'15'		=> esc_html__( "Portfolio No Gutter", "gigas" ),
										'16' 	=> esc_html__( "Coming Soon", "gigas" ),
										'17'		=> esc_html__( "Home 3", "gigas" ),
										'18' 	=> esc_html__( "Who We Are", "gigas" ),
										'19' 	=> esc_html__( "Refund and Returns Policy", "gigas" ),
										'20'	=> esc_html__( "Portfolio 2 Columns", "gigas" ),						
										'21'	=> esc_html__( "Portfolio 3 Columns", "gigas" ),
										'22'	=> esc_html__( "Portfolio 4 Columns Wide", "gigas" ),
										'23'	=> esc_html__( "Portfolio Masonry Classic", "gigas" ),
										'24'	=> esc_html__( "Portfolio Masonry Classic Pro", "gigas" )	,
										'25'	=> esc_html__( "Privacy Policy", "gigas" )	,
										'26'	=> esc_html__( "Service Style 3", "gigas" )	,
										'27'	=> esc_html__( "Home 4", "gigas" )	,
										'28'	=> esc_html__( "Home 2", "gigas" )	,
										'29'	=> esc_html__( "Home", "gigas" )	,
										'30'	=> esc_html__( "Testimonials", "gigas" )	,
										'31'	=> esc_html__( "Blog Grid 2 Columns Sidebar", "gigas" )	,
										'32'	=> esc_html__( "Blog Grid 2 Columns", "gigas" ) ,
										'33'	=> esc_html__( "Blog Grid 4 Columns", "gigas" )	,
										'34'	=> esc_html__( "Blog Grid Overlay", "gigas" )	,
										'35'	=> esc_html__( "Portfolio Masonry", "gigas" )	,
										'36'	=> esc_html__( "Service Style 2", "gigas" )	,
										'37'	=> esc_html__( "Blogs", "gigas" )	,
										'38'	=> esc_html__( "Charts", "gigas" )	,
										'39'	=> esc_html__( "Circle Progress", "gigas" )	,
										'40'	=> esc_html__( "Progress Bar", "gigas" )	,
										'41'	=> esc_html__( "Counters", "gigas" )	,
										'42'	=> esc_html__( "Day Counter", "gigas" )	,
										'43'	=> esc_html__( "Feature Box", "gigas" )	,
										'44'	=> esc_html__( "Tabs", "gigas" )	,
										'45'	=> esc_html__( "Mailchimp", "gigas" )	,
										'46'	=> esc_html__( "Modal Popup", "gigas" )	,
										'47'	=> esc_html__( "Flipbox", "gigas" )	,
										'48'	=> esc_html__( "Pricing Table", "gigas" )	,
										'49'	=> esc_html__( "Contact Forms", "gigas" )	,
										'50'	=> esc_html__( "Testimonials Styles", "gigas" )	,
										'51'	=> esc_html__( "Teams", "gigas" )	,
										'52'	=> esc_html__( "Portfolios", "gigas" )	,
										'53'	=> esc_html__( "Service Styles", "gigas" )	,
										'54'	=> esc_html__( "Google Maps", "gigas" )	,
										'55'	=> esc_html__( "Video Popup", "gigas" )	,
										'56'	=> esc_html__( "Popover", "gigas" )	,
										'57'	=> esc_html__( "Timeline", "gigas" ), 									
										'58'	=> esc_html__( "Cart", "gigas" ),																																							
										'59'	=> esc_html__( "Checkout", "gigas" ),
										'60'	=> esc_html__( "Home", "gigas" ),																		
									)
									
								);
								self::gigas_demo_div_generater( $demo_array );								
							?>
							
								<div class="theme-requirements" data-requirements="<?php 
									printf( '<h2>%1$s</h2> <p>%2$s</p> <h3>%3$s</h3> <ol><li>%4$s</li></ol>', 
										esc_html__( 'WARNING:', 'gigas-addon' ), 
										esc_html__( 'Importing demo content will give you pages, posts, theme options, sidebars and other settings. This will replicate the live demo. Clicking this option will replace your current theme options and widgets. It can also take a minutes to complete.', 'gigas-addon' ),
										esc_html__( 'DEMO REQUIREMENTS:', 'gigas-addon' ),
										esc_html__( 'Memory Limit of 128 MB and max execution time (php time limit) of 300 seconds.', 'gigas-addon' )
									);
								?>">
								</div>							
								
							</div>
						</div>
					</div>
				</div>
			</div>
			
		</div>
	<?php
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
} Gigas_Demo_Importer::get_instance();

/* Demo Import AJAX */
if( ! function_exists('gigas_demo_import_fun') ) {
    function gigas_demo_import_fun() {
		
		if( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( $_POST['nonce'], 'gigas_demo_import_*&^^$#(*' ) ) {
			echo "!security issue";
			wp_die(); 
		}
		
		$process = isset( $_POST['process'] ) ? sanitize_text_field($_POST['process']) : '';
		
		if( $process ){
			
			include GIGAS_ADDON_DIR . 'admin/extension/demo-importer/zozo-importer.php';
			
			if( $process == 'permission' ){
				gigasZozoImporterModule::gigas_check_file_access_permission();
			}elseif( $process == 'general_download' ){
				gigasZozoImporterModule::gigas_general_file_ajax();
			}elseif( $process == 'xml_download' ){
				gigasZozoImporterModule::gigas_xml_file_ajax();
			}elseif( $process == 'general_install' ){
				gigasZozoImporterModule::gigas_general_file_install_ajax();
			}elseif( $process == 'xml_install' ){
				gigasZozoImporterModule::gigas_xml_file_install_ajax();
			}elseif( $process == 'final' ){
				gigasZozoImporterModule::gigas_import_set_default_settings();
			}elseif( $process == 'uninstall' ){
				gigasZozoImporterModule::gigas_uninstall_demo();
			}
			
		}
		
		wp_die();
		
    }
    add_action('wp_ajax_gigas_demo_import', 'gigas_demo_import_fun');
}