<?php

Gigas_Options::$gigas_options = get_post_meta( get_the_ID(), 'gigas_post_meta', true );

// General
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'General', 'gigas-addon' ),
	'id'         => 'general-tab',
	'config_id'  => '',
) );

Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Site General', 'gigas-addon' ),
	'id'         => 'site-general',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'general-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Site General Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit site general settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'site-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Site Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose site layout either wide or boxed.', 'gigas-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-boxed.png'
				),
				'wider' => array(
					'title' => esc_html__( 'Wider', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wider.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'general-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'content-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Content Padding', 'gigas-addon' ),
			'description'	=> esc_html__( 'Assign content padding. If need no padding means just leave this empty. Example 10 10 10 10', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'general-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-slider',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Header Slider', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enter shortcode for header slider.', 'gigas-addon' ),
			'default'		=> '',
		)		
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Logo Settings', 'gigas-addon' ),
	'id'         => 'site-logo',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'logo-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Site General Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit site logo settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'logo-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Logo Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is settings for site logo.', 'gigas-addon' ),
			'seperator'		=> 'after',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Default Logo', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose site logo image.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Site Logo Maximum Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is maximum width of logo. if you want original width leave this field empty.', 'gigas-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'site-logo-desc',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable Site Logo Description', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is logo description options for this site. You can enable or disable.', 'gigas-addon' ),
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'sticky-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Sticky Logo', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose site sticky logo image.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'sticky-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Sticky Logo Maximum Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is maximum width of sticky logo. if you want original width leave this field empty.', 'gigas-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'mobile-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Mobile Logo', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose site mobile logo image.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'mobile-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Mobile Logo Maximum Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is maximum width of mobile logo. if you want original width leave this field empty.', 'gigas-addon' ),
			'only_dimension' => 'width',
			'required'		=> array( 'logo-chk', '=', array( 'custom' ) )
		),
	)
) );

Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'general-tab-end'	
));

$gigas_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
$gigas_nav_menus = array( "none" => esc_html__( "None", "gigas-addon" ) );
foreach( $gigas_menus as $menu ){
	$gigas_nav_menus[$menu->slug] = $menu->name;
}

// Header
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Header', 'gigas-addon' ),
	'id'         => 'header-tab',
	'config_id'  => '',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'General', 'gigas-addon' ),
	'id'         => 'header-general',
	'fields'	 => array(
		array(
			'id'			=> 'header-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-one-page-menu',
			'type'			=> 'select',
			'title'			=> esc_html__( 'One Page Menu', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header settings options.', 'gigas-addon' ),
			'choices'		=> $gigas_nav_menus,
			'default'		=> 'none'
		),
		array(
			'id'			=> 'header-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Header Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose header layout either wide or boxed.', 'gigas-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wide.png'
				),
				'wider' => array(
					'title' => esc_html__( 'Wider', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wider.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Header Bars', 'gigas-addon' ),
			'description'	=> esc_html__( 'These are header items. Drag which items you want to display normal and sticky.', 'gigas-addon' ),
			'default'		=> array(
				'normal' => array(
					'topbar' => esc_html__( 'Topbar', 'gigas-addon' ),
					'logobar' => esc_html__( 'Logo bar', 'gigas-addon' )
				),
				'sticky' => array(
					'navbar' => esc_html__( 'Navbar', 'gigas-addon' )
				),
				'disabled' => array(
				)
			),
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-absolute',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Header Absolute', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enable/Disable header absolute. Like floating on slider', 'gigas-addon' ),
			'default'		=> false,
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'search-type',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Search Toggle Modal', 'gigas-addon' ),
			'description'	=> esc_html__( 'Slect search box type', 'gigas-addon' ),
			'choices'		=> array(
				'1'	=> esc_html__( 'Full Screen Search', 'gigas-addon' ),
				'2' => esc_html__( 'Text Box Toggle Search', 'gigas-addon' ),
				'3' => esc_html__( 'Full Bar Toggle Search', 'gigas-addon' ),
				'4' => esc_html__( 'Bottom Seach Box Toggle', 'gigas-addon' )
			),
			'default'		=> '1',
			'required'		=> array( 'header-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Styles', 'gigas-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Style Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header style settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background setting for header', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Header Border', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is border setting for header', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header padding', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Header margin', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-style-chk', '=', array( 'custom' ) )
		)
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Topbar', 'gigas-addon' ),
	'id'         => 'header-topbar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-topbar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Topbar Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header topbar settings.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'topbar-custom-text-1',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Topbar Custom Text 1', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is topbar custom text field. Here you can place shortcodes too', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'topbar-custom-text-2',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Topbar Custom Text 2', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is topbar custom text field. Here you can place shortcodes too', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'topbar-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Topbar Items', 'gigas-addon' ),
			'description'	=> esc_html__( 'These all are topbar items. You can make your own layout by drag and drop', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'gigas-addon' )
				),
				'center' => array(					
				),
				'right' => array(
					'social' => esc_html__( 'Social', 'gigas-addon' )
				),
				'disabled' => array(
					'address' => esc_html__( 'Address', 'gigas-addon' ),
					'email' => esc_html__( 'Email', 'gigas-addon' ),
					'search' => esc_html__( 'Search', 'gigas-addon' ),
					'top-menu' => esc_html__( 'Top Menu', 'gigas-addon' ),
					'custom-text-2' => esc_html__( 'Custom Text 2', 'gigas-addon' )
				)
			),
			'required'		=> array( 'header-topbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Topbar Styles', 'gigas-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header topbar styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-topbar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Topbar Style Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header topbar style settings.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-topbar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Topbar Height', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is height property of header topbar.', 'gigas-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Topbar Sticky Height', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky topbar.', 'gigas-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-topbar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Topbar Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header topbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Topbar Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background setting for header topbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Topbar Border', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is border setting for header topbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Topbar padding', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header topbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Topbar margin', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header topbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-topbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Topbar Sticky Styles', 'gigas-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header topbar sticky styles.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Topbar Sticky Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header topbar on sticky', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-topbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Topbar Sticky Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background setting for header topbar on sticky', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-topbar-style-chk', '=', array( 'custom' ) )
		),	
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Logo bar', 'gigas-addon' ),
	'id'         => 'header-logobar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-logobar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Logo bar Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header logo bar settings.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'logobar-custom-text-1',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Logobar Custom Text1', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is logo custom text field. Here you can place shortcodes too', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'logobar-custom-text-2',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Logobar Custom Text2', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is logo custom text field. Here you can place shortcodes too', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'logobar-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Logo bar Items', 'gigas-addon' ),
			'description'	=> esc_html__( 'These all are logobar items. You can make your own layout by drag and drop', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'logo' => esc_html__( 'Logo', 'gigas-addon' )
				),
				'right' => array(					
				),
				'disabled' => array(
					'social' => esc_html__( 'Social', 'gigas-addon' ),
					'address' => esc_html__( 'Address', 'gigas-addon' ),
					'email' => esc_html__( 'Email', 'gigas-addon' ),
					'search' => esc_html__( 'Search', 'gigas-addon' ),
					'primary-menu' => esc_html__( 'Primary Menu', 'gigas-addon' ),
					'secondary-bar' => esc_html__( 'Secondary Bar', 'gigas-addon' ),
					'signin' => esc_html__( 'Signin/Register', 'gigas-addon' ),
					'custom-text-2' => esc_html__( 'Custom Text 2', 'gigas-addon' ),
					'custom-text-1' => esc_html__( 'Custom Text 1', 'gigas-addon' ),
				)
			),
			'required'		=> array( 'header-logobar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Logo bar Styles', 'gigas-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header logobar styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-logobar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Logo bar Style Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header logo bar style settings.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-logobar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Logo bar Height', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is height property of header logobar.', 'gigas-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Logo bar Sticky Height', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky logobar.', 'gigas-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-logobar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Logo bar Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header logobar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background setting for header logobar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Logo bar Border', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is border setting for header logobar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Logo bar padding', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header logobar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Logo bar margin', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header logobar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-logobar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Logobar Sticky Styles', 'gigas-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header logobar sticky styles.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Logobar Sticky Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header logobar on sticky', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-logobar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Logobar Sticky Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background setting for header logobar on sticky', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-logobar-style-chk', '=', array( 'custom' ) )
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Navbar', 'gigas-addon' ),
	'id'         => 'header-navbar',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'header-navbar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Header Navbar Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header navbar settings.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'navbar-custom-text-1',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Navbar Custom Text 1', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is nav custom text field. Here you can place shortcodes too', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'navbar-custom-text-2',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Navbar Custom Text 2', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is nav custom text field. Here you can place shortcodes too', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'navbar-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Nav bar Items', 'gigas-addon' ),
			'description'	=> esc_html__( 'These all are navbar items. You can make your own layout by drag and drop', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(	
					'logo' => esc_html__( 'Logo', 'gigas-addon' ),
					'primary-menu' => esc_html__( 'Primary Menu', 'gigas-addon' )
				),
				'center' => array(					
				),
				'right' => array(	
					'search' => esc_html__( 'Search', 'gigas-addon' ),
				),
				'disabled' => array(
					'social' => esc_html__( 'Social', 'gigas-addon' ),
					'address' => esc_html__( 'Address', 'gigas-addon' ),
					'email' => esc_html__( 'Email', 'gigas-addon' ),
					'secondary-bar' => esc_html__( 'Secondary Bar', 'gigas-addon' ),
					'signin' => esc_html__( 'Signin/Register', 'gigas-addon' ),
					'custom-text-2' => esc_html__( 'Custom Text 2', 'gigas-addon' ),
					'custom-text-1' => esc_html__( 'Custom Text 1', 'gigas-addon' ),
				)
			),
			'required'		=> array( 'header-navbar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Navbar Styles', 'gigas-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header navbar styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-navbar-style-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Navbar Style Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit header logo bar style settings.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'header-navbar-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Navbar Height', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is height property of header navbar.', 'gigas-addon' ),
			'only_dimension' => 'height',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-height',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Navbar Sticky Height', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is height property of header sticky navbar.', 'gigas-addon' ),
			'only_dimension' => 'height'
		),
		array(
			'id'			=> 'header-navbar-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Navbar Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header navbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background setting for header navbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-border',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Navbar Border', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is border setting for header navbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Navbar padding', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is padding setting for header navbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-margin',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Navbar margin', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is margin setting for header navbar', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),	
		array(
			'id'			=> 'header-navbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Navbar Sticky Styles', 'gigas-addon' ),
			'description'	=> esc_html__( 'Here you can set all the type of header navbar sticky styles.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Navbar Sticky Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link color setting for header navbar on sticky', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'header-navbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Navbar Sticky Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background setting for header navbar on sticky', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'header-navbar-style-chk', '=', array( 'custom' ) )
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'header-tab-end'	
));

//Layout Settings
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Layout', 'gigas-addon' ),
	'id'         => 'post-layout',
	'config_id'  => '',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Page Title', 'gigas-addon' ),
	'id'         => 'page-title-options',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'page-title-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit page title options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'page-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enable or disable blog page title section', 'gigas-addon' ),
			'default'		=> true,
			'required'		=> array( 'page-title-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'page-title-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Blog Page Title Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'These are blog page title elements. Drag which items you want to display left, center and right part.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'gigas-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'gigas-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'gigas-addon' )
				)
			),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Page Title Background', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background settings of page title.', 'gigas-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-overlaycolor',
			'type'			=> 'color',
			'alpha'			=> true,
			'title'			=> esc_html__( 'Page Title Overlay Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'This color will be displayed as in Page title overlaycolor. Choose light colors to make it displayed over the image.', 'gigas-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'page-title-custom-class',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Page Title Custom Class', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is setting for add custom class name to page title wrapper.', 'gigas-addon' ),
			'required'		=> array( 'page-title', '=', array( 'true' ) )
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Sidebar Layout', 'gigas-addon' ),
	'id'         => 'sidebar-layout-options',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'sidebar-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Sidebar', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit sidebar layout options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Sidebar Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose sidebar layout.', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar',
			'required'		=> array( 'sidebar-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Right Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose widget for right widget area', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Left Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose widget for left widget area', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'post-layout-end'	
));

// Footer
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Footer', 'gigas-addon' ),
	'id'         => 'footer-tab',
	'config_id'  => '',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'General', 'gigas-addon' ),
	'id'         => 'footer-general',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose footer layout either wide or boxed.', 'gigas-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'footer-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Footer Items', 'gigas-addon' ),
			'description'	=> esc_html__( 'These are footer items. Drag which items you want to display Enabled and Disabled.', 'gigas-addon' ),
			'default'		=> array(
				'enabled' => array(
					'footer-middle' => esc_html__( 'Footer Widgets', 'gigas-addon' ),
					'footer-bottom' => esc_html__( 'Copyright Section', 'gigas-addon' )
				),
				'disabled' => array(
					'footer-top' => esc_html__( 'Footer Top', 'gigas-addon' ),
				)
			),
			'required'		=> array( 'footer-chk', '=', array( 'custom' ) )
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Footer Top', 'gigas-addon' ),
	'id'         => 'footer-insta',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'insta-footer-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Top Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit insta footer settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'insta-footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Top Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose insta footer layout either wide or boxed.', 'gigas-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'wide',
			'required'		=> array( 'insta-footer-chk', '=', array( 'custom' ) )
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Footer Widgets', 'gigas-addon' ),
	'id'         => 'footer-widgets',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-middle-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Widgets Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer middle settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'widgets-footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Widgets Footer Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose widgets footer layout either wide or boxed.', 'gigas-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'boxed',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widgets-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Widgets Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose footer widgets layout.', 'gigas-addon' ),
			'items'		=> array(
				'3-3-3-3' => array(
					'title' => esc_html__( 'Column 3/3/3/3', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-3-3.png'
				),
				'3-3-6' => array(
					'title' => esc_html__( 'Column 3/3/6', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-6.png'
				),
				'12' => array(
					'title' => esc_html__( 'Column 12', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-12.png'
				),
				'4-4-4' => array(
					'title' => esc_html__( 'Column 4/4/4', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-4-4.png'
				),
				'4-8' => array(
					'title' => esc_html__( 'Column4/8', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-8.png'
				),
				'6-3-3' => array(
					'title' => esc_html__( 'Column 6/3/3', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-6-3-3.png'
				),
				'8-4' => array(
					'title' => esc_html__( 'Column 8/4', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-8-4.png'
				)
			),
			'default' => '12',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widget-1',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 1', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 1', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-middle-chk', '=', array( 'custom' ) )
		),
		array(
			'id'			=> 'footer-widget-2',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 2', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 2', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '!=', array( '12' ) )
		),
		array(
			'id'			=> 'footer-widget-3',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 3', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 3', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3', '3-3-6', '4-4-4', '6-3-3' ) )
		),
		array(
			'id'			=> 'footer-widget-4',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Footer Widgets Area 4', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose widget for footer widget area 4', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3' ) )
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Copyright Section', 'gigas-addon' ),
	'id'         => 'copyright-section',
	'config_id'  => '',
	'fields'	 => array(
		array(
			'id'			=> 'footer-bottom-chk',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Footer Widgets Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose custom to edit footer middle settings options.', 'gigas-addon' ),
			'choices'		=> array(
				'default'	=> esc_html__( 'Default', 'gigas-addon' ),
				'custom'	=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'		=> 'default'
		),
		array(
			'id'			=> 'footer-bottom-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Bottom Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose footer bottom layout either wide or boxed.', 'gigas-addon' ),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'boxed',
			'required'		=> array( 'footer-bottom-chk', '=', array( 'custom' ) )
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'footer-end'	
));


/*
//All Fields
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'All Fields', 'gigas-addon' ),
	'id'         => 'all-fields'
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Fields', 'gigas-addon' ),
	'id'         => 'un-fields-tab',
	'fields'	 => array(
		array(
			'id'			=> 'test_text_field',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Text Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is text field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_textarea_field',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Textarea Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is textarea field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_select_field',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Select Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is select field', 'gigas-addon' ),
			'choices'		=> array(
				'1'	=> 'One',
				'2'	=> 'Two',
				'3'	=> 'Three'
			),
			'default'		=> '2'
		),
		array(
			'id'			=> 'test_color_field',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Color Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is color field', 'gigas-addon' ),
			'alpha'			=> false,
			'default'		=> '#111111'
		),
		array(
			'id'			=> 'test_link_field',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Link Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'ajax-trigger-fonts-test',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Google Fonts Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is fonts field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'background_test',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Background Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'image_test',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Image Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is image field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'border_test',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Border Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is border field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'dimension_test',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Dimension Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is dimension field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'hw_test',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Width/Height Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is width height field', 'gigas-addon' ),
			'only_dimension' => 'both'
		),
		array(
			'id'			=> 'toggle_test',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Toggle Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is toggle field', 'gigas-addon' )
		),
		array(
			'id'			=> 'sidebars_test',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Sidebars Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is sidebars field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'pages_test',
			'type'			=> 'pages',
			'title'			=> esc_html__( 'Pages Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is pages field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'multicheck_test',
			'type'			=> 'multicheck',
			'title'			=> esc_html__( 'Multi Check Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is multi check box field', 'gigas-addon' ),
			'items'		=> array(
				'one' => esc_html__( 'One', 'gigas-addon' ),
				'two' => esc_html__( 'Two', 'gigas-addon' ),
				'three' => esc_html__( 'Three', 'gigas-addon' ),
				'four' => esc_html__( 'Four', 'gigas-addon' ),
				'five' => esc_html__( 'Five', 'gigas-addon' )
			)
		),
		array(
			'id'			=> 'radioimage_test',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Radio Image Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is radio image field', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'left-sidebar'
		),
		array(
			'id'			=> 'dragdrop_test',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Drag Drop Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is drag and drop field', 'gigas-addon' ),
			'default'		=> array(
				'enabled' => array(
					'one' => esc_html__( 'One', 'gigas-addon' ),
					'two' => esc_html__( 'Two', 'gigas-addon' )
				),
				'disabled' => array(
					'three' => esc_html__( 'Three', 'gigas-addon' ),
					'four' => esc_html__( 'Four', 'gigas-addon' ),
					'five' => esc_html__( 'Five', 'gigas-addon' )
				)
			)
		),
		array(
			'id'			=> 'test_label_field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Label Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is label field', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'all-fields-end'	
));*/