<?php
class Gigas_Theme_Styles {
   
   	public $gigas_options;
	private $exists_fonts = array();
	public static $gigas_gf_array = array();
   
    function __construct() {
		$this->gigas_options = get_option( 'gigas_options' );
    }

	function gigas_get_option($field){
		$gigas_options = $this->gigas_options;
		return isset( $gigas_options[$field] ) && $gigas_options[$field] != '' ? $gigas_options[$field] : '';
	}
	
	function gigas_dimension_settings($field, $property = 'width'){
		$gigas_options = $this->gigas_options;
		$units = 'px'; $dimension = '';
		if( isset( $gigas_options[$field] ) ){
			$units = isset( $gigas_options[$field]['units'] ) ? $gigas_options[$field]['units'] : $units;
			$dimension = isset( $gigas_options[$field][$property] ) && $gigas_options[$field][$property] != '' ? absint( $gigas_options[$field][$property] ) . $units : '';
		}
		return $dimension;
	}

	function gigas_image_settings($field){
		$gigas_options = $this->gigas_options;
		$img_arr = array(
			'id' => null,
			'url' => null
		);
		$image = isset( $gigas_options[$field] ) && isset( $gigas_options[$field]['image'] ) ? $gigas_options[$field]['image'] : '';
		if( !empty( $image ) ){
			$img_arr['id'] = isset( $image['id'] ) ? $image['id'] : null;
			$img_arr['url'] = isset( $image['url'] ) ? $image['url'] : null;
		}
		return $img_arr;
	}
	
	function gigas_border_settings($field, $class_names = null){
		$gigas_options = $this->gigas_options;

		if( isset( $gigas_options[$field] ) ):

			$stat = false;
			$position = array( 'top', 'right', 'bottom', 'left' );
			foreach( $position as $key ){
				if( isset( $gigas_options[$field][$key] ) && $gigas_options[$field][$key] != NULL && !$stat ) $stat = true;
			}
		
			$boder_style = isset( $gigas_options[$field]['style'] ) && $gigas_options[$field]['style'] != '' ? $gigas_options[$field]['style'] : '';
			$border_color = isset( $gigas_options[$field]['color'] ) && $gigas_options[$field]['color'] != '' ? $gigas_options[$field]['color'] : '';

			if( $class_names && $stat ) echo $class_names . ' {';
			
			if( isset( $gigas_options[$field]['top'] ) && $gigas_options[$field]['top'] != NULL ):
				echo 'border-top-width: '. $gigas_options[$field]['top'] .'px;';
				if( $boder_style ) echo 'border-top-style: '. $boder_style .';';
				if( $border_color ) echo 'border-top-color: '. $border_color .';';
			endif;
			
			if( isset( $gigas_options[$field]['right'] ) && $gigas_options[$field]['right'] != NULL ):
				echo 'border-right-width: '. $gigas_options[$field]['right'] .'px;';
				if( $boder_style ) echo 'border-right-style: '. $boder_style .';';
				if( $border_color ) echo 'border-right-color: '. $border_color .';';
			endif;
			
			if( isset( $gigas_options[$field]['bottom'] ) && $gigas_options[$field]['bottom'] != NULL ):
				echo 'border-bottom-width: '. $gigas_options[$field]['bottom'] .'px;';
				if( $boder_style ) echo 'border-bottom-style: '. $boder_style .';';
				if( $border_color ) echo 'border-bottom-color: '. $border_color .';';
			endif;
			
			if( isset( $gigas_options[$field]['left'] ) && $gigas_options[$field]['left'] != NULL ):
				echo 'border-left-width: '. $gigas_options[$field]['left'] .'px;';
				if( $boder_style ) echo 'border-left-style: '. $boder_style .';';
				if( $border_color ) echo 'border-left-color: '. $border_color .';';
			endif;

			if( $class_names && $stat ) echo '}';
			
		endif;
	}
	
	function gigas_padding_settings($field, $class_names = null){
		$gigas_options = $this->gigas_options;
		$stat = false;
		$position = array( 'top', 'right', 'bottom', 'left' );
		foreach( $position as $key ){
			if( isset( $gigas_options[$field][$key] ) && $gigas_options[$field][$key] != NULL && !$stat ) $stat = true;
		}
		if( isset( $gigas_options[$field] ) ):
			if( $class_names && $stat ) echo $class_names . ' {';	
			echo isset( $gigas_options[$field]['top'] ) && $gigas_options[$field]['top'] != NULL ? 'padding-top: '. $gigas_options[$field]['top'] .'px;' : '';
			echo isset( $gigas_options[$field]['right'] ) && $gigas_options[$field]['right'] != NULL ? 'padding-right: '. $gigas_options[$field]['right'] .'px;' : '';
			echo isset( $gigas_options[$field]['bottom'] ) && $gigas_options[$field]['bottom'] != NULL ? 'padding-bottom: '. $gigas_options[$field]['bottom'] .'px;' : '';
			echo isset( $gigas_options[$field]['left'] ) && $gigas_options[$field]['left'] != NULL ? 'padding-left: '. $gigas_options[$field]['left'] .'px;' : '';
			if( $class_names && $stat ) echo '}';
		endif;
	}
	
	function gigas_margin_settings($field, $class_names = null){
		$gigas_options = $this->gigas_options;
		$stat = false;
		$position = array( 'top', 'right', 'bottom', 'left' );
		foreach( $position as $key ){
			if( isset( $gigas_options[$field][$key] ) && $gigas_options[$field][$key] != NULL && !$stat ) $stat = true;
		}
		if( isset( $gigas_options[$field] ) ):	
			if( $class_names && $stat ) echo $class_names . ' {';	
			echo isset( $gigas_options[$field]['top'] ) && $gigas_options[$field]['top'] != NULL ? 'margin-top: '. $gigas_options[$field]['top'] .'px;' : '';
			echo isset( $gigas_options[$field]['right'] ) && $gigas_options[$field]['right'] != NULL ? 'margin-right: '. $gigas_options[$field]['right'] .'px;' : '';
			echo isset( $gigas_options[$field]['bottom'] ) && $gigas_options[$field]['bottom'] != NULL ? 'margin-bottom: '. $gigas_options[$field]['bottom'] .'px;' : '';
			echo isset( $gigas_options[$field]['left'] ) && $gigas_options[$field]['left'] != NULL ? 'margin-left: '. $gigas_options[$field]['left'] .'px;' : '';
			if( $class_names && $stat ) echo '}';
		endif;
	}

	function gigas_color($field, $class_names = null){
		$gigas_options = $this->gigas_options;
		if( isset( $gigas_options[$field] ) && $gigas_options[$field] != '' ) {
			if( $class_names ) echo $class_names . '{';
			echo 'color: '. $gigas_options[$field] .';';
			if( $class_names ) echo '}';
		}
	}
	
	function gigas_link_color($field, $fun, $class_names = null){
		$gigas_options = $this->gigas_options;
		if( isset( $gigas_options[$field][$fun] ) && $gigas_options[$field][$fun] != '' ) {
			if( $class_names ) echo $class_names . '{';
			echo 'color: '. $gigas_options[$field][$fun] .';';
			if( $class_names ) echo '}';
		}
	}
	
	function gigas_button_color($field, $fun, $class_names = null){
		$gigas_options = $this->gigas_options;
		if( isset( $gigas_options[$field][$fun] ) && $gigas_options[$field][$fun] != '' ) {
			if( $class_names ) echo $class_names . '{';
				switch( $fun ){
					case "hfore":
					case "fore":
						echo 'color: '. $gigas_options[$field][$fun] .';';
					break;
					case "hbg":
					case "bg":
						echo 'background-color: '. $gigas_options[$field][$fun] .';';
					break;
					case "hborder":
					case "border":
						echo 'border-color: '. $gigas_options[$field][$fun] .';';
					break;
				}
			if( $class_names ) echo '}';
		}
	}
		
	function gigas_bg_settings($field, $class_names = null){
		$gigas_options = $this->gigas_options;
		if( isset( $gigas_options[$field] ) ):

			$stat = false;
			$keys = array( 'bg_color', 'bg_repeat', 'bg_position', 'bg_size', 'bg_attachment' );
			foreach( $keys as $key ){
				if( isset( $gigas_options[$field][$key] ) && !empty( $gigas_options[$field][$key] ) && !$stat ) $stat = true;
			}
			if( isset( $gigas_options[$field]['image']['url'] ) && !empty( $gigas_options[$field]['image']['url'] ) && !$stat ) $stat = true;

			if( $class_names && $stat ) echo $class_names . '{';
			echo '
			'. ( isset( $gigas_options[$field]['bg_color'] ) && !empty( $gigas_options[$field]['bg_color'] ) ?  'background-color: '. $gigas_options[$field]['bg_color'] .';' : '' ) .'
			'. ( isset( $gigas_options[$field]['image']['url'] ) && !empty( $gigas_options[$field]['image']['url'] ) ?  'background-image: url('. $gigas_options[$field]['image']['url'] .');' : '' ) .'
			'. ( isset( $gigas_options[$field]['bg_repeat'] ) && !empty( $gigas_options[$field]['bg_repeat'] ) ?  'background-repeat: '. $gigas_options[$field]['bg_repeat'] .';' : '' ) .'
			'. ( isset( $gigas_options[$field]['bg_position'] ) && !empty( $gigas_options[$field]['bg_position'] ) ?  'background-position: '. $gigas_options[$field]['bg_position'] .';' : '' ) .'
			'. ( isset( $gigas_options[$field]['bg_size'] ) && !empty( $gigas_options[$field]['bg_size'] ) ?  'background-size: '. $gigas_options[$field]['bg_size'] .';' : '' ) .'
			'. ( isset( $gigas_options[$field]['bg_attachment'] ) && !empty( $gigas_options[$field]['bg_attachment'] ) ?  'background-attachment: '. $gigas_options[$field]['bg_attachment'] .';' : '' ) .'
			';
			if( $class_names && $stat ) echo '}';
		endif;
	}
	
	function gigas_custom_font_face_create( $font_family, $font_slug, $cf_names ){	
		$upload_dir = wp_upload_dir();
		$f_type = array('eot', 'otf', 'svg', 'ttf', 'woff');		
		$font_path = $upload_dir['baseurl'] . '/custom-fonts/' . str_replace( "'", "", $font_family .'/'. $font_slug );
		echo ' @font-face { font-family: '. $font_family .';';
		echo " src: url('". esc_url( $font_path ) .".eot') format('embedded-opentype'), url('". esc_url( $font_path ) .".woff2') format('woff2'), url('". esc_url( $font_path ) .".woff') format('woff'), url('". esc_url( $font_path ) .".ttf')  format('truetype'), url('". esc_url( $font_path ) .".svg') format('svg');}";		
	}
	
	function gigas_custom_font_check($field){
		$gigas_options = $this->gigas_options;
		$cf_names = get_option( 'gigas_custom_fonts' );
		$font_family = isset( $gigas_options[$field]['font_family'] ) ? $gigas_options[$field]['font_family'] : '';
		$font_slug = $font_family ? sanitize_title( $font_family ) : '';
		if ( !empty( $cf_names ) && is_array( $cf_names ) && array_key_exists( $font_slug, $cf_names ) ){	
			if ( !empty( $cf_names ) && !in_array( $font_slug, $this->exists_fonts ) ){
				$this->gigas_custom_font_face_create( $font_family, $font_slug, $cf_names );
				array_push( $this->exists_fonts, $gigas_options[$field]['font-family'] );
				return 1;
			}
		}
		return 0;
	}
	
	function gigas_get_custom_google_font_frame( $font_family ){	
		$family = isset( $font_family['family'] ) ? $font_family['family'] : '';
		$weight = isset( $font_family['weight'] ) ? $font_family['weight'] : '';
		$subset = isset( $font_family['subset'] ) ? $font_family['subset'] : '';		
		if( !empty( $family ) ){
			if( isset( self::$gigas_gf_array[$family] ) ){
				array_push( self::$gigas_gf_array[$family]['weight'], $weight );
				array_push( self::$gigas_gf_array[$family]['subset'], $subset );
			}else{
				self::$gigas_gf_array[$family] = array( 'weight' => array( $weight ), 'subset' => array( $subset ) );
			}
		}
	}
	
	function gigas_typo_generate($field){
		$gigas_options = $this->gigas_options;
		$font_family = isset( $gigas_options[$field]['font_family'] ) ? $gigas_options[$field]['font_family'] : '';
		$standard_fonts = Gigas_Google_Fonts_Function::$_standard_fonts;
		if( !array_key_exists( $font_family, $standard_fonts ) ){			
			$font_weight = isset( $gigas_options[$field]['font_weight'] ) && $gigas_options[$field]['font_weight'] != '' ? $gigas_options[$field]['font_weight'] : '';
			$font_sub = isset( $gigas_options[$field]['font_sub'] ) && $gigas_options[$field]['font_sub'] != '' ? $gigas_options[$field]['font_sub'] : '';
			$gf_arr = array( 'family' => $font_family, 'weight' => $font_weight, 'subset' => $font_sub );	
			$this->gigas_get_custom_google_font_frame( $gf_arr );
		}
	}
	
	function gigas_typo_settings($field, $class_names = null){
		
		//Custom font check and google font generate
		$cf_stat = $this->gigas_custom_font_check($field);
		if( !$cf_stat ) $this->gigas_typo_generate($field);		
		$gigas_options = $this->gigas_options;
		if( isset( $gigas_options[$field] ) ):

			$stat = false;
			$keys = array( 'font_color', 'font_family', 'font_weight', 'font_style', 'font_size', 'line_height', 'letter_spacing', 'text_align', 'text_transform' );
			foreach( $keys as $key ){
				if( isset( $gigas_options[$field][$key] ) && !empty( $gigas_options[$field][$key] ) && !$stat ) $stat = true;
			}
			echo $class_names && $stat ? esc_attr( $class_names ) . '{' : '';
			
			$font_weight = isset( $gigas_options[$field]['font_weight'] ) ? $gigas_options[$field]['font_weight'] : '';
			$font_style = '';
			if( !empty( $font_weight ) && strpos( $font_weight, 'italic' ) ){
				$font_style = 'italic';
				$font_weight = str_replace( 'italic', '', $font_weight );
			}

			echo '
			'. ( isset( $gigas_options[$field]['font_color'] ) && $gigas_options[$field]['font_color'] != '' ?  'color: '. $gigas_options[$field]['font_color'] .';' : '' ) .'
			'. ( isset( $gigas_options[$field]['font_family'] ) && $gigas_options[$field]['font_family'] != '' ?  'font-family: '. stripslashes_deep( $gigas_options[$field]['font_family'] ) .';' : '' ) .'
			'. ( $font_weight ?  'font-weight: '. $font_weight .';' : '' ) .'
			'. ( $font_style ?  'font-style: '. $font_style .';' : '' ) .'
			'. ( isset( $gigas_options[$field]['font_size'] ) && $gigas_options[$field]['font_size'] != '' ?  'font-size: '. $gigas_options[$field]['font_size'] .'px;' : '' ) .'
			'. ( isset( $gigas_options[$field]['line_height'] ) && $gigas_options[$field]['line_height'] != '' ?  'line-height: '. $gigas_options[$field]['line_height'] .'px;' : '' ) .'
			'. ( isset( $gigas_options[$field]['letter_spacing'] ) && $gigas_options[$field]['letter_spacing'] != '' ?  'letter-spacing: '. $gigas_options[$field]['letter_spacing'] .'px;' : '' ) .'
			'. ( isset( $gigas_options[$field]['text_align'] ) && $gigas_options[$field]['text_align'] != '' ?  'text-align: '. $gigas_options[$field]['text_align'] .';' : '' ) .'
			'. ( isset( $gigas_options[$field]['text_transform'] ) && $gigas_options[$field]['text_transform'] != '' ?  'text-transform: '. $gigas_options[$field]['text_transform'] .';' : '' ) .'
			';
		endif;
		echo $class_names && $stat ? '}' : '';
	}
	
	function gigas_hex2rgba($color, $opacity = 1) {
	 
		$default = '';
		//Return default if no color provided
		if(empty($color))
			  return $default; 
		//Sanitize $color if "#" is provided 
			if ($color[0] == '#' ) {
				$color = substr( $color, 1 );
			}
			//Check if color has 6 or 3 characters and get values
			if (strlen($color) == 6) {
					$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
			} elseif ( strlen( $color ) == 3 ) {
					$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
			} else {
					return $default;
			}
			//Convert hexadec to rgb
			$rgb =  array_map('hexdec', $hex);
	 
			//Check if opacity is set(rgba or rgb)
			if( $opacity == 'none' ){
				$output = implode(",",$rgb);
			}elseif( $opacity ){
				if(abs($opacity) > 1)
					$opacity = 1.0;
				$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
			}else {
				$output = 'rgb('.implode(",",$rgb).')';
			}
			//Return rgb(a) color string
			return $output;
	}

}