<?php

/**
 * Gigas Theme Options
 * @since 1.0.0
 */
final class Gigas_Plugin_Options { //gigas_admin_menu_out
	
	private static $_instance = null;
	
	public function __construct() {	
		add_action( 'admin_menu', array( $this, 'gigas_addon_options_menu' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'gigas_framework_admin_scripts' ) );
		$this->init();
		//import
		add_action( 'wp_ajax_bridddge-theme-option-import', array( $this, 'gigas_redux_themeopt_import' ) );
		//export
		add_action('wp_ajax_gigas-theme-options-export', array( $this, 'gigas_theme_options_export' ) );
		
	}
	
	public static function gigas_addon_options_menu(){
		add_submenu_page( 
			'gigas-welcome', 
			esc_html__( 'Theme Options', 'gigas-addon' ),
			esc_html__( 'Theme Options', 'gigas-addon' ), 
			'manage_options', 
			'gigas-options', 
			array( 'Gigas_Plugin_Options', 'gigas_options_admin_page' )
		);
	}
	
	public static function gigas_framework_admin_scripts(){
		if( isset( $_GET['page'] ) && $_GET['page'] == 'gigas-options' ){
			wp_enqueue_style( 'font-awesome', GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/css/font-awesome.min.css', array(), '4.7.0', 'all' );			
			wp_enqueue_style( 'bootstrap-icons', GIGAS_URI . '/assets/css/bootstrap-icons.css', array(), '1.9.1', 'all' );
			
			wp_enqueue_media();
			wp_enqueue_style( 'gigas_theme_options_css', GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/css/theme-options.css', array(), '1.0', 'all' );
			wp_enqueue_style( 'wp-color-picker');
			wp_enqueue_script( 'wp-color-picker-alpha', GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/js/wp-color-picker-alpha.min.js', array( 'jquery', 'wp-color-picker' ), '3.0.0' );
			wp_enqueue_script( 'gigas_theme_options_js', GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/js/theme-options.js', array( 'jquery' ), '1.0', true );

			wp_localize_script( 'gigas_theme_options_js', 'gigas_ajax_object',
				array(
					'import_nonce' => wp_create_nonce( 'gigas-import-*&^F&' ),
					'export_nonce' => wp_create_nonce( 'gigas-export-&^%$)' ),
				)
			);

			require_once GIGAS_ADDON_DIR . 'admin/extension/theme-options/googlefonts.php';
			$google_fonts = Gigas_Google_Fonts_Function::$_google_fonts;
			$google_fonts_arr = json_decode( $google_fonts, true );
			
			$extra_gf = array(
				"Spartan" => array(
					"variants" => array(
						array( "id" => "400", "name" => "Thin 100" ),
						array( "id" => "400", "name" => "Extra-light 200" ),
						array( "id" => "400", "name" => "Light 300" ),
						array( "id" => "400", "name" => "Regular 400" ),
						array( "id" => "400", "name" => "Medium 500" ),
						array( "id" => "400", "name" => "Semi-bold 600" ),
						array( "id" => "400", "name" => "Bold 700" ),
						array( "id" => "400", "name" => "Extra-bold 800" ),
						array( "id" => "400", "name" => "Black 900" )
					)
				)
			);
			if( is_array( $extra_gf ) && !empty( $extra_gf ) ){
				foreach( $extra_gf as $font => $details ) $google_fonts_arr[$font] = $details;
			}
			
			$google_fonts = json_encode( $google_fonts_arr );
			$google_fonts_vars = array(
				'google_fonts' => $google_fonts,
				'standard_font_variants' => Gigas_Google_Fonts_Function::$_standard_font_variants,
				'font_variants_default' => esc_html__( 'Font Weight &amp; Style', 'gigas-addon' ),
				'font_sub_default' => esc_html__( 'Font Subsets', 'gigas-addon' )
			);
			wp_localize_script( 'gigas_theme_options_js', 'google_fonts_vars', $google_fonts_vars );
			
		}
	}
	
	public function init() {
		require_once( GIGAS_ADDON_DIR . 'admin/extension/theme-options/framework.php' );
		Gigas_Options::$opt_name = 'gigas_options';
	}
		
	public static function gigas_options_admin_page(){	
		$gigas_theme = wp_get_theme(); ?>	
		<form method="post" action="#" enctype="multipart/form-data" id="gigas-plugin-form-wrapper">
			<div class="gigas-settings-wrap">
			<div class="gigas-header-bar">
				<div class="gigas-header-left">
					<div class="gigas-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="gigas-logo">
					</div><!-- .gigas-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Gigas Options', 'gigas-addon' ); ?><span class="gigas-version"><?php echo esc_attr( $gigas_theme->get( 'Version' ) ); ?></span></h2>
						<div class="nav-theme-options">
							<?php
							include_once(ABSPATH . 'wp-admin/includes/plugin.php');
							$is_gigas_addon_active = is_plugin_active('gigas-addon/gigas-addon.php');
							$current_theme = wp_get_theme();
							$is_theme_active = ($current_theme->get('Name') === 'Gigas');
							$verfied_stat = get_option('verified_purchase_status');

							if ($is_gigas_addon_active) {
								echo '<a href="' . admin_url('admin.php?page=gigas-options') . '" class="active-page"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
							} else {
								echo '<a href="#" class="theme-options not-clickable" data-popup-message="Please install and activate the Gigas Addon plugin."><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
							}
							if ($verfied_stat) {
								echo '<a href="' . admin_url('admin.php?page=gigas-plugins') . '"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
							} else {
								echo '<a href="#" class="not-clickable" data-popup-message="Please activate the Gigas theme."><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
							}
							?>
							<div class="support-dropdown">
								<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
								<div class="dropdown-content">
									<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
									<a href="https://docs.zozothemes.com/gigas/" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
								</div>
							</div>
							<a href="https://zozothemes.com/forum/" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
						</div>
					</div><!-- .gigas-header-left -->
					<div class="gigas-header-right">
						<button type="submit" class="button gigas-btn"><?php esc_html_e( 'Save Settings', 'gigas-addon' ); ?></button>
					</div><!-- .gigas-header-right -->
				</div><!-- .gigas-header-bar -->	
					
				<div class="gigas-inner-wrap">
						
					<?php
						if ( isset( $_POST['save_gigas_theme_options'] ) && wp_verify_nonce( $_POST['save_gigas_theme_options'], 'gigas_theme_options*&^&*$' ) ) {
							update_option( 'gigas_options', $_POST['gigas_options'] );
							require_once ( GIGAS_ADDON_DIR . 'admin/extension/theme-options/theme-options-css.php' );
						}
						//Get updated theme option
						Gigas_Options::$gigas_options = get_option('gigas_options');
						
						if( class_exists( 'Classic_Elementor_Addon' ) ){
							add_action( 'gigas_custom_template_options', function(){
								require_once GIGAS_ADDON_DIR . 'admin/extension/theme-options/cea-config.php';
							});
						}
						//Theme config
						require_once GIGAS_ADDON_DIR . 'admin/extension/theme-options/config.php';
					?>
					<div class="gigas-admin-content-wrap">
						<?php wp_nonce_field( 'gigas_theme_options*&^&*$', 'save_gigas_theme_options' ); ?>
						<div class="gigas-tab">
							<div class="gigas-tab-list">
								<ul class="tablinks-list">
									<?php Gigas_Options::gigas_put_section(); 
										if (is_plugin_active('classic-elementor-addons-pro/index.php')): ?>
											<div class="gigas-navigation-buttons">
												<a href="<?php echo admin_url('admin.php?page=classic-addons'); ?>" target="_blank" class="button gigas-btn"><i class="fa fa-caret-square-o-left" aria-hidden="true"></i><?php esc_html_e('CEA Plugin Options', 'gigas'); ?></a>
											</div>
										<?php endif; 
									?>
								</ul>
							</div><!-- .gigas-tab-list -->
							<div class="gigas-tab-contents">
								
							<!-- <a href="https://docs.zozothemes.com/gigas/" target="_blank" class="docs-tooltip" title="Documentation"><span class="dashicons dashicons-editor-help theme-info"></span></a> -->
								<?php Gigas_Options::gigas_put_field(); ?>
							</div><!-- .gigas-tab-contents -->
						</div><!-- .gigas-tab -->					
					</div><!-- .gigas-admin-content-wrap -->					
				</div><!-- .gigas-inner-wrap -->
			</div><!-- .gigas-settings-wrap -->
			<div class="gigas-db-footer">
					<div class="gigas-db-footer-top">
						<nav class="gigas-db-footer-menu">
						<div class="copyright-text-wrap">Copyrights  © <script>document.write(new Date().getFullYear())</script> Designed by 
						<a href="https://zozothemes.com/" class="theme-color" target="_blank">Zozothemes <span class="heart-color">♥</span></a></div>
							<ul>
								<li>
									<a href="https://docs.zozothemes.com/gigas/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Documentation', 'gigas-addon' ); ?></a>
								</li>
								<li>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Video Tutorials', 'gigas--addon' ); ?></a>
								</li>
								<li>
									<a href="https://zozothemes.com/knowledge-base/" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Submit A Ticket', 'gigas--addon' ); ?></a>
								</li>
							</ul>
						</nav>
					</div>
			</div>
		</form>	
	<?php
	}

	public static function gigas_theme_options_export(){
		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : '';
		if ( ! wp_verify_nonce( $nonce, 'gigas-export-&^%$)' ) )
			die ( esc_html__( 'Busted!', 'gigas-addon' ) );
		
		$gigas_options = get_option( 'gigas_options');
		$gigas_options = is_array( $gigas_options ) ? array_map( 'stripslashes_deep', $gigas_options ) : stripslashes( $gigas_options );
		echo json_encode( $gigas_options );
		
		exit;
	}

	public static function gigas_redux_themeopt_import(){
		$nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( $_POST['nonce'] ) : ''; //Sanitize
		if ( ! wp_verify_nonce( $nonce, 'gigas-import-*&^F&' ) )
			die ( esc_html__( 'Busted', 'gigas-addon' ) );
		
		$json_data = isset( $_POST['json_data'] ) ? stripslashes( urldecode( $_POST['json_data'] ) ) : '';
		$theme_opt_arr = json_decode( $json_data, true );
		if( !empty( $theme_opt_arr ) ){
			update_option( 'gigas_options', $theme_opt_arr );
		}
		
		wp_die('success');
	}
	
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

}

Gigas_Plugin_Options::instance();