<?php

// General
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'General', 'gigas-addon' ),
	'id'         => 'general-tab',
	'config_id'  => 'customizer_settings_general_settings',
) );

// -> Site Settings
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Site Settings', 'gigas-addon' ),
	'id'         => 'site-general-settings',
	'config_id'  => 'customizer_settings_general_settings',
	'fields'	 => array(
		array(
			'id'			=> 'loader-settings',
			'config_id'     => '',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Loader Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for site page loader. If you have did not uploaded means default page loader will work.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id' 			=> 'page-loader-option',
			'config_id'     => '',
			'type' 			=> 'toggle',
			'title' 		=> esc_html__( 'Enable/Disable Page Loader', 'gigas-addon' ),
			'description'   => esc_html__( 'Toggle to enable or disable the page loading animation before the content appears.', 'gigas-addon'),
		),
		array(
			'id'			=> 'page_loader',
			'config_id'     => '',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Page Loader', 'gigas-addon' ),
			'description'	=> esc_html__( 'Upload an image or GIF to be displayed before the page content appears, enhancing the user experience with a custom loading animation.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'page-loader-option', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'site-layout-settings',
			'config_id'     => '',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is site layout settings.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'            => 'site-layout',
			'config_id'     => '',
			'type'          => 'radioimage',
			'title'         => esc_html__('Site Layout', 'gigas-addon'),
			'description'   => esc_html__('Choose between boxed, full-width, or other layout styles for the overall site design.', 'gigas-addon'),
			'items'         => array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/site-layout/site-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/site-layout/site-boxed.png'
				),
				'wider' => array(
					'title' => esc_html__('Wider', 'gigas-addon'),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/site-layout/site-wider.png'
				)
			),
			'default'       => 'wide',
			'required'      => array('general-chk', '=', array('custom'))
		),		
		array(
			'id'			=> 'site-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Site Maximum Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'Controls the overall site width. Enter value including any valid CSS unit, ex: 1200.', 'gigas-addon' ),
			'only_dimension' => 'width',
			'default'		=> array( 'width' => '1200' )
		),
		array(
			'id'			=> 'site-padding',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Site Content Padding', 'gigas-addon' ),
			'description'	=> esc_html__( 'Adjust the top/bottom padding for page content. Enter values like, ex: 60, 60.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'site-bg',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Body Background', 'gigas-addon' ),
			'description'	=> esc_html__( 'In boxed layout site setting, background color of the site background can be choosen here!.', 'gigas-addon' ),
			'required'		=> array( 'site-layout', '=', array( 'boxed' ) )
		),
		array(
			'id'			=> 'site-api-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'API Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is site API settings.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'mailchimp-api',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Mailchimp API', 'gigas-addon' ),
			'description'   => wp_kses_post('Enter your Mailchimp API key to enable email marketing integrations. Then add the mailchimp to your widget area and Select the Mailing List, <a href="https://mailchimp.com/" style="text-decoration:none;" target="_blank">Get API.</a>.', 'gigas-addon'),
			'default'		=> ''
		),
		array(
			'id'			=> 'site-rtl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'RTL Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Toggle this control to enable or disable RTL mode.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'rtl',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable RTL', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to switch your entire site to Right-to-Left text direction, suitable for languages like Arabic and Hebrew.', 'gigas-addon' )
		),
		array(
			'id'  			=> 'dark-light-setting',
			'type'          => 'label',
			'title'  		=> esc_html( 'Dark/Light Mode'),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'dark-light',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable Dark/Light', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle this to enable a switch between dark and light themes for the entire site.', 'gigas-addon' )
		),
		array(
			'id'  			=> 'favicon-setting',
			'type'          => 'label',
			'title'  		=> esc_html( 'Favicon Settings'),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'favicon-icon',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Favicon Icon', 'gigas-addon' ),
			'description'	=> esc_html__( 'Upload a small icon which is displayed as your site icon.', 'gigas-addon' )
		)
	)
) );
// -> Logo Settings
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Logo Settings', 'gigas-addon' ),
	'id'         => 'site-logo-settings',
	'config_id'  => 'customizer_settings_general_settings',
	'fields'	 => array(
		array(
			'id'			=> 'logo-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Logo Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for site logo.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'site-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Default Logo', 'gigas-addon' ),
			'description'	=> wp_kses_post('Choose an image as a primary logo for your site. Some pages have a unique logo that cannot be changed here, how to change that <p class="tooltip">?<span class="tooltiptext">If a page has unique logo, navigate to Edit Page. In the Options area, go to General -> Site General Setting -> Custom -> Default Logo, updated your logo here.</span></p>', 'gigas-addon'),
			'default'		=> ''
		),
		array(
			'id'			=> 'site-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Site Logo Maximum Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the maximum width of the site logo. If you want original width leave this field empty.', 'gigas-addon' ),
			'only_dimension' => 'width'
		),
		array(
			'id'			=> 'site-logo-desc',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable Site Logo Description', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to display a short description or tagline next to the site logo.', 'gigas-addon' )
		),
		array(
			'id'			=> 'sticky-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Sticky/Fixed Logo', 'gigas-addon' ),
			'description'	=> esc_html__( 'Upload an image as a logo for your sticky header. While scrolling it will be fixed.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'sticky-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Sticky/Fixed Logo Maximum Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the maximum width of sticky logo. If you want original width leave this field empty.', 'gigas-addon' ),
			'only_dimension' => 'width'
		),
		array(
			'id'			=> 'mobile-logo',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Mobile Logo', 'gigas-addon' ),
			'description'	=> esc_html__( 'Upload or set a separate logo specifically for mobile devices.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'mobile-logo-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Mobile Logo Maximum Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the maximum width of mobile logo. If you want original width leave this field empty.', 'gigas-addon' ),
			'only_dimension' => 'width'
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'general-end'
));

// Typography
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Typography', 'gigas-addon' ),
	'id'         => 'typography-tab',
	'config_id'  => 'customizer_settings_typography',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Site Typography', 'gigas-addon' ),
	'id'         => 'site-typo-settings',
	'config_id'  => 'customizer_settings_typography',
	'fields'	 => array(
		array(
			'id'			=> 'content-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Site Common Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the primary typography used across the site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'lead-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Lead Text Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose the typography settings for lead text, typically used for important or introductory content.', 'gigas-addon' ),
			'default'		=> ''
		)
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Heading Typography', 'gigas-addon' ),
	'id'         => 'heading-typo-settings',
	'config_id'  => 'customizer_settings_typography',
	'fields'	 => array(
		array(
			'id'			=> 'h1-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H1 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H1 headings on the site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h2-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H2 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H2 headings on the site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h3-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H3 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H3 headings on the site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h4-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H4 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H4 headings on the site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h5-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H5 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H5 headings on the site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h6-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H6 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H6 headings on the site.', 'gigas-addon' ),
			'default'		=> ''
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Heading MobileView Typography', 'gigas-addon' ),
	'id'         => 'heading-mobile-typo-settings',
	'config_id'  => 'customizer_settings_typography',
	'fields'	 => array(
		array(
			'id'			=> 'h1-mobile-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H1 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H1 headings on mobile devices.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h2-mobile-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H2 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H2 headings on mobile devices.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h3-mobile-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H3 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H3 headings on mobile devices.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h4-mobile-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H4 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H4 headings on mobile devices.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h5-mobile-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H5 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H5 headings on mobile devices.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'h6-mobile-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'H6 Fonts', 'gigas-addon' ),
			'description'	=> esc_html__( 'These settings control the typography specifically for all H6 headings on mobile devices.', 'gigas-addon' ),
			'default'		=> ''
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Site Header Typography', 'gigas-addon' ),
	'id'         => 'header-typo-settings',
	'config_id'  => 'customizer_settings_typography',
	'fields'	 => array(
		array(
			'id'			=> 'header-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Site Header Typography', 'gigas-addon' ),
			'description' 	=> esc_html__( 'Customize the font, size, and style for text elements within the Site Header of the Site.', 'gigas-addon' ),
			'default'		=> ''
		),		
		array(
			'id'			=> 'header-topbar-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Header Top Typography', 'gigas-addon' ),
			'description'  	=> esc_html__( 'Customize the font, size, and style for text elements within the Header Top of the Site.', 'gigas-addon' ),
			'default'		=> ''
		),		
		array(
			'id'			=> 'header-logobar-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Header Middle Typography', 'gigas-addon' ),
			'description'  	=> esc_html__( 'Customize the font, size, and style for text elements within the Header Middle of the Site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'header-navbar-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Header Bottom Typography', 'gigas-addon' ),
			'description'  	=> esc_html__( 'Customize the font, size, and style for text elements within the Header Bottom of the Site.', 'gigas-addon' ),
			'default'		=> ''
		)
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Site Footer Typography', 'gigas-addon' ),
	'id'         => 'footer-typo-settings',
	'config_id'  => 'customizer_settings_typography',
	'fields'	 => array(
		array(
			'id'			=> 'footer-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Site Footer Typography', 'gigas-addon' ),
			'description'  	=> esc_html__( 'Customize the font, size, and style for text elements within the Site Footer of the Site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'insta-footer-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Footer Top Typography', 'gigas-addon' ),
			'description'  	=> esc_html__( 'Customize the font, size, and style for text elements within the Footer Top of the Site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'footer-widgets-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Footer Widgets Typography', 'gigas-addon' ),
			'description'  	=> esc_html__( 'Customize the font, size, and style for text elements within the Footer Widgets of the Site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'copyright-section-typography',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Copyright Section Typography', 'gigas-addon' ),
			'description'  	=> esc_html__( 'Customize the font, size, and style for text elements within the Copyright Section of the Site.', 'gigas-addon' ),
			'default'		=> ''
		)
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'typography-end'
));

// Colors
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Colors', 'gigas-addon' ),
	'id'         => 'colors-tab',
	'config_id'  => 'customizer_settings_skin',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Theme Colors', 'gigas-addon' ),
	'id'         => 'theme-colors',
	'config_id'  => 'customizer_settings_skin',
	'fields'	 => array(
		array(
			'id'			=> 'color-layout-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Theme Color Settings', 'gigas-addon' ),
			'seperator'		=> 'before',
		),
		array(
			'id'			=> 'primary-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Theme Primary Color', 'gigas-addon' ),
			'description'   => wp_kses_post( 'Set the main color used for your website, to applying it across all elements. Ensure to update this color in both the <a href="admin.php?page=revslider">Slider</a> and Elementor settings under <b>Site Settings > Global Colors</b>.', 'gigas-addon'),
			'alpha'			=> false,
			'default'		=> '#3845ab'
		),
		array(
			'id'			=> 'secondary-color',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Theme Secondary Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the secondary color of the theme. Selected color will work in few places of the website. If you want theme default secondary color leave this field as empty.', 'gigas-addon' ),
			'alpha'			=> false,
			'default'		=> '#b043ba'
		),
		array(
			'id'			=> 'link-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Theme Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the default color for hyperlinks across the site.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'button-color',
			'type'			=> 'btn_color',
			'title'			=> esc_html__( 'Button Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the default color for buttons across the site.', 'gigas-addon' ),
			'default'		=> ''
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'theme-colors-end'	
));

// Header
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Site Header', 'gigas-addon' ),
	'id'         => 'header-tab',
	'config_id'  => 'customizer_settings_header',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'General', 'gigas-addon' ),
	'id'         => 'header-general',
	'config_id'  => 'customizer_settings_header',
	'fields'	 => array(
		array(
			'id'			=> 'header-layout-label',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all header settings.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'header-links-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Header Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the text color for hyperlinks in the header section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-background',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Header Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the header section, including color, image, size, etc.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-border',
					'type'			=> 'border',
					'title'			=> esc_html__( 'Header Border', 'gigas-addon' ),
					'description'	=> esc_html__( 'Configure and Customize the border style for the header section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the header section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-margin',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header margin', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the header section.', 'gigas-addon' ),
					'default'		=> ''
				),
			),
		),
		array(
			'id'			=> 'header-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Header Layout', 'gigas-addon' ),
			'description'	=> wp_kses_post('Choose the structure of the site header, such as wide or boxed or wider.To create Custom Header and Footer use <a href="edit.php?post_type=zozo-hf" target="__blank">Zozo Header Footer</a> Plugin  <p class="tooltip">?<span class="tooltiptext">Zozo Header Footer is used for creating Custom Header and Footer using Elementor Builder <a href="https://docs.zozothemes.com/zozo-header-footer/" target="__blank">Read More..</a></span></p>', 'gigas-addon'),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wide.png'
				),
				'wider' => array(
					'title' => esc_html__( 'Wider', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-wider.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/header/header-boxed.png'
				)
			),
			'default' => 'wide',
		),
		array(
			'id'			=> 'header-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Header Bars', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select the header items. Drag and drop items you want to display header normal and header sticky area.', 'gigas-addon' ),
			'default'		=> array(
				'normal' => array(
					'topbar' => esc_html__( 'Header Top', 'gigas-addon' ),
					'logobar' => esc_html__( 'Header Middle', 'gigas-addon' )
				),
				'sticky' => array(
					'navbar' => esc_html__( 'Header Bottom', 'gigas-addon' )
				),
				'disabled' => array(
				)
			),
		),
		array(
			'id'			=> 'header-absolute',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Header Transparent', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to enable header over Content. Like floating on Slider / Page title bar and you have to select RGBA background color for your header or header items to display header like that.', 'gigas-addon' ),
			'default'		=> false,
		),
		array(
			'id'			=> 'menu-type',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Main Menu Type', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select the style of the main menu, such as mega menu, otherwise normal menu will display in default.', 'gigas-addon' ),
			'choices'		=> array(
				'normal'	=> esc_html__( 'Default Menu', 'gigas-addon' ),
				'mega'		=> esc_html__( 'Mega menu', 'gigas-addon' )
			),
			'default'		=> 'normal',
		),
		array(
			'id'			=> 'dropdown-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Dropdown Menu Styles', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all type of dropdown menu styles.', 'gigas-addon' ),
			'seperator'		=> 'before',
		),
		array(
			'id'			=> 'dropdown-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Dropdown Menu Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the text color for links within dropdown menus.', 'gigas-addon' ),
			'default'		=> '',
		),
		array(
			'id'			=> 'dropdown-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Dropdown Menu Background Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the background color for dropdown menus in the navigation.', 'gigas-addon' ),
			'default'		=> '',	
		),
		array(
			'id'			=> 'dropdown-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Dropdown Menu Styles on Sticky/Fixed', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can set all the type of menu dropdown styles on sticky.', 'gigas-addon' ),
			'seperator'		=> 'before',
		),
		array(
			'id'			=> 'dropdown-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Dropdown Menu Link Color on Sticky/Fixed', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the text color for dropdown menu links when the header is in sticky mode.', 'gigas-addon' ),
			'default'		=> '',
		),
		array(
			'id'			=> 'dropdown-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Dropdown Menu Background Color on Sticky/Fixed', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the background color for dropdown menus when the header is in sticky mode.', 'gigas-addon' ),
			'default'		=> '',
		),	
		array(
			'id' 			=> 'secondary-area',
			'title'			=> esc_html__( 'Secondary Sidebar', 'gigas-addon'),
			'type'			=> 'label',
			'desc'			=> esc_html__( 'These are extra header options.', 'gigas-addon' ),
			'seperator'		=> 'after',
		),
		array(
			'id'			=> 'secondary-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Secondary Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select widget for secondary widget area. This part only works when you active secondary bar item on nav/logo bars.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'secondary-sidebar-from',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Animation From', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the starting direction for animation effects on secondary bar.', 'gigas-addon' ),
			'choices'		=> array(
				'right'	=> esc_html__( 'Right', 'gigas-addon' ),
				'left'	=> esc_html__( 'Left', 'gigas-addon' )
			),
			'default'		=> 'right'
		),
		array(
			'id'			=> 'secondary-sidebar-width',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Secondary Sidebar Width', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the maximum width of secondary sidebar. Example 300', 'gigas-addon' ),
			'only_dimension' => 'width',
			'default'		=> array( 'width' => '300' )
		),
		array(
			'id'			=> 'header-other-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Other Settings', 'gigas-addon' ),
			'desc'			=> esc_html__( 'These are extra header options.', 'gigas-addon' ),
			'seperator'		=> 'after',
		),
		array(
			'id'			=> 'header-email',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Header Email', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enter the email address displayed in the site header for contact purposes.', 'gigas-addon' ),
			'default'		=> '',
		),
		array(
			'id'			=> 'header-address',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Header Address', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enter the physical address displayed in the site header for contact or location details.', 'gigas-addon' ),
			'default'		=> '',
		),
		array(
			'id'			=> 'search-type',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Search Toggle Modal', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select search box layout type for the search function in the header', 'gigas-addon' ),
			'choices'		=> array(
				'1'	=> esc_html__( 'Full Screen Search', 'gigas-addon' ),
				'2' => esc_html__( 'Text Box Toggle Search', 'gigas-addon' ),
				'3' => esc_html__( 'Full Bar Toggle Search', 'gigas-addon' ),
				'4' => esc_html__( 'Bottom Seach Box Toggle', 'gigas-addon' )
			),
			'default'		=> '1',
		),
		array(
			'id'			=> 'header-offset',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Header Scroll Offset', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the header bottom offset while one page scroll.', 'gigas-addon' ),
			'only_dimension' => 'height',
			'default'		=> array( 'height' => '0' ),
		),
		array(
			'id'			=> 'mobile-header-offset',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Mobile Header Scroll Offset', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the mobile header bottom offset while one page scroll.', 'gigas-addon' ),
			'only_dimension' => 'height',
			'default'		=> array( 'height' => '0' ),
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Header Builder', 'gigas-addon' ),
	'id'         => 'header-topbar',
	'config_id'  => 'customizer_settings_header',
	'fields'	 => array(		
		array(
			'id'			=> 'header-topbar-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Top Settings', 'gigas-addon' ),
			'description'   => esc_html__( 'Arrange and customize the elements in the top header section using a drag-and-drop interface. ', 'gigas-addon' ),
			'seperator'		=> 'before',
			'custom_class'	=> 'header-topbar-settings',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'header-topbar-height',
					'type'			=> 'hw',
					'title'			=> esc_html__( 'Header Top Height', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the height of the top header section (in pixels)', 'gigas-addon' ),
					'only_dimension' => 'height'
				),
				array(
					'id'			=> 'header-topbar-sticky-height',
					'type'			=> 'hw',
					'title'			=> esc_html__( 'Header Top Sticky/Fixed Height', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the height of the top header when it is in sticky or fixed mode.', 'gigas-addon' ),
					'only_dimension' => 'height'
				),		
				array(
					'id'			=> 'header-topbar-links-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Header Top Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the text color for hyperlinks in the header top section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-topbar-background',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Header Top Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the header top section, including color, image, size, etc.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-topbar-border',
					'type'			=> 'border',
					'title'			=> esc_html__( 'Header Top Border', 'gigas-addon' ),
					'description'	=> esc_html__( 'Configure and Customize the border style for the header top section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-topbar-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header Top padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the header top section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-topbar-margin',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header Top margin', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the header top section.', 'gigas-addon' ),
					'default'		=> ''
				),	
			),
		),
		array(
			'id'            => 'topbar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__( 'Custom Text 1', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    		=> 'topbar-custom-text-1',
							'type'  		=> 'textarea',
							'title' 		=> esc_html__( 'Topbar Custom Text 1', 'gigas-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the top bar of the site.', 'gigas-addon' ),
						),
					),
					'editable' => true
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'topbar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Navbar Custom Text 2', 'gigas-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the top bar of the site.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'topbar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'topbar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'topbar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'topbar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),
					'editable' => true,
				),
				'topbar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer width', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'gigas-addon'),
					'description' => esc_html__( 'Adds a vertical bar (|) between elements to visually separate them.', 'gigas-addon' ),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'topbar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'topbar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'topbar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'topbar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description'   => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'topbar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description'   => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'gigas-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','gigas-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'gigas-addon' ),
						),
						array(
							'id'	=> 'signin-register-text',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'gigas-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'gigas-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'left' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'gigas-addon' ),
				),
				'center' => array(
				),
				'right' => array(
				),
				'disabled' => array(
					'search' 		        => esc_html__( 'Search', 'gigas-addon' ),
					'social'	 			=> esc_html__( 'Social', 'gigas-addon' ),
					'address' 				=> esc_html__( 'Address', 'gigas-addon' ),
					'email' 				=> esc_html__( 'Email', 'gigas-addon' ),
					'signin' 	    		=> esc_html__( 'Signin/Register', 'gigas-addon' ),
					'custom-text-2'  => esc_html__( 'Custom Text 2', 'gigas-addon' ),
					'top-menu' 				=> esc_html__( 'Top Menu', 'gigas-addon' ),
					'topbar-spacer-1' 		=> esc_html__( 'Spacer 1', 'gigas-addon' ),
					'topbar-spacer-2'		=> esc_html__( 'Spacer 2', 'gigas-addon' ),
					'topbar-spacer-3'		=> esc_html__( 'Spacer 3', 'gigas-addon' ),
					'topbar-html-1' 		=> esc_html__( 'HTML 1', 'gigas-addon' ),
					'topbar-html-2'			=> esc_html__( 'HTML 2', 'gigas-addon' ),
					'topbar-html-3' 		=> esc_html__( 'HTML 3', 'gigas-addon' ),
					'topbar-html-4' 		=> esc_html__( 'HTML 4', 'gigas-addon' ),
					'topbar-html-5' 		=> esc_html__( 'HTML 5', 'gigas-addon' ),
					'topbar_delimiter1' 	=> esc_html__('|', 'gigas-addon'),
					'topbar_delimiter2' 	=> esc_html__('|', 'gigas-addon'),
					'topbar_delimiter3' 	=> esc_html__('|', 'gigas-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'gigas-addon'),
				), 
			),
		),
		array(
			'id'			=> 'header-logobar-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Middle Settings', 'gigas-addon' ),
			'description'   => esc_html__( 'Arrange and customize the elements in the header middle section using a drag-and-drop interface.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'custom_class'	=> 'header-logobar-settings',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'header-logobar-height',
					'type'			=> 'hw',
					'title'			=> esc_html__( 'Header Middle Height', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the height of the middle header section (in pixels).', 'gigas-addon' ),
					'only_dimension' => 'height'
				),
				array(
					'id'			=> 'header-logobar-sticky-height',
					'type'			=> 'hw',
					'title'			=> esc_html__( 'Header Middle Sticky Height', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the height of the middle header when it is in sticky or fixed mode.', 'gigas-addon' ),
					'only_dimension' => 'height'
				),		
				array(
					'id'			=> 'header-logobar-links-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Header Middle Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the text color for hyperlinks in the header middle section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-logobar-background',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Header Middle Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the header middle section, including color, image, size, etc.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-logobar-border',
					'type'			=> 'border',
					'title'			=> esc_html__( 'Header Middle Border', 'gigas-addon' ),
					'description'	=> esc_html__( 'Configure and Customize the border style for the header middle section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-logobar-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header Middle padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the header middle section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-logobar-margin',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header Middle margin', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the header middle section.', 'gigas-addon' ),
					'default'		=> ''
				),
			),
		),
		array(
			'id'            => 'logobar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__( 'Custom Text 1 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar-custom-text-1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Logobar Custom Text 1', 'gigas-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the logo bar of the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'logobar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Logobar Custom Text 2', 'gigas-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the logo bar of the site.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'logobar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    		=> 'logobar_html_1',
							'type'  		=> 'textarea',
							'title' 		=> esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'logobar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' => esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'logobar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'gigas-addon'),
							'description' => esc_html( 'Set the spacer width to control layout spacing.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'logobar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'logobar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'logobar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'logobar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'logobar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'gigas-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','gigas-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'gigas-addon' ),
						),
						array(
							'id'	=> 'signin-register-text',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'gigas-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'gigas-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'right' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'gigas-addon' ),
				),
				'center' => array(
				),
				'left' => array(
				),
				'disabled' => array(
					'logo' 					=> esc_html__( 'Logo', 'gigas-addon' ),
					'search'				=> esc_html__( 'Search', 'gigas-addon' ),
					'social'	 			=> esc_html__( 'Social', 'gigas-addon' ),
					'address' 				=> esc_html__( 'Address', 'gigas-addon' ),
					'email' 				=> esc_html__( 'Email', 'gigas-addon' ),
					'secondary-bar' 		=> esc_html__( 'Secondary Bar', 'gigas-addon' ),
					'signin' 				=> esc_html__( 'Signin/Register', 'gigas-addon' ),
					'custom-text-2'			=> esc_html__( 'Custom Text 2', 'gigas-addon' ),
					'primary-menu' 			=> esc_html__( 'Primary Menu', 'gigas-addon' ),
					'logobar-spacer-1' 		=> esc_html__( 'Spacer 1', 'gigas-addon' ),
					'logobar-spacer-2'		=> esc_html__( 'Spacer 2', 'gigas-addon' ),
					'logobar-spacer-3'		=> esc_html__( 'Spacer 3', 'gigas-addon' ),
					'logobar-html-1' 		=> esc_html__( 'HTML 1', 'gigas-addon' ),
					'logobar-html-2'		=> esc_html__( 'HTML 2', 'gigas-addon' ),
					'logobar-html-3' 		=> esc_html__( 'HTML 3', 'gigas-addon' ),
					'logobar-html-4' 		=> esc_html__( 'HTML 4', 'gigas-addon' ),
					'logobar-html-5' 		=> esc_html__( 'HTML 5', 'gigas-addon' ),
					'logobar_delimiter1' 	=> esc_html__( '|', 'gigas-addon'),
					'logobar_delimiter2' 	=> esc_html__( '|', 'gigas-addon'),
					'logobar_delimiter3' 	=> esc_html__( '|', 'gigas-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'gigas-addon'),
				),
			),
		),
		array(
			'id'			=> 'header-navbar-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Bottom Settings', 'gigas-addon' ),
			'description'   => esc_html__( 'Arrange and customize the elements in the header bottom section using a drag-and-drop interface.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'custom_class'	=> 'header-navbar-settings',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'header-navbar-height',
					'type'			=> 'hw',
					'title'			=> esc_html__( 'Header Bottom Height', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the height of the bottom header section (in pixels).', 'gigas-addon' ),
					'only_dimension' => 'height'
				),
				array(
					'id'			=> 'header-navbar-sticky-height',
					'type'			=> 'hw',
					'title'			=> esc_html__( 'Header Bottom Sticky Height', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the height of the bottom header when it is in sticky or fixed mode.', 'gigas-addon' ),
					'only_dimension' => 'height'
				),		
				array(
					'id'			=> 'header-navbar-links-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Header Bottom Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the text color for hyperlinks in the header bottom section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-navbar-background',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Header Bottom Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the header bottom section, including color, image, size, etc.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-navbar-border',
					'type'			=> 'border',
					'title'			=> esc_html__( 'Header Bottom Border', 'gigas-addon' ),
					'description'	=> esc_html__( 'Configure and Customize the border style for the header bottom section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-navbar-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header Bottom padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the header bottom section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'header-navbar-margin',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Header Bottom margin', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the header bottom section.', 'gigas-addon' ),
					'default'		=> ''
				),
			),
		),
		array(
			'id'            => 'navbar-items',
			'type'          => 'dragdrop-editor',
			'items'         => array(
				'custom-text-1' => array(
					'title'       => esc_html__('Custom Text 1 Editor', 'gigas-addon'),
					'fields'      => array(
						array(
							'id'    => 'navbar-custom-text-1',
							'type'  => 'textarea',
							'title' => esc_html__('Navbar Custom Text 1', 'gigas-addon'),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the nav bar of the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'custom-text-2' => array(
					'title'       => esc_html__( 'Custom Text 2 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'navbar-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Navbar Custom Text 2', 'gigas-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the nav bar of the site.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable' => true,
				),
				'navbar-html-1' => array(
					'title'       => esc_html__( 'Html 1 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-2' => array(
					'title'       => esc_html__( 'Html 2 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-3' => array(
					'title'       => esc_html__( 'Html 3 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-4' => array(
					'title'       => esc_html__( 'Html 4 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_4',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-html-5' => array(
					'title'       => esc_html__( 'Html 5 Editor', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'navbar_html_5',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable' => true,
				),
				'navbar-spacer-1' => array(
					'title'		 => esc_html__( 'Spacer 1 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'gigas-addon'),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar-spacer-2' => array(
					'title'		 => esc_html__( 'Spacer 2 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar-spacer-3' => array(
					'title'		 => esc_html__( 'Spacer 3 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_spacer_3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Spacer Width', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '40' )
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'navbar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3 Editor', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'navbar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'navbar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'navbar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'navbar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable' => true,
				),
				'signin'	=> array(
					'title'		=> esc_html__( 'Sign in/register', 'gigas-addon' ),
					'fields'	=> array(
						array(
							'id'	=> 'signin-register',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Enter Your shortcode','gigas-addon' ),
							'description'	=> esc_html__( 'Enter your login/ register shortcode here. Example: [contact-form-7 id="5ecf846" title="Event"].', 'gigas-addon' ),
						),
						array(
							'id'	=> 'signin-register-text',
							'type'	=> 'text',
							'title'	=> esc_html__( 'Sign in/Register Text', 'gigas-addon' ),
							'description'	=> esc_html__( 'Enter the text displayed for the login/register option on the site. Example: Login or Register.', 'gigas-addon' ),
						)
					),
					'editable' => true,
				),
			),
			'default'       => array(
				'left' => array(
					'custom-text-1' => esc_html__( 'Custom Text 1', 'gigas-addon' ),
				),
				'center' => array(
				),
				'right' => array(
				),
				'disabled' => array(
					'logo' => esc_html__( 'Logo', 'gigas-addon' ),
					'search' => esc_html__( 'Search', 'gigas-addon' ),
					'social'	 	=> esc_html__( 'Social', 'gigas-addon' ),
					'address' 		=> esc_html__( 'Address', 'gigas-addon' ),
					'email' 		=> esc_html__( 'Email', 'gigas-addon' ),
					'secondary-bar' => esc_html__( 'Secondary Bar', 'gigas-addon' ),
					'signin' 		=> esc_html__( 'Signin/Register', 'gigas-addon' ),
					'custom-text-2' => esc_html__( 'Custom Text 2', 'gigas-addon' ),
					'primary-menu' 			=> esc_html__( 'Primary Menu', 'gigas-addon' ),
					'navbar-spacer-1' 		=> esc_html__( 'Spacer 1', 'gigas-addon' ),
					'navbar-spacer-2'		=> esc_html__( 'Spacer 2', 'gigas-addon' ),
					'navbar-spacer-3'		=> esc_html__( 'Spacer 3', 'gigas-addon' ),
					'navbar-html-1' 		=> esc_html__( 'HTML 1', 'gigas-addon' ),
					'navbar-html-2'			=> esc_html__( 'HTML 2', 'gigas-addon' ),
					'navbar-html-3' 		=> esc_html__( 'HTML 3', 'gigas-addon' ),
					'navbar-html-4' 		=> esc_html__( 'HTML 4', 'gigas-addon' ),
					'navbar-html-5' 		=> esc_html__( 'HTML 5', 'gigas-addon' ),
					'navbar_delimiter1' 	=> esc_html__('|', 'gigas-addon'),
					'navbar_delimiter2' 	=> esc_html__('|', 'gigas-addon'),
					'navbar_delimiter3' 	=> esc_html__('|', 'gigas-addon'),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'gigas-addon'),
				),
			),
		),
	),
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Header Sticky Styles', 'gigas-addon' ),
	'id'         => 'header-sticky',
	'config_id'  => 'customizer_settings_header',
	'fields'	 => array(
		array(
			'id'			=> 'header-sticky-general',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Sticky', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Cuztomize all type of control for header top sticky styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-sticky',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Choose Header Sticky/Fixed', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select whether the header remains sticky (appears after scrolling) or fixed (always visible at the top).', 'gigas-addon' ),
			'choices'		=> array(
				'normal'		=> esc_html__( 'While Scroll', 'gigas-addon' ),
				'on_scrollup'	=> esc_html__( 'On Scroll Up', 'gigas-addon' )
			),
			'default'		=> 'normal'
		),
		array(
			'id'			=> 'header-topbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Top Sticky Styles', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all the type of header top sticky styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-topbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Topbar Sticky Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the text color for hyperlinks in the header topbar on sticky.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'header-topbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Topbar Sticky Background Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Configure the background color or image for the header top bar when it is in sticky mode.', 'gigas-addon' ),
			'default'		=> ''
		),	
		array(
			'id'			=> 'header-logobar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Middle Sticky/Fixed Styles', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can set all the type of Header Middle sticky styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-logobar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Middle Sticky/Fixed Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the text color for hyperlinks in the header middle on sticky.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'header-logobar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Middle Sticky/Fixed Background Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'Configure the background color or image for the header middle when it is in sticky mode.', 'gigas-addon' ),
			'default'		=> ''
		),		
		array(
			'id'			=> 'header-navbar-sticky-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Header Bottom Sticky/Fixed Styles', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all the type of Header Bottom sticky styles.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'header-navbar-sticky-links-color',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Header Bottom Sticky/Fixed Link Color', 'gigas-addon' ),
			'description'	=> esc_html__( 'Set the text color for hyperlinks in the header bottom on sticky.', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'header-navbar-sticky-background',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Header Bottom Sticky/Fixed Background', 'gigas-addon' ),
			'description'	=> esc_html__( 'Configure the background color or image for the header bottom when it is in sticky mode.', 'gigas-addon' ),
			'default'		=> ''
		),	
		
	)
) );
Gigas_Options::gigas_set_sub_section( array(
    'title'      => esc_html__( 'Mobile Header', 'gigas-addon' ),
    'id'         => 'header-mobileheader',
	'config_id'  => 'customizer_settings_header',
    'fields'     => array(
		array(
			'id'			 => 'mobilebar-header',
            'type'			 => 'label',
            'title'			 => esc_html__( 'Mobile Header', 'gigas-addon' ),
            'desc'	 => esc_html__( 'This is settings for site page loader. If you have did not uploaded means default page loader will work.', 'gigas-addon' ),
            'seperator'		 => 'after',
			'show_edit_icon' => true,
			'fields'		 => array(
				array(
					'id'            => 'mobilebar-responsive',
					'type'          => 'number',
					'title'         => esc_html__( 'Mobile Bar From', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the width from which the Mobile Bar should be appear. Example 767', 'gigas-addon' ),
					'default'       => '767'
				),
				array(
					'id'            => 'mobilebar-sticky',
					'type'          => 'select',
					'title'         => esc_html__( 'Choose Mobile Bar Sticky', 'gigas-addon' ),
					'description'   => esc_html__( 'Select the sticky on or off to fixed at the top while scrolling.', 'gigas-addon' ),
					'choices'       => array(
						'off'       => 'Off',
						'on'        => 'On',
						'on_scrollup' => 'On Scroll Up'
					),
					'default'       => 'off'
				),
				array(
					'id'            => 'mobilebar-height',
					'type'          => 'number',
					'title'         => esc_html__( 'Mobilebar Height ', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the height of the mobile bar for optimal visibility and usability. Example 767', 'gigas-addon' ),
					'default'       => '100'
				),
				array(
					'id'            => 'header-mobilebar-color',
					'type'          => 'color',
					'title'         => esc_html__( 'Header Mobilebar Background Color', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the background color of the mobile bar in the header. Selected color will work in few places of the website. you can update to leave it as empty.', 'gigas-addon' ),
					'alpha'         => false,
					'default'       => '#000'
				),
				array(
					'id'            => 'header-mobilebar-item-color',
					'type'          => 'color',
					'title'         => esc_html__( 'Header Mobilebar Items Color', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the color of the mobile bar items in the header. Selected color will work in few places of the website. you can update to leave it as empty.', 'gigas-addon' ),
					'alpha'         => false,
					'default'       => '#939393'
				),
			),
		),
        array(
            'id'            => 'mobilebar-items',
            'type'          => 'dragdrop-editor',
            'title'         => esc_html__( 'Mobile Header Items', 'gigas-addon' ),
            'description'   => esc_html__( 'Arrange and customize the elements in the mobile header section using a drag-and-drop interface.', 'gigas-addon' ),
			'items'			=> array(
				'mobile-icons-fields'	=> array(
					'title'       => esc_html__( 'Mobile Icon', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'mobile-phone-icons',
							'title'	=> esc_html__( 'Mobile Phone Icon', 'gigas-addon' ),
							'description' => esc_html__( 'Add a html class for the Mobile Icon. Example :<i class="bi bi-telephone-fill"></i>.', 'gigas-addon' ),
							'type'  => 'text',
						),
						array(
							'id'	=> 'mobile-number',
							'title' => esc_html__( 'Mobile Number ', 'gigas-addon' ),
							'description'	=> esc_html__( 'Enter Mobile Number for displaying in mobile header for quick contact.', 'gigas-addon'),
							'type'	=> 'text'
						),
					),
					'editable'	=> true
				),
				'mobile-icon-email'	=> array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'      => 'mobile-email-icons',
							'title'   => esc_html__( 'Mobile Email Icon', 'gigas-addon' ),
							'description' => esc_html__( 'Add a html class for the Mail icon. Example: <i class="bi bi-envelope-fill"></i>.', 'gigas-addon' ),
							'type' 	  => 'text',
						),
						array(
							'id'			=> 'email-address',
							'title' 		=> esc_html__( 'Email Address', 'gigas-addon' ),
							'description'	=> esc_html__( 'Enter Email Address for displaying in mobile header for quick contact.', 'gigas-addon'),
							'type'			=> 'text'
						),
					),
					'editable'	=> true
				),
				'mobile-menu-custom-text-1'  => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobile-menu-custom-text-1',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 1', 'gigas-addon' ),
							'description'	=> esc_html__( 'Add the first custom text field displayed in the mobile menu.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'mobile-menu-custom-text-2'  => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobile-menu-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 2', 'gigas-addon' ),
							'description'	=> esc_html__( 'Add the second custom text field displayed in the mobile menu.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'mobilebar-spacer-1' 	=> array(
					'title'			=> esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobilebar-spacer-1',
							'type'		=> 'number',
							'title'		=> esc_html__( 'Spacer 1', 'gigas-addon'),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'default'       => '40'
						),
					),
					'editable'	=> true
				),
				'mobilebar-spacer-2' 	=> array(
					'title'			=> esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobilebar-spacer-2',
							'type'          => 'number',
							'title'         => esc_html__( 'Spacer 2', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'default'       => '40'
						),
					),
					'editable'	=> true
				),
				'mobilebar-spacer-3' 	=> array(
					'title'			=> esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobilebar-spacer-3',
							'type'          => 'number',
							'title'         => esc_html__( 'Spacer 3', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'default'       => '40'
						),
					),
					'editable'	=> true
				),
				'mobilebar-html-1' => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'mobilebar-html-1',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable'	=> true
				),
				'mobilebar-html-2' => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'mobilebar-html-2',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable'	=> true
				),
				'mobilebar-html-3' => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'mobilebar-html-3',
							'type'  => 'textarea',
							'title' => esc_html__( 'Html Code', 'gigas-addon' ),
							'description' 	=> esc_html__( 'Add custom HTML code to insert content, scripts, or custom elements into the site.', 'gigas-addon' ),
						),
					),
					'editable'	=> true
				),
				'mobilebar_delimiter1' => array(
					'title'		 => esc_html__( 'Delimiter 1', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'mobilebar_delimiter1_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the horizontal bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'mobilebar_delimiter1_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'mobilebar_delimiter1_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobilebar_delimiter1_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable'	=> true
				),
				'mobilebar_delimiter2' => array(
					'title'		 => esc_html__( 'Delimiter 2', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'mobilebar_delimiter2_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the horizontal bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'mobilebar_delimiter2_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'mobilebar_delimiter2_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobilebar_delimiter2_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable'	=> true
				),
				'mobilebar_delimiter3' => array(
					'title'		 => esc_html__( 'Delimiter 3', 'gigas-addon'),
					'fields'	 => array( 
						array(
							'id'		=> 'mobilebar_delimiter3_width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the horizontal bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '1' )
						),
						array(
							'id'		=> 'mobilebar_delimiter3_height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '100' )
						),
						array( 
							'id'			=> 'mobilebar_delimiter3_color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobilebar_delimiter3_margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),	
					'editable'	=> true
				),
			),
            'default'       => array(
                'left' => array(
                    'menu-toggle' => esc_html__( 'Mobile Menu Trigger', 'gigas-addon' ),                    
                ),
                'center' => array(        
                    'logo' => esc_html__( 'Logo', 'gigas-addon' ),
                ),
                'right' => array(    
                    'search' => esc_html__( 'Search Trigger', 'gigas-addon' ),
                ),
                'disabled' => array(
                	'mobile-menu-custom-text-1' => esc_html__( 'Mobile menu Custom Text 1', 'gigas-addon' ),
					'mobile-menu-custom-text-2' => esc_html__( 'Mobile menu Custom Text 2', 'gigas-addon' ),
					'mobile-icons-fields'				=> esc_html__( 'Mobile Phone Number', 'gigas-addon' ),
					'mobilebar-spacer-1'		=> esc_html__( 'Spacer 1', 'gigas-addon' ),
					'mobilebar-spacer-2'		=> esc_html__( 'Spacer 2', 'gigas-addon' ),
					'mobilebar-spacer-3'		=> esc_html__( 'Spacer 3', 'gigas-addon' ),
					'mobilebar-html-1' 			=> esc_html__( 'HTML 1', 'gigas-addon' ),
					'mobilebar-html-2'			=> esc_html__( 'HTML 2', 'gigas-addon' ),
					'mobilebar-html-3' 			=> esc_html__( 'HTML 3', 'gigas-addon' ),
					'mobilebar_delimiter1' 		=> esc_html__('|', 'gigas-addon'),
					'mobilebar_delimiter2' 		=> esc_html__('|', 'gigas-addon'),
					'mobilebar_delimiter3' 		=> esc_html__('|', 'gigas-addon'),
					'mobile-icon-email'			=> esc_html__( 'Mobile Email','gigas-addon' ),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'gigas-addon'),
                )
			),
        ),
		array(
			'id'			 => 'mobilebar-menu-header',
            'type'			 => 'label',
            'title'			 => esc_html__( 'Mobile Menu Items Settings', 'gigas-addon' ),
            'desc'	 => esc_html__( 'This is settings for site page loader. If you have did not uploaded means default page loader will work.', 'gigas-addon' ),
            'seperator'		 => 'after',
			'show_edit_icon' => true,
			'fields'		 => array(
				array(
					'id'            => 'mobile-menu-color',
					'type'          => 'color',
					'title'         => esc_html__( 'Mobile Menu Background Color', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the background color for the Mobile Menu. Selected color will work in few places of the website. you can update to leave it as empty.', 'gigas-addon' ),
					'alpha'         => false,
					'default'       => '#fff'
				),
				array(
					'id'            => 'mobile-menu-item-color',
					'type'          => 'color',
					'title'         => esc_html__( 'Mobile Menu Items Color', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the color for the Mobile Menu Items. Selected color will work in few places of the website. you can update to leave it as empty.', 'gigas-addon' ),
					'alpha'         => false,
					'default'       => '#000'
				),
				array(
					'id'            => 'mobile-sidebar-width',
					'type'          => 'hw',
					'title'         => esc_html__( 'Mobile Menu Maximum Width', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the maximum width of the logo. If you want the original width, leave this field empty.', 'gigas-addon' ),
					'only_dimension' => 'width',
					'default'		=> array( 'width' => '300' )
				),
			),
		),
        array(
            'id'            => 'mobilebar-menu-items',
            'type'          => 'dragdrop-editor',
            'title'         => esc_html__( 'Mobile Menu Part Items', 'gigas-addon' ),
            'description'   => esc_html__( 'Arrange and customize the elements in the mobile menu part section using a drag-and-drop interface.', 'gigas-addon' ),
			'items'			=> array(
				'mobile-menu-custom-text-1'  => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobile-menu-custom-text-1',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 1', 'gigas-addon' ),
							'description'   => esc_html__( 'Add the second custom text field displayed in the mobile menu.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'mobile-menu-custom-text-2'  => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'mobile-menu-custom-text-2',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Mobile menu Custom Text 2', 'gigas-addon' ),
							'description'   => esc_html__( 'Add the second custom text field displayed in the mobile menu.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'spacer-mobile-1'    		=> array(
					'title'			=> esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobile-spacer-1',
							'type'		=> 'number',
							'title'		=> esc_html__( 'Spacer 1', 'gigas-addon'),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'default'       => '40'
						),
					),
					'editable'	=> true
				),
				'spacer-mobile-2'    		=> array(
					'title'			=> esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobile-spacer-2',
							'type'          => 'number',
							'title'         => esc_html__( 'Spacer 2', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'default'       => '40'
						),
					),
					'editable'	=> true
				),
				'spacer-mobile-3'    		=> array(
					'title'			=> esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'		=>  array(
						array(
							'id'		=> 'mobile-spacer-3',
							'type'          => 'number',
							'title'         => esc_html__( 'Spacer 3', 'gigas-addon' ),
							'description' => esc_html__( 'Adjust this value to control the amount of empty space between elements.', 'gigas-addon' ),
							'default'       => '40'
						),
					),
					'editable'	=> true
				),
				'delimiter-mobile-1'         => array(
					'title'			=> esc_html__( 'Delimiter 1', 'gigas-addon'),
					'fields'		=> array( 
						array(
							'id'		=> 'mobile-delimiter-1-width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '100' )
						),
						array(
							'id'		=> 'mobile-delimiter-1-height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '1' )
						),
						array( 
							'id'			=> 'mobile-delimiter-1-color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobile-delimiter-1-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'delimiter-mobile-2'         => array(
					'title'			=> esc_html__( 'Delimiter 2', 'gigas-addon'),
					'fields'		=> array( 
						array(
							'id'		=> 'mobile-delimiter-2-width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '100' )
						),
						array(
							'id'		=> 'mobile-delimiter-2-height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '1' )
						),
						array( 
							'id'			=> 'mobile-delimiter-2-color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobile-delimiter-2-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'delimiter-mobile-3'         => array(
					'title'			=> esc_html__( 'Delimiter 3', 'gigas-addon'),
					'fields'		=> array( 
						array(
							'id'		=> 'mobile-delimiter-3-width',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Width', 'gigas-addon'),
							'description' => esc_html__( 'Defines the thickness of the vertical bar (|) separator.', 'gigas-addon' ),
							'only_dimension' => 'width',
							'default' 	=> array( 'width' => '100' )
						),
						array(
							'id'		=> 'mobile-delimiter-3-height',
							'type'		=> 'hw',
							'title'		=> esc_html__( 'Height', 'gigas-addon'),
							'description' => esc_html__( 'Sets the vertical size of the delimiter (|) to control its length.', 'gigas-addon' ),
							'only_dimension' => 'height',
							'default' 	=> array( 'height' => '1' )
						),
						array( 
							'id'			=> 'mobile-delimiter-3-color',
							'type'			=> 'color',
							'title'			=> esc_html__( 'Color', 'gigas-addon' ),
							'description' => esc_html__( 'Set the color of the Delimiter.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'mobile-delimiter-3-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Margin', 'gigas-addon' ),
							'description' => esc_html__( 'Controls the spacing around the delimiter (|).', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
			),
            'default'       => array(
                'enabled' => array(                    
                    'logo' => esc_html__( 'Logo', 'gigas-addon' ),
                    'menu' => esc_html__( 'Mobile Menu', 'gigas-addon' )
                ),
                'disabled' => array(
                    'search' => esc_html__( 'Search', 'gigas-addon' ),
                    'social' => esc_html__( 'Social Links', 'gigas-addon' ),
                    'mobile-menu-custom-text-1' => esc_html__( 'Mobile menu Custom Text 1', 'gigas-addon' ),
                    'mobile-menu-custom-text-2' => esc_html__( 'Mobile menu Custom Text 2', 'gigas-addon' ),
					'wpml_polylang'			=> esc_html__( 'WPML/Polylang', 'gigas-addon'),
					'spacer-mobile-1'		=> esc_html__( 'Spacer 1', 'gigas-addon' ),
					'spacer-mobile-2'		=> esc_html__( 'Spacer 2', 'gigas-addon' ),
					'spacer-mobile-3'		=> esc_html__( 'Spacer 3', 'gigas-addon' ),
					'delimiter-mobile-1'	=> esc_html__('_', 'gigas-addon'),
					'delimiter-mobile-2'	=> esc_html__('_', 'gigas-addon'),
					'delimiter-mobile-3'	=> esc_html__('_', 'gigas-addon'),
                )
            )
        ),
    )
) );

Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'header-tab-end'	
));

// Footer
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Site Footer', 'gigas-addon' ),
	'id'         => 'footer-tab',
	'config_id'  => 'customizer_settings_footer',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'General', 'gigas-addon' ),
	'id'         => 'footer-general',
	'config_id'  => 'customizer_settings_footer',
	'fields'	 => array(
		array(
			'id'			=> 'footer-settings-label',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Footer Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can add Footer setting in below.', 'gigas-addon' ),
			'seperator'		=> 'before'
		),
		array(
			'id'			=> 'footer-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Footer Layout', 'gigas-addon' ),
			'description'   => wp_kses_post('Choose the structure and design of footer layout such as wide or boxed <a href="widgets.php" style="text-decoration:none;">view footer widgets.</a>', 'gigas-addon'),
			'items'		=> array(
				'wide' => array(
					'title' => esc_html__( 'Wide', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
				),
				'boxed' => array(
					'title' => esc_html__( 'Boxed', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
				)
			),
			'default' => 'wide'
		),
		array(
			'id'			=> 'footer-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Footer Settings', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'footer-links-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Footer Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the text color for hyperlinks in the footer section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'footer-background',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Footer Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the footer section, including color, image, size, etc.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'footer-border',
					'type'			=> 'border',
					'title'			=> esc_html__( 'Footer Border', 'gigas-addon' ),
					'description'	=> esc_html__( 'Configure and Customize the border style for the footer section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'footer-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Footer padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the footer section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'footer-margin',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Footer margin', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the footer section.', 'gigas-addon' ),
					'default'		=> ''
				),
			),
		),
		array(
			'id'			=> 'footer-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Footer Items', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the footer section using a drag-and-drop interface.', 'gigas-addon' ),			
			'items'			=> array(
				'footer-top'  => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => 		array(
						array(
						'id'			=> 'insta-footer-layout',
						'type'			=> 'radioimage',
						'title'			=> esc_html__( 'Footer Top Layout', 'gigas-addon' ),
						'description'	=> wp_kses_post('Select the structure and design of the Footer Top section such as wide or boxed.<a href="widgets.php"> View Footer widgets.</a>', 'gigas-addon'),
						'items'		=> array(
							'wide' => array(
								'title' => esc_html__( 'Wide', 'gigas-addon' ),
								'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
							),
							'boxed' => array(
								'title' => esc_html__( 'Boxed', 'gigas-addon' ),
								'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
							)
						),
						'default' => 'wide'
						),
						array(
							'id'			=> 'insta-footer-links-color',
							'type'			=> 'link',
							'title'			=> esc_html__( 'Footer Top Link Color', 'gigas-addon' ),
							'description'	=> esc_html__( 'Set the text color for hyperlinks in the footer top section.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'insta-footer-background',
							'type'			=> 'background',
							'title'			=> esc_html__( 'Footer Top Background Options', 'gigas-addon' ),
							'description'	=> esc_html__( 'Choose background settings for the footer top section, including color, image, size, etc..', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'insta-footer-border',
							'type'			=> 'border',
							'title'			=> esc_html__( 'Footer Top Border', 'gigas-addon' ),
							'description'	=> esc_html__( 'Configure and Customize the border style for the footer top section.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'insta-footer-padding',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Footer Top Padding', 'gigas-addon' ),
							'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the footer top section.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'insta-footer-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Footer Top Margin', 'gigas-addon' ),
							'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the footer top section.', 'gigas-addon' ),
							'default'		=> ''
						),		
					),
					'editable'	=> true
				),
				'footer-middle'		=> array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'			=> 'widgets-footer-layout',
							'type'			=> 'radioimage',
							'title'			=> esc_html__( 'Widgets Footer Layout', 'gigas-addon' ),
							'description'   => wp_kses_post('Select the widgets footer layout such as wide or boxed for widget areas in the footer <a href="widgets.php" style="text-decoration:none;"> view footer widgets.</a>', 'gigas-addon'),
							'items'		=> array(
								'wide' => array(
									'title' => esc_html__( 'Wide', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
								),
								'boxed' => array(
									'title' => esc_html__( 'Boxed', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
								)
							),
							'default' => 'boxed'
						),
						array(
							'id'			=> 'footer-widgets-layout',
							'type'			=> 'radioimage',
							'title'			=> esc_html__( 'Footer Widgets Layout', 'gigas-addon' ),
							'description'	=> esc_html__( 'Select the column layout for widget areas in the footer.', 'gigas-addon' ),
							'items'		=> array(
								'3-3-3-3' => array(
									'title' => esc_html__( 'Column 3/3/3/3', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-3-3.png'
								),
								'3-3-6' => array(
									'title' => esc_html__( 'Column 3/3/6', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-3-3-6.png'
								),
								'12' => array(
									'title' => esc_html__( 'Column 12', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-12.png'
								),
								'4-4-4' => array(
									'title' => esc_html__( 'Column 4/4/4', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-4-4.png'
								),
								'4-8' => array(
									'title' => esc_html__( 'Column4/8', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-4-8.png'
								),
								'6-3-3' => array(
									'title' => esc_html__( 'Column 6/3/3', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-6-3-3.png'
								),
								'8-4' => array(
									'title' => esc_html__( 'Column 8/4', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/widget-8-4.png'
								)
							),
							'default' => '12'
						),
						array(
							'id'			=> 'footer-widget-1',
							'type'			=> 'sidebars',
							'title'			=> esc_html__( 'Footer Widgets Area 1', 'gigas-addon' ),
							'description'	=> esc_html__( 'Choose widget for the first section of the footer widget area.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'footer-widget-2',
							'type'			=> 'sidebars',
							'title'			=> esc_html__( 'Footer Widgets Area 2', 'gigas-addon' ),
							'description'	=> esc_html__( 'Choose widget for the second section of the footer widget area.', 'gigas-addon' ),
							'default'		=> '',
							'required'		=> array( 'footer-widgets-layout', '!=', array( '12' ) )
						),
						array(
							'id'			=> 'footer-widget-3',
							'type'			=> 'sidebars',
							'title'			=> esc_html__( 'Footer Widgets Area 3', 'gigas-addon' ),
							'description'	=> esc_html__( 'Choose widget for the third section of the footer widget area.', 'gigas-addon' ),
							'default'		=> '',
							'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3', '3-3-6', '4-4-4', '6-3-3' ) )
						),
						array(
							'id'			=> 'footer-widget-4',
							'type'			=> 'sidebars',
							'title'			=> esc_html__( 'Footer Widgets Area 4', 'gigas-addon' ),
							'description'	=> esc_html__( 'Choose widget for the fourth section of the footer widget area.', 'gigas-addon' ),
							'default'		=> '',
							'required'		=> array( 'footer-widgets-layout', '=', array( '3-3-3-3' ) )
						),
						array(
							'id'			=> 'footer-widgets-links-color',
							'type'			=> 'link',
							'title'			=> esc_html__( ' Footer Widgets Link Color', 'gigas-addon' ),
							'description'	=> esc_html__( 'Set the text color for hyperlinks in the footer widgets.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'footer-widgets-background',
							'type'			=> 'background',
							'title'			=> esc_html__( ' Footer Widgets Background Options', 'gigas-addon' ),
							'description'	=> esc_html__( 'Choose background settings for the footer widget area, including color, image, size, etc.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'footer-widgets-border',
							'type'			=> 'border',
							'title'			=> esc_html__( 'Footer Widgets Border', 'gigas-addon' ),
							'description'	=> esc_html__( 'Configure and Customize the border style for the footer widget area.', 'gigas-addon' ),
							'default'		=> ''
						), 
						array(
							'id'			=> 'footer-widgets-padding',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Footer Widgets padding', 'gigas-addon' ),
							'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the footer widget area.', 'gigas-addon' ),
							'default'		=> ''
						),
						array(
							'id'			=> 'footer-widgets-margin',
							'type'			=> 'dimension',
							'title'			=> esc_html__( 'Footer Widgets margin', 'gigas-addon' ),
							'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the footer widget area.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
				'footer-bottom'=> array(
					'title'		=> esc_html__( 'Copyrights section', 'gigas-addon'),
					'fields'		=> array(
						array(
							'id'			=> 'footer-bottom-layout',
							'type'			=> 'radioimage',
							'title'			=> esc_html__( 'Copyrights Layout', 'gigas-addon' ),
							'description'	=> esc_html__( 'Choose the structure and design of the copyright section in the footer such as wide or boxed.', 'gigas-addon' ),
							'items'		=> array(
								'wide' => array(
									'title' => esc_html__( 'Wide', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-wide.png'
								),
								'boxed' => array(
									'title' => esc_html__( 'Boxed', 'gigas-addon' ),
									'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/footer/footer-boxed.png'
								)
							),
							'default' => 'boxed'
						),
						array(
							'id'			=> 'copyright-widget',
							'type'			=> 'sidebars',
							'title'			=> esc_html__( 'Copyright Custom Widgets', 'gigas-addon' ),
							'description'	=> esc_html__( 'Select and add a custom widget for the copyright section.', 'gigas-addon' ),
							'default'		=> ''
						),
					),
					'editable'	=> true
				),
			),
			'default'		=> array(
				'enabled' => array(
					'footer-middle' => esc_html__( 'Footer Widgets', 'gigas-addon' ),
					'footer-bottom' => esc_html__( 'Copyright Section', 'gigas-addon' )
				),
				'disabled' => array(
					'footer-top' => esc_html__( 'Footer Top', 'gigas-addon' ),
				)
			)
		),
	)	
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Copyright Section', 'gigas-addon' ),
	'id'         => 'copyright-section',
	'config_id'  => 'customizer_settings_footer',
	'fields'	 => array(
		array(
			'id'			=> 'copyright-section-style-label-field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Copyrights Section', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can set all the type of copyright section styles.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'copyright-section-links-color',
					'type'			=> 'link',
					'title'			=> esc_html__( ' Copyright Section Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the text color for hyperlinks in the copyright section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'copyright-section-background',
					'type'			=> 'background',
					'title'			=> esc_html__( ' Copyright Section Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the copyright section, including color, image, size, etc.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'copyright-sections-border',
					'type'			=> 'border',
					'title'			=> esc_html__( 'Copyright Section Border', 'gigas-addon' ),
					'description'	=> esc_html__( 'Configure and Customize the border style for the copyright section.', 'gigas-addon' ),
					'default'		=> ''
				), 
				array(
					'id'			=> 'copyright-section-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Copyright Section padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the copyright section.', 'gigas-addon' ),
					'default'		=> ''
				),
				array(
					'id'			=> 'copyright-section-margin',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Copyright Section', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the margin (outer spacing) around the copyright section.', 'gigas-addon' ),
					'default'		=> ''
				),
			),
		),
		array(
			'id'			=> 'copyright-bar-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Copyright Bar Items', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the copyright section using a drag-and-drop interface.', 'gigas-addon' ),
			'items'			=> array(
				'copyright-text' => array(
					'title'       => esc_html__( 'Copyright Text', 'gigas-addon' ),
					'fields'      => array(
						array(
							'id'    => 'copyright-text',
							'type'  => 'textarea',
							'title' => esc_html__( 'Copyrights Text', 'gigas-addon' ),
							'description' => esc_html__( 'Add the text to be displayed in the Copyright Section.', 'gigas-addon' ),
						),
					),
					'editable'		=> true
				)
			),
			'default'		=> array(
				'left' => array(
					
				),
				'center' => array(	
					'copyright-text' => esc_html__( 'Copyright Text', 'gigas-addon' )
				),
				'right' => array(					
				),
				'disabled' => array(
					'copyright-widgets' => esc_html__( 'Custom Widgets', 'gigas-addon' )
				)
			)
		),

	)	
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'footer-tab-end'	
));

//Templates Fields
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Templates', 'gigas-addon' ),
	'id'         => 'templates',
	'config_id'  => 'customizer_settings_theme_template',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Blog Posts', 'gigas-addon' ),
	'id'         => 'blog-tab',
	'config_id'  => 'customizer_settings_theme_template',
	'fields'	 => array(
		array(
			'id'			=> 'blog-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Blog Page Title Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for blog page title.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'blog-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Blog Page.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id' 			=> 'blog-layout',
			'type'  		=> 'select',
			'title' 		=> esc_html__('Blog Layout', 'gigas-addon'),
			'description'   => esc_html__( 'Choose the structure and design of the blog page, such as grid, list, or masonry layout.', 'gigas-addon'),
			'choices' 		=> array(
					'standard' 	=> esc_html__( 'Standard', 'gigas-addon'),
					'grid' 		=> esc_html__( 'Grid', 'gigas-addon'),
					'list' 		=> esc_html__( 'List', 'gigas-addon'),
			),
			'default' 		=> 'Standard'
		),
		array(
			'id' 			=> 'blog-grid-columns',
			'type' 			=> 'select',
			'title' 		=> esc_html__( 'Blog Data Columns', 'gigas-addon' ),
			'description'   => esc_html__( 'Select the number of columns to display blog posts in a grid layout.', 'gigas-addon' ),
			'choices' 		=> array(
						'2'   => esc_html__( '2 Columns', 'gigas-addon' ),
						'3'   => esc_html__( '3 Columns', 'gigas-addon' ),
						'4'   => esc_html__( '4 Columns', 'gigas-addons' ),
			),
			'required' => array( 'blog-layout', '=', array('grid'))
		),
		array(
			'id' 			=> 'blog-grid-gutter',
			'type' 			=> 'number',
			'title'	 		=> esc_html__( 'Blog Data Gutter', 'gigas-addon' ),
			'description'   => esc_html__( 'Adjust the gutter (spacing) between blog post columns.', 'gigas-addon' ),
			'default'		=> '30',
			'required' 		=> array( 'blog-layout', '=', array('grid'))
		),
		array(
			'id'			=> 'blog-layout-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Blog Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all header settings.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'blog-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Blog Page Title Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'This is color settings of blog page title.', 'gigas-addon' ),
					'required'		=> array( 'blog-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'blog-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Blog Description Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'This is color settings of blog page description.', 'gigas-addon' ),
					'required'		=> array( 'blog-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'blog-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Blog Title Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'This is link color setting for blog page title links. Like breadcrumbs color.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'blog-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'blog-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Blog Title Padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'This is padding for common blog title. Example 10 for all side', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'blog-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'blog-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Blog Page Title Background', 'gigas-addon' ),
					'description'	=> esc_html__( 'This is background settings of blog page title.', 'gigas-addon' ),
					'required'		=> array( 'blog-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'blog-title-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Blog Page Title Overlay Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the blog page title background. Choose light colors to make it displayed over the image.', 'gigas-addon' ),
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
			)
		),
		array(
			'id'			=> 'blog-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Blog Page Title Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Blog Title section using a drag-and-drop interface.', 'gigas-addon' ),
			'items'			=> array(
				'title'		=> array(
					'title'	=> esc_html__( 'Blog Title Editor Space', 'gigas-addon' ),
					'fields' => array(
						array(
							'id'			=> 'blog-page-title',
							'type'			=> 'text',
							'title'			=> esc_html__( 'Blog page Title', 'gigas-addon' ),
							'description'	=> esc_html__( 'Enter the Title to display in top of the Page.', 'gigas-addon' ),
							'default'		=> esc_html__( 'Latest Posts', 'gigas-addon' )
						),
					),
					'editable'	=> true
				),
				'description'	=> array(
					'title'	=> esc_html__( 'Blog Description Editor Space', 'gigas-addon' ),
					'fields'	=> array(
						array(
							'id'			=> 'blog-page-description',
							'type'			=> 'textarea',
							'title'			=> esc_html__( 'Blog page Description', 'gigas-addon' ),
							'description'	=> esc_html__( 'Enter a short description or tagline for the Blog Page.', 'gigas-addon' ),
							'default'		=> esc_html__( 'You become sound knowledge by our latest posts.', 'gigas-addon' )
						),
					),
					'editable'	=> true
				),
			),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'gigas-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'gigas-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'gigas-addon' )
				)
			),
		),
		array(
			'id'			=> 'blog-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Blog Page Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for blog page layout.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'blog-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Blog Sidebar Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose the position of the blog sidebar, such as left, right, both or no-sidebar (full-width).', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'blog-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Blog Right Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the blog page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'blog-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'blog-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Blog Left Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the blog page', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'blog-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'blog-top-meta-enable',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Top Meta', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to enable post top meta in the blog posts.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'blog-top-meta-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Blog Post Top Meta Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Blog post Top Meta section using a drag-and-drop interface.', 'gigas-addon' ),
			'items'			=> array(
				'more'  => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => 		array(
						array(
							'id'      		=> 'blog-read-more',
							'type'  		=> 'text',
							'title'			=> esc_html__( 'Blog Read More', 'gigas-addon'),
							'description'	=> esc_html__( 'Enter a "read more" text to display in the Blog post excerpt (description).', 'gigas-addon' ),
							'default' 		=> 'Read more',
						),
					),
					'editable'	=> true
				),
			),
			'default'		=> array(
				'left' => array(
					'author' => esc_html__( 'Author', 'gigas-addon' )
				),
				'right' => array(
					'category' => esc_html__( 'Category', 'gigas-addon' )
				),
				'disabled' => array(
					'date' => esc_html__( 'Date', 'gigas-addon' ),
					'tag' => esc_html__( 'Tag', 'gigas-addon' ),
					'share' => esc_html__( 'Social Share', 'gigas-addon' ),
					'more' => esc_html__( 'Read More', 'gigas-addon' )
				)
			),
			'required'		=> array( 'blog-top-meta-enable', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'blog-bottom-meta-enable',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Bottom Meta', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to enable post bottom meta in the blog posts.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'blog-bottom-meta-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Blog Post Bottom Meta Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Blog post Bottom Meta section using a drag-and-drop interface.', 'gigas-addon' ),
			'items'			=> array(
				'more'  => array(
					'title'       => esc_html__( 'Editor Space', 'gigas-addon' ),
					'fields'      => 		array(
						array(
							'id'      		=> 'blog-read-more',
							'type'  		=> 'textarea',
							'title'			=> esc_html__( 'Blog Read More', 'gigas-addon'),
							'description'	=> esc_html__( 'Add an icon class in front or back of the "read more" text is display in excerpt. Example:Read more', 'gigas-addon' ),
							'default' 		=> 'Read more',
							'required'		=> array( 'blog-read-more-settings', '=', array( 'custom' ) )
						),
					),
					'editable'	=> true
				),
			),
			'default'		=> array(
				'left' => array(
				),
				'right' => array(
					'more' => esc_html__( 'Read More', 'gigas-addon' )
				),
				'disabled' => array(
					'tag' => esc_html__( 'Tag', 'gigas-addon' ),
					'author' => esc_html__( 'Author', 'gigas-addon' ),
					'category' => esc_html__( 'Category', 'gigas-addon' ),
					'date' => esc_html__( 'Date', 'gigas-addon' ),
					'share' => esc_html__( 'Social Share', 'gigas-addon' )
				)
			),
			'required'		=> array( 'blog-bottom-meta-enable', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'blog-post-excerpt-length',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Excerpt Length', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enter the excerpt length (no. of words) of blog post. Leave this empty to set wp default excerpt length of posts.', 'gigas-addon' ),
			'default'		=> 20
		),
	)
) );

Gigas_Options::gigas_set_sub_section(array(
    'title' => esc_html__('Page 404', 'gigas-addon'),
    'id' => '404-option',
	'config_id'  => 'customizer_settings_theme_template',
    'fields' => array(
		array(
			'id'    	=> '',
			'type'  	=> 'label',
			'title' 	=> esc_html__('404 Page Layout', 'gigas-addon'),
		),
        array(
            'id' => '404_building_tool',
            'type' => 'select',
            'title' => esc_html__('404 page', 'gigas-addon'),
			'description'	=> esc_html__('Select a page to display when a page is not found ( 404 error ).', 'gigas-addon'),
            'choices' => array(
                'default' => esc_html__('Theme Default', 'gigas-addon'),
                'elementor' => esc_html__('Elementor', 'gigas-addon'),
            ),
            'default' => 'default',
        ),
		array(
			'id'       => '404-page-selector',
			'type'     => 'pages',
			'title'    => esc_html__( 'Select 404 Template page', 'gigas-addon' ),
			'description'     => esc_html__( 'Select a Elementor page to display in place of 404 template page.', 'gigas-addon' ),
			'default'  => '',
			'required'		=> array( '404_building_tool', '=', array( 'elementor' ) )
		),
    ),
));

Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Posts Archive', 'gigas-addon' ),
	'id'         => 'archive-tab',
	'config_id'  => 'customizer_settings_theme_template',
	'fields'	 => array(
		array(
			'id'			=> 'archive-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Archive Page Title Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for archive page title.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'archive-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Archive Page.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'archive-layout-setting',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Archive Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Archive styles settings.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'archive-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Archive Page Title Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the archive page.', 'gigas-addon' ),
					'required'		=> array( 'archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'archive-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Archive Description Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the archive page.', 'gigas-addon' ),
					'required'		=> array( 'archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'archive-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Archive Title Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the archive page title. Like breadcrumbs color.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'archive-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Archive Title Padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the Archive Title section.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'archive-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Archive Page Title Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the Archive Page Title section, including color, image, size, etc.', 'gigas-addon' ),
					'required'		=> array( 'archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'archive-title-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Archive Page Title Overlay Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the Archive page title background. Choose light colors to make it displayed over the image.', 'gigas-addon' ),
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
			),
		),
		array(
			'id'			=> 'archive-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Archive Page Title Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Archive Title section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'gigas-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'gigas-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'gigas-addon' )
				)
			),
		),

		array(
			'id'			=> 'archive-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Archive Page Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for archive page layout.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'archive-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Archive Sidebar Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose the position of the archive page sidebar, such as left, right, both or no-sidebar (full-width).', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'archive-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Archive Right Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the Archive page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'archive-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'archive-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Archive Left Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the Archive page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'archive-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'archive-top-meta-enable',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Top Meta', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to enable post top meta in the Archive Page Items.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'archive-top-meta-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Archive Post Top Meta Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Archive post Top Meta section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
					'author' => esc_html__( 'Author', 'gigas-addon' )
				),
				'right' => array(
					'category' => esc_html__( 'Category', 'gigas-addon' )
				),
				'disabled' => array(
					'date' => esc_html__( 'Date', 'gigas-addon' ),
					'tag' => esc_html__( 'Tag', 'gigas-addon' ),
					'share' => esc_html__( 'Social Share', 'gigas-addon' )
				)
			),
			'required'		=> array( 'archive-top-meta-enable', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'archive-bottom-meta-enable',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Bottom Meta', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to enable post bottom meta in the blog posts.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'archive-bottom-meta-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Archive Post Bottom Meta Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Blog post Bottom Meta section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'right' => array(		
					'more' => esc_html__( 'Read More', 'gigas-addon' )
				),
				'disabled' => array(
					'tag' => esc_html__( 'Tag', 'gigas-addon' ),
					'author' => esc_html__( 'Author', 'gigas-addon' ),
					'category' => esc_html__( 'Category', 'gigas-addon' ),
					'date' => esc_html__( 'Date', 'gigas-addon' ),
					'share' => esc_html__( 'Social Share', 'gigas-addon' )
				)
			),
			'required'		=> array( 'archive-bottom-meta-enable', '=', array( 'true' ) )
		),
		array(
			'id'            => 'search-templates',
			'type'          => 'multicheck',
			'title'         => esc_html__( 'Search Content', 'gigas-addon' ),
			'description'   => esc_html__( 'Select templates to be displayed in search results posts, pages, or custom post types.', 'gigas-addon' ),
			'items'       => array(
				'post'        	  => esc_html__( 'Post', 'gigas-addon' ),
				'page'        	  => esc_html__( 'Page', 'gigas-addon' ),
				'cea-team'        => esc_html__( 'Team', 'gigas-addon' ),
				'cea-event'       => esc_html__( 'Event', 'gigas-addon' ),
				'cea-service' 	  => esc_html__( 'Service', 'gigas-addon' ),
				'cea-testimonial' => esc_html__( 'Testimonial', 'gigas-addon' ),
				'cea-portfolio'   => esc_html__( 'Portfolio', 'gigas-addon' )
			),
			'default'       => array( 'post', 'page' ), 
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Post Single', 'gigas-addon' ),
	'id'         => 'post-single-tab',
	'config_id'  => 'customizer_settings_theme_template',
	'fields'	 => array(
		array(
			'id'			=> 'single-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Single Post Page Title Settings', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is settings for single post page title.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'single-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Single Page.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'single-post-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Post Single Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Post Single settings.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'single-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Single Post Page Title Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the Single Post page.', 'gigas-addon' ),
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'single-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Single Post Description Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the Single Post page.', 'gigas-addon' ),
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'single-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Single Post Title Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the Single Post page title. Like breadcrumbs color.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'single-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Single Title Padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the Single Post Title section.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'single-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Single Post Page Title Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the Single Post Page Title section, including color, image, size, etc.', 'gigas-addon' ),
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'single-title-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Single Page Title Overlay Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the Single Post page title background. Choose light colors to make it displayed over the image.', 'gigas-addon' ),
					'required'		=> array( 'single-title', '=', array( 'true' ) )
				),
			),
		),
		array(
			'id'			=> 'single-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Single Post Page Title Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Single Post Title section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'gigas-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'gigas-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'gigas-addon' )
				)
			),
		),
		array(
			'id'			=> 'single-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Single Post Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for single blog post page layout.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'single-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Single Post Sidebar Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose the position of the single page sidebar, such as left, right, both or no-sidebar (full-width).', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'single-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Single Post Right Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the Single page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'single-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'single-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Single Post Left Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the Single page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'single-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'single-top-meta-enable',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Top Meta', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to enable post top meta in the Single Page.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'single-top-meta-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Single Post Top Meta Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Single post Top Meta section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
					'author' => esc_html__( 'Author', 'gigas-addon' )
				),
				'right' => array(
					'category' => esc_html__( 'Category', 'gigas-addon' )
				),
				'disabled' => array(
					'date' => esc_html__( 'Date', 'gigas-addon' ),
					'tag' => esc_html__( 'Tag', 'gigas-addon' ),
					'share' => esc_html__( 'Social Share', 'gigas-addon' )
				)
			),
			'required'		=> array( 'single-top-meta-enable', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'single-bottom-meta-enable',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Bottom Meta', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to enable post bottom meta in the Single Page.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'single-bottom-meta-items',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Single Post Bottom Meta Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Single post Bottom Meta section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
					'tag' => esc_html__( 'Tag', 'gigas-addon' ),
				),
				'right' => array(		
					'share' => esc_html__( 'Social Share', 'gigas-addon' )			
				),
				'disabled' => array(
					'author' => esc_html__( 'Author', 'gigas-addon' ),
					'category' => esc_html__( 'Category', 'gigas-addon' ),
					'date' => esc_html__( 'Date', 'gigas-addon' )
				)
			),
			'required'		=> array( 'single-bottom-meta-enable', '=', array( 'true' ) )
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Page', 'gigas-addon' ),
	'id'         => 'post-page-tab',
	'config_id'  => 'customizer_settings_theme_template',
	'fields'	 => array(
		array(
			'id'			=> 'page-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Page Title Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for single post page title.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'page-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Single Page.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'page-layout-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Page Layout', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Page Layout settings.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'page-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Page Title Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the page.', 'gigas-addon' ),
					'required'		=> array( 'page-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'page-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Page Title Description Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the page.', 'gigas-addon' ),
					'required'		=> array( 'page-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'page-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Page Title Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the page title. Like breadcrumbs color.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'page-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'page-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Page Title Padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the page Title section.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'page-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'page-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Page Title Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the Page Title section, including color, image, size, etc.', 'gigas-addon' ),
					'required'		=> array( 'page-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'page-title-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Page Title Overlay Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the page title background. Choose light colors to make it displayed over the image.', 'gigas-addon' ),
					'required'		=> array( 'page-title', '=', array( 'true' ) )
				),
			),
		),
		array(
			'id'			=> 'page-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Page Title Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Single Page Title section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'gigas-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'gigas-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'gigas-addon' )
				)
			),
		),
		
		array(
			'id'			=> 'page-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Page Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for page layout.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'page-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Single Page Sidebar Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose the position of the page sidebar, such as left, right, both or no-sidebar (full-width).', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'page-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Page Right Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the Single page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'page-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'page-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Page Left Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the Single page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'page-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		)
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Custom Posts Archive', 'gigas-addon' ),
	'id'         => 'custom-posts-tab',
	'config_id'  => 'customizer_settings_theme_template',
	'fields'	 => array(
		array(
			'id'			=> 'custom-archive-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Custom Archive Page Title Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for custom archive page title.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'custom-archive-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Custom Post Archive.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'custom-archive-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Custom Archive Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Custom Post Archive settings.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'custom-archive-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Custom Archive Page Title Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the custom archive page.', 'gigas-addon' ),
					'required'		=> array( 'custom-archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-archive-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Custom Archive Page Title Description Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the custom archive page.', 'gigas-addon' ),
					'required'		=> array( 'page-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-archive-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Custom Archive Page Title Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the custom archive page title. Like breadcrumbs color.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'custom-archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-archive-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Custom Archive Title Padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the custom archive page Title section.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'custom-archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-archive-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Custom Archive Page Title Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the custom archive Page Title section, including color, image, size, etc.', 'gigas-addon' ),
					'required'		=> array( 'custom-archive-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-archive-title-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Custom Archive Page Title Overlay Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the custom archive page title background. Choose light colors to make it displayed over the image.', 'gigas-addon' ),
					'required'		=> array( 'custom-archive-title', '=', array( 'true' ) )
				),
			),
		),
		array(
			'id'			=> 'custom-archive-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Custom Archive Page Title Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Custom Post Archive Page Title section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'gigas-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'gigas-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'gigas-addon' )
				)
			),
		),

		array(
			'id'			=> 'custom-archive-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Custom Archive Page Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for custom archive page layout.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'custom-archive-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Archive Sidebar Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose the position of the Custom Post Archive Page sidebar, such as left, right, both or no-sidebar (full-width).', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'custom-archive-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Right Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the Custom Post Archive page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'custom-archive-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'custom-archive-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Left Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the Custom Post Archive page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'custom-archive-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Custom Post Single', 'gigas-addon' ),
	'id'         => 'custom-post-single-tab',
	'config_id'  => 'customizer_settings_theme_template',
	'fields'	 => array(
		array(
			'id'			=> 'custom-single-pt-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Custom Single Post Page Title Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for custom single post page title.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'custom-single-title',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Enable/Disable Page Title', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle to display the page title in the Custom Post Single.', 'gigas-addon' ),
			'default'		=> true
		),
		array(
			'id'			=> 'custom-single-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Custom Single Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can control all Custom Single settings.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'custom-single-title-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Custom Single Post Title Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the title of the custom single post page.', 'gigas-addon' ),
					'required'		=> array( 'custom-single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-single-title-desc-color',
					'type'			=> 'color',
					'title'			=> esc_html__( 'Custom Single Post Title Description Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the description of the custom single post page.', 'gigas-addon' ),
					'required'		=> array( 'custom-single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-single-title-link-color',
					'type'			=> 'link',
					'title'			=> esc_html__( 'Custom Single Post Title Link Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the color for the hyperlinks of the custom single post page title. Like breadcrumbs color. Like breadcrumbs color.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'custom-single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-single-title-padding',
					'type'			=> 'dimension',
					'title'			=> esc_html__( 'Custom Single Title Padding', 'gigas-addon' ),
					'description'	=> esc_html__( 'Adjust the padding (inner spacing) around the custom single post page Title section.', 'gigas-addon' ),
					'default'		=> '',
					'required'		=> array( 'custom-single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-single-title-bg',
					'type'			=> 'background',
					'title'			=> esc_html__( 'Custom Single Post Page Title Background Options', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose background settings for the custom single post Page Title section, including color, image, size, etc.', 'gigas-addon' ),
					'required'		=> array( 'custom-single-title', '=', array( 'true' ) )
				),
				array(
					'id'			=> 'custom-single-title-overlaycolor',
					'type'			=> 'color',
					'alpha'			=> true,
					'title'			=> esc_html__( 'Custom Single Page Title Overlay Color', 'gigas-addon' ),
					'description'	=> esc_html__( 'Set the overlay color for the custom single post page title background. Choose light colors to make it displayed over the image.', 'gigas-addon' ),
					'required'		=> array( 'custom-single-title', '=', array( 'true' ) )
				),
			),
		),
		array(
			'id'			=> 'custom-single-title-items',
			'type'			=> 'dragdrop-editor',
			'title'			=> esc_html__( 'Custom Single Post Page Title Elements', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the elements in the Custom Post Single Page Title section using a drag-and-drop interface.', 'gigas-addon' ),
			'default'		=> array(
				'left' => array(
				),
				'center' => array(
					'title' => esc_html__( 'Title', 'gigas-addon' ),
					'breadcrumb' => esc_html__( 'Breadcrumb', 'gigas-addon' )
				),
				'right' => array(
				),
				'disabled' => array(
					'description' => esc_html__( 'Description', 'gigas-addon' )
				)
			),
		),
		array(
			'id'			=> 'custom-single-pl-settings',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Custom Single Post Page Layout Settings', 'gigas-addon' ),
			'desc'	=> esc_html__( 'This is settings for archive page layout.', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
		array(
			'id'			=> 'custom-single-sidebar-layout',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Custom Single Post Sidebar Layout', 'gigas-addon' ),
			'description'	=> esc_html__( 'Choose the position of the Custom Post Single Page sidebar, such as left, right, both or no-sidebar (full-width).', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'right-sidebar'
		),
		array(
			'id'			=> 'custom-single-right-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Right Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the right sidebar area of the Custom Post Single page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'custom-single-sidebar-layout', '=', array( 'right-sidebar', 'both-sidebar' ) )
		),
		array(
			'id'			=> 'custom-single-left-sidebar',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Left Widgets Area', 'gigas-addon' ),
			'description'	=> esc_html__( 'Select and add widget to the left sidebar area of the Custom Post Single page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'custom-single-sidebar-layout', '=', array( 'left-sidebar', 'both-sidebar' ) )
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'templates-tab-end'	
));

do_action( 'gigas_custom_template_options' );

// Social
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Social', 'gigas-addon' ),
	'id'         => 'social-tab',
	'config_id'  => 'customizer_settings_social',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Social Links', 'gigas-addon' ),
	'id'         => 'social-links-tab',
	'config_id'  => 'customizer_settings_social',
	'fields'	 => array(
		array(
			'id'			=> 'social-links-styling',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Social Link Style Editor', 'gigas-addon' ),
			'desc'	=> esc_html__( 'Here you can modify the styles of the Social Links.', 'gigas-addon' ),
			'seperator'		=> 'before',
			'show_edit_icon' => true,
			'fields'		=> array(
				array(
					'id'			=> 'social-icon-window',
					'type'			=> 'select',
					'title'			=> esc_html__( 'Target Window', 'gigas-addon' ),
					'description'	=> esc_html__( 'Choose whether links open in the same window or a new tab when clicked.', 'gigas-addon' ),
					'choices'		=> array(
						''			=> esc_html__( 'Default', 'gigas-addon' ),
						'_self'		=> esc_html__( 'Self', 'gigas-addon' ),
						'_blank'	=> esc_html__( 'Blank', 'gigas-addon' ),
						'_parent'	=> esc_html__( 'Parent', 'gigas-addon' )
					),
					'default'		=> ''
				),
				array(
					'id'       => 'social-icons-fore',
					'type'     => 'select',
					'title'    => esc_html__( 'Social Icons Fore', 'gigas-addon' ),
					'description'     => esc_html__( 'Choose whether to use the theme color or custom color for Icon.', 'gigas-addon' ),
					'choices'  => array(
						'own'		=> esc_html__( 'Own Color', 'gigas-addon' ),
						'custom'	=> esc_html__( 'Custom Color', 'gigas-addon' )
					),
					'default'  => 'black'
				),
				array(
					'id'	  		=> 'social-icons-fore-custom',
					'type'	  		=> 'color',
					'title'    => esc_html__( 'Social Icons Fore Custom Color', 'gigas-addon' ),
					'description'     => esc_html__( 'Set the custom color for the foreground (icon color) of social media icons.', 'gigas-addon' ),
					'required'		=> array( 'social-icons-fore', '=', array( 'custom' ) )
				),
				array(
					'id'       => 'social-icons-hfore',
					'type'     => 'select',
					'title'    => esc_html__( 'Social Icons Fore Hover', 'gigas-addon' ),
					'description'     => esc_html__( 'Choose whether to use the theme color or custom hover color for Icon.', 'gigas-addon' ),
					'choices'  => array(
						'h-own'		=> esc_html__( 'Own Color', 'gigas-addon' ),
						'h-custom'  => esc_html__( 'Custom Color', 'gigas-addon' ),
					),
					'default'  => 'h-own'
				),
				array(
					'id'	  		=> 'social-icons-hfore-custom',
					'type'	  		=> 'color',
					'title'    		=> esc_html__( 'Social Icons Fore  Hover Custom Color', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the custom hover color for the foreground (icon color) of social media icons.', 'gigas-addon' ),
					'required'		=> array( 'social-icons-hfore', '=', array( 'h-custom' ) )
				),
				array(
					'id'       => 'social-icons-bg',
					'type'     => 'select',
					'title'    => esc_html__( 'Social Icons Background', 'gigas-addon' ),
					'description'     => esc_html__( 'Choose whether to use the theme background color or custom background color for Icon.', 'gigas-addon' ),
					'choices'  => array(
						'bg-own'		=> esc_html__( 'Own Color', 'gigas-addon' ),
						'bg-custom'		=> esc_html__( 'Custom Color', 'gigas-addon' )
					),
					'default'  => '',
				),
				array(
					'id'	  		=> 'social-icons-bg-custom',
					'type'	  		=> 'color',
					'title'    		=> esc_html__( 'Social Icons Background', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the custom color for the background (icon color) of social media icons.', 'gigas-addon' ),
					'required'		=> array( 'social-icons-bg', '=', array( 'bg-custom' ) )
				),
				array(
					'id'       => 'social-icons-hbg',
					'type'     => 'select',
					'title'    => esc_html__( 'Social Icons Background Hover', 'gigas-addon' ),
					'description'     => esc_html__( 'Choose whether to use the theme background color or custom hover background color for Icon.', 'gigas-addon' ),
					'choices'  => array(
						'hbg-own'		=> esc_html__( 'Own Color', 'gigas-addon' ),
						'hbg-custom'	=> esc_html__( 'Custom Color', 'gigas-addon')
					),
					'default'  => ''
				),
				array(
					'id'	  		=> 'social-icons-hbg-custom',
					'type'	  		=> 'color',
					'title'         => esc_html__( 'Social Icons Background Hover', 'gigas-addon' ),
					'description'   => esc_html__( 'Set the custom hover color for the background (icon color) of social media icons.', 'gigas-addon' ),
					'required'		=> array( 'social-icons-hbg', '=', array( 'hbg-custom' ) )
				),
				array(
					'id'          => 'social-icons-border-color',
					'type'        => 'color',
					'title'       => esc_html__( 'Social Icons Border Color', 'gigas-addon' ),
					'description' => esc_html__( 'Set a custom color for border of the social icons.', 'gigas-addon' ),
				),
				array(
					'id'          => 'social-icons-border-width',
					'type'        => 'number',
					'title'       => esc_html__( 'Social Icons Border Width', 'gigas-addon' ),
					'description' => esc_html__( 'Set the thickness of the border around social media icons (in pixels).', 'gigas-addon' ),
					'default'     => 0,
				),
				array(
					'id'          => 'social-icons-border-radius',
					'type'        => 'number',
					'title'       => esc_html__( 'Social Icons Border Radius', 'gigas-addon' ),
					'description' => esc_html__( 'Adjust the roundness of the social media icons borders for a square or circular look (in pixels).', 'gigas-addon' ),
					'default'     => 50,
				),
				array(
					'id'		  => 'social-icons-border-style',
					'type'	      => 'select',
					'title'       => esc_html__( 'Social Icons border Style', 'gigas-addon' ),
					'description' => esc_html__( 'Choose the style of the border around social media icons.', 'gigas-addon' ),
					'default'	  => '',
					'choices'	  => array(
						'none'		=> esc_html__( 'None', 'gigas-addon' ),
						'solid'		=> esc_html__( 'Solid', 'gigas-addon' ),
						'dashed'	=> esc_html__( 'Dashed', 'gigas-addon' ),
						'dotted'	=> esc_html__( 'Dotted', 'gigas-addon' ),
						'double'	=> esc_html__( 'Double', 'gigas-addon' ),
						'groove'	=> esc_html__( 'Groove', 'gigas-addon' ),
						'ridge'		=> esc_html__( 'Ridge', 'gigas-addon' ),
						'inset'		=> esc_html__( 'Inset', 'gigas-addon' ),
						'outset'	=> esc_html__( 'Outset', 'gigas-addon' )
					)
				),
			),
		),
		array(
			'id'			=> 'social-links',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Social Links', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the social icons you need in your site using a drag-and-drop interface. Click on the Social icon to add your Social link URL\'s.', 'gigas-addon' ),
			'html'			=> true,
			'default'		=> array(
				'enabled' => array(
					'facebook' => 'fa fa-facebook',
					'twitter' => 'bi bi-twitter-x',
					'linkedin' => 'fa fa-linkedin',
					'instagram' => 'fa fa-instagram'
				),
				'disabled' => array(
					'vimeo' => 'fa fa-vimeo',
					'yahoo' => 'fa fa-yahoo',
					'youtube' => 'fa fa-youtube-play',
					'tumblr ' => 'fa fa-tumblr',
					'stack-overflow' => 'fa fa-stack-overflow',
					'pinterest' => 'fa fa-pinterest-p',
					'jsfiddle' => 'fa fa-jsfiddle',
					'reddit' => 'fa fa-reddit-alien',
					'soundcloud' => 'fa fa-soundcloud',
					'xing' => 'fa fa-xing',
					'wikipedia' => 'fa fa-wikipedia-w',
					'whatsapp' => 'fa fa-whatsapp',
					'tiktok' => 'bi bi-tiktok',
				)
			)
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Social Share', 'gigas-addon' ),
	'id'         => 'social-share-tab',
	'config_id'  => 'customizer_settings_social',
	'fields'	 => array(
		array(
			'id'			=> 'social-share',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Social Share', 'gigas-addon' ),
			'description'	=> esc_html__( 'Arrange and customize the social share links you need in the Single Post using a drag-and-drop interface.', 'gigas-addon' ),
			'html'			=> true,
			'icons_only'	=> true,
			'default'		=> array(
				'enabled' => array(
					'facebook' => 'fa fa-facebook',
					'twitter' => 'bi bi-twitter-x',
					'linkedin' => 'fa fa-linkedin',
					'instagram' => 'fa fa-instagram'
				),
				'disabled' => array(
					'pinterest' => 'fa fa-pinterest-p',
					'whatsapp' => 'fa fa-whatsapp',
					'tumblr ' => 'fa fa-tumblr',
					'vimeo' => 'fa fa-vimeo',
					'yahoo' => 'fa fa-yahoo',
					'youtube' => 'fa fa-youtube-play',
					'stack-overflow' => 'fa fa-stack-overflow',
					'jsfiddle' => 'fa fa-jsfiddle',
					'reddit' => 'fa fa-reddit-alien',
					'soundcloud' => 'fa fa-soundcloud',
					'xing' => 'fa fa-xing',
					'wikipedia' => 'fa fa-wikipedia-w',
					'tiktok' => 'bi bi-tiktok',
				)
			)
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'social-tab-end'
));


/**
 *  Increase Performance. For Frontend.
 */
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Performance', 'gigas-addon' ),
	'id'         => 'performance-tab',
	'config_id'  => 'customizer_settings_performance',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Improve Performance', 'gigas-addon' ),
	'id'         => 'performance-general-tab',
	'config_id'  => 'customizer_settings_performance',
	'fields'	 => array(
		array(
			'id' 			=> 'performance',
			'type'			=> 'toggle',
			'title' 		=> esc_html__( 'Improve performance', 'gigas-addon'),
			'description'   => esc_html__( 'Toggle to enable the performance tab to increase the speed of the site.', 'gigas-addon' ),
			'default' 		=> false
		),
		array(
			'id'			=> 'minify-css',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Minify CSS', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle this to minify all the stylesheets used in this theme to reduce file size and improve site performance.', 'gigas-addon' ),
			'default'		=> false,
			'required'		=> array( 'performance', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'minify-js',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Minify JS', 'gigas-addon' ),
			'description'	=> esc_html__( 'Toggle this to minify all the js scripts used in this theme to reduce file size and improve site performance.', 'gigas-addon' ),
			'default'		=> false,
			'required'		=> array( 'performance', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'emoji-script',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Disable Emoji Scripts', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enable this option to prevent WordPress from loading emoji scripts, improving page speed.', 'gigas-addon' ),
			'default'		=> false,
			'required'		=> array( 'performance', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'gzip-comp',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Gzip Compression', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enable Gzip compression to reduce file sizes and improve website loading speed.', 'gigas-addon' ),
			'default'		=> false,
			'required'		=> array( 'performance', '=', array( 'true' ) )
		),
		array(
			'id' 			=> 'woo-scripts-styles',
			'type'			=> 'toggle',
			'title' 		=> esc_html__( 'Disable WooCommerce Scripts & Style', 'gigas-addon' ),
			'description'	=> esc_html__( 'Disable unnecessary WooCommerce scripts and styles on non-WooCommerce pages to improve performance.', 'gigas-addon'),
			'default' 		=> false,
			'required'		=> array( 'performance', '=', array( 'true' ) )
		)
	)
));
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'performance-tab-end'
));


/**
 * Detect plugin. For frontend only.
 */
include_once ABSPATH . 'wp-admin/includes/plugin.php';
 
// check for plugin using plugin name
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
    require_once ( GIGAS_ADDON_DIR . 'admin/extension/theme-options/woo-config.php' );
} 

// Maintenance or Coming Soon Mode
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Maintenance', 'gigas-addon' ),
	'id'         => 'maintenance-tab',
	'config_id'  => 'customizer_settings_maintenance'
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Maintenance', 'gigas-addon' ),
	'id'         => 'maintenance-general-tab',
	'config_id'  => 'customizer_settings_maintenance',
	'fields'	 => array(
		array(
			'id'			=> 'maintenance-opt',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Maintenance Mode Option', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enable or disable maintenance mode to display a temporary "coming soon" or "under maintenance" page.', 'gigas-addon' ),
			'default'		=> false
		),
		array(
			'id'       => 'maintenance-type',
			'type'     => 'select',
			'title'    => esc_html__( 'Maintenance Type', 'gigas-addon' ),
			'description'     => esc_html__( 'Choose the type of maintenance mode, such as "Coming Soon" or "Maintenance".', 'gigas-addon' ),
			'choices'  => array(
				'cs'		=> esc_html__( 'Coming Soon', 'gigas-addon' ),
				'mn'		=> esc_html__( 'Maintenance', 'gigas-addon' ),
				'cus'		=> esc_html__( 'Custom', 'gigas-addon' )
			),
			'default'  => 'cs',
			'required'		=> array( 'maintenance-opt', '=', array( 'true' ) )
		),
		array(
			'id'       => 'maintenance-custom',
			'type'     => 'pages',
			'title'    => esc_html__( 'Maintenance Custom Page', 'gigas-addon' ),
			'description'     => esc_html__( 'Select a custom page to display when maintenance mode is enabled.', 'gigas-addon' ),
			'default'  => '',
			'required'		=> array( 'maintenance-type', '=', array( 'cus' ) )
		),
		array(
			'id'			=> 'maintenance-phone',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Phone', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enter the phone number to display on the site for contact purposes when maintenance mode is enabled.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'maintenance-opt', '=', array( 'true' ) )
		),		
		array(
			'id'			=> 'maintenance-email',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Email', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enter the email address to display on the site for contact purposes when maintenance mode is enabled', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'maintenance-opt', '=', array( 'true' ) )
		),
		array(
			'id'			=> 'maintenance-address',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Address', 'gigas-addon' ),
			'description'	=> esc_html__( 'Enter the contact address to display on the maintenance mode page.', 'gigas-addon' ),
			'default'		=> '',
			'required'		=> array( 'maintenance-opt', '=', array( 'true' ) )
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'maintenance-tab-end'
) );

// Import/Export
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'Import/Export', 'gigas-addon' ),
	'id'         => 'ie-tab',
	'config_id'  => 'customizer_settings_import',
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Import', 'gigas-addon' ),
	'id'         => 'import-tab',
	'config_id'  => 'customizer_settings_import',
	'fields'	 => array(
		array(
			'id'			=> 'gigas-import',
			'type'			=> 'import',
			'title'			=> esc_html__( 'Import Theme Option Json', 'gigas-addon' ),
			'description'	=> esc_html__( 'Paste theme options json value here and press import button and wait untill process complete. Once saved theme options please hard refresh your frontend, so only dynamically generated CSS will update.', 'gigas-addon' ),
			'default'		=> ''
		),
	)
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Export', 'gigas-addon' ),
	'id'         => 'export-tab',
	'config_id'  => 'customizer_settings_import',
	'fields'	 => array(
		array(
			'id'			=> 'gigas-export',
			'type'			=> 'export',
			'title'			=> esc_html__( 'Export Theme Option Json', 'gigas-addon' ),
			'description'	=> esc_html__( 'Generate and download a JSON file containing the current theme settings for backup or transfer. Once click export button wait few seconds.', 'gigas-addon' ),
			'default'		=> ''
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'ie-tab-end'	
));

/*
//All Fields
Gigas_Options::gigas_set_section( array(
	'title'      => esc_html__( 'All Fields', 'gigas-addon' ),
	'id'         => 'all-fields'
) );
Gigas_Options::gigas_set_sub_section( array(
	'title'      => esc_html__( 'Fields', 'gigas-addon' ),
	'id'         => 'un-fields-tab',
	'fields'	 => array(
		array(
			'id'			=> 'test_text_field',
			'type'			=> 'text',
			'title'			=> esc_html__( 'Text Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is text field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_textarea_field',
			'type'			=> 'textarea',
			'title'			=> esc_html__( 'Textarea Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is textarea field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'test_select_field',
			'type'			=> 'select',
			'title'			=> esc_html__( 'Select Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is select field', 'gigas-addon' ),
			'choices'		=> array(
				'1'	=> 'One',
				'2'	=> 'Two',
				'3'	=> 'Three'
			),
			'default'		=> '2'
		),
		array(
			'id'			=> 'test_color_field',
			'type'			=> 'color',
			'title'			=> esc_html__( 'Color Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is color field', 'gigas-addon' ),
			'alpha'			=> false,
			'default'		=> '#111111'
		),
		array(
			'id'			=> 'test_link_field',
			'type'			=> 'link',
			'title'			=> esc_html__( 'Link Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is link field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'ajax-trigger-fonts-test',
			'type'			=> 'fonts',
			'title'			=> esc_html__( 'Google Fonts Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is fonts field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'background_test',
			'type'			=> 'background',
			'title'			=> esc_html__( 'Background Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is background field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'image_test',
			'type'			=> 'image',
			'title'			=> esc_html__( 'Image Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is image field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'border_test',
			'type'			=> 'border',
			'title'			=> esc_html__( 'Border Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is border field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'dimension_test',
			'type'			=> 'dimension',
			'title'			=> esc_html__( 'Dimension Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is dimension field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'hw_test',
			'type'			=> 'hw',
			'title'			=> esc_html__( 'Width/Height Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is width height field', 'gigas-addon' ),
			'only_dimension' => 'both'
		),
		array(
			'id'			=> 'toggle_test',
			'type'			=> 'toggle',
			'title'			=> esc_html__( 'Toggle Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is toggle field', 'gigas-addon' )
		),
		array(
			'id'			=> 'sidebars_test',
			'type'			=> 'sidebars',
			'title'			=> esc_html__( 'Sidebars Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is sidebars field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'pages_test',
			'type'			=> 'pages',
			'title'			=> esc_html__( 'Pages Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is pages field', 'gigas-addon' ),
			'default'		=> ''
		),
		array(
			'id'			=> 'multicheck_test',
			'type'			=> 'multicheck',
			'title'			=> esc_html__( 'Multi Check Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is multi check box field', 'gigas-addon' ),
			'items'		=> array(
				'one' => esc_html__( 'One', 'gigas-addon' ),
				'two' => esc_html__( 'Two', 'gigas-addon' ),
				'three' => esc_html__( 'Three', 'gigas-addon' ),
				'four' => esc_html__( 'Four', 'gigas-addon' ),
				'five' => esc_html__( 'Five', 'gigas-addon' )
			)
		),
		array(
			'id'			=> 'radioimage_test',
			'type'			=> 'radioimage',
			'title'			=> esc_html__( 'Radio Image Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is radio image field', 'gigas-addon' ),
			'items'		=> array(
				'right-sidebar' => array(
					'title' => esc_html__( 'Right Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-right.png'
				),
				'left-sidebar' => array(
					'title' => esc_html__( 'Left Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-left.png'
				),
				'both-sidebar' => array(
					'title' => esc_html__( 'Both Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/sidebar-both.png'
				),
				'no-sidebar' => array(
					'title' => esc_html__( 'No Sidebar', 'gigas-addon' ),
					'url' => GIGAS_ADDON_URL . 'admin/extension/theme-options/assets/images/sidebars/no-sidebar.png'
				)
			),
			'default' => 'left-sidebar'
		),
		array(
			'id'			=> 'dragdrop_test',
			'type'			=> 'dragdrop',
			'title'			=> esc_html__( 'Drag Drop Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is drag and drop field', 'gigas-addon' ),
			'default'		=> array(
				'enabled' => array(
					'one' => esc_html__( 'One', 'gigas-addon' ),
					'two' => esc_html__( 'Two', 'gigas-addon' )
				),
				'disabled' => array(
					'three' => esc_html__( 'Three', 'gigas-addon' ),
					'four' => esc_html__( 'Four', 'gigas-addon' ),
					'five' => esc_html__( 'Five', 'gigas-addon' )
				)
			)
		),
		array(
			'id'			=> 'test_label_field',
			'type'			=> 'label',
			'title'			=> esc_html__( 'Label Field', 'gigas-addon' ),
			'description'	=> esc_html__( 'This is label field', 'gigas-addon' ),
			'seperator'		=> 'after'
		),
	)
) );
Gigas_Options::gigas_set_end_section( array(
	'id'		=> 'all-fields-end'	
));*/