 <?php

/**
 * Gigas Post Options CSS
 */

require_once ( GIGAS_ADDON_DIR . 'admin/extension/theme-options/class.options-style.php' );
$gigas_styles = new Gigas_Theme_Styles;

$post_id = get_the_ID();
$gigas_options = $_POST['gigas_options'];//get_post_meta( $post_id, 'gigas_options', true );
$gigas_styles->gigas_options = $gigas_options;

ob_start();

echo "\n/* Gigas Post Options Styles */";
$gigas_styles->gigas_padding_settings( 'content-padding', '.gigas-content-wrap' );

$gigas_styles->gigas_bg_settings( 'page-title-bg', 'body .gigas-page-header' );

$page_title_overlay = $gigas_styles->gigas_get_option( 'page-title-overlaycolor' );
echo '.page .gigas-page-header:after, .error404 .gigas-page-header:after{
	background-color: ' . esc_attr($page_title_overlay) . ';
}';

//logo styles
$logo_chk = $gigas_styles->gigas_get_option('logo-chk');
if( $logo_chk == 'custom' ){
	$site_logo_width = $gigas_styles->gigas_get_option('site-logo-width');
	if( !empty( $site_logo_width ) && isset( $site_logo_width['width'] ) && !empty( $site_logo_width['width'] ) ){
		echo 'img.site-logo { max-width: '. esc_attr( $site_logo_width['width'] ) .'px; }';
	}
	$sticky_logo_width = $gigas_styles->gigas_get_option('sticky-logo-width');
	if( !empty( $sticky_logo_width ) && isset( $sticky_logo_width['width'] ) && !empty( $sticky_logo_width['width'] ) ){
		echo 'img.sticky-logo { max-width: '. esc_attr( $sticky_logo_width['width'] ) .'px; }';
	}
	$mobile_logo_width = $gigas_styles->gigas_get_option('mobile-logo-width');
	if( !empty( $mobile_logo_width ) && isset( $mobile_logo_width['width'] ) && !empty( $mobile_logo_width['width'] ) ){
		echo 'img.mobile-logo { max-width: '. esc_attr( $mobile_logo_width['width'] ) .'px; }';
	}
}

//header styles
$header_style_chk = $gigas_styles->gigas_get_option('header-style-chk');
if( $header_style_chk == 'custom' ){
	$gigas_styles->gigas_link_color( 'header-links-color', 'regular', '.site-header a' );
	$gigas_styles->gigas_link_color( 'header-links-color', 'hover', '.site-header a:hover' );
	$gigas_styles->gigas_link_color( 'header-links-color', 'active', '.site-header a:active' );
	$gigas_styles->gigas_bg_settings( 'header-background', '.site-header' );
	$gigas_styles->gigas_padding_settings( 'header-padding', '.site-header' );
	$gigas_styles->gigas_margin_settings( 'header-margin', '.site-header' );
	$gigas_styles->gigas_border_settings( 'header-border', '.site-header' );
}

//header topbar styles & link color
$topbar_style_chk = $gigas_styles->gigas_get_option('header-topbar-style-chk');
if( $topbar_style_chk == 'custom' ){
	$topbar_height = $gigas_styles->gigas_get_option('header-topbar-height');
	if( !empty( $topbar_height ) && isset( $topbar_height['height'] ) && !empty( $topbar_height['height'] ) ){
		echo '.header-topbar {';
			echo 'line-height: '. esc_attr( $topbar_height['height'] ) .'px;';
		echo '}';
	}
	
	$topbar_sticky_height = $gigas_styles->gigas_get_option('header-topbar-sticky-height');
	if( !empty( $topbar_sticky_height ) && isset( $topbar_sticky_height['height'] ) && !empty( $topbar_sticky_height['height'] ) ){
		echo '.header-sticky .header-topbar {';
			echo 'line-height: '. esc_attr( $topbar_sticky_height['height'] ) .'px;';
		echo '}';
	}
	
	$gigas_styles->gigas_bg_settings( 'header-topbar-background', '.header-topbar' );
	$gigas_styles->gigas_padding_settings( 'header-topbar-padding', '.header-topbar' );
	$gigas_styles->gigas_margin_settings( 'header-topbar-margin', '.header-topbar' );
	$gigas_styles->gigas_border_settings( 'header-topbar-border', '.header-topbar' );
	$gigas_styles->gigas_link_color( 'header-topbar-links-color', 'regular', '.header-topbar a' );
	$gigas_styles->gigas_link_color( 'header-topbar-links-color', 'hover', '.header-topbar a:hover' );
	$gigas_styles->gigas_link_color( 'header-topbar-links-color', 'active', '.header-topbar a:active,.header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );

	//topbar on sticky style
	$gigas_styles->gigas_bg_settings( 'header-topbar-sticky-background', '.sticky-head.header-sticky .header-topbar' );
	$gigas_styles->gigas_link_color( 'header-topbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-topbar a' );
	$gigas_styles->gigas_link_color( 'header-topbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-topbar a:hover' );
	$gigas_styles->gigas_link_color( 'header-topbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-topbar a:active, .sticky-head.header-sticky .header-topbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a' );
}

$logobar_style_chk = $gigas_styles->gigas_get_option('header-logobar-style-chk');
if( $logobar_style_chk == 'custom' ){
	//header logobar styles & link color
	$logobar_height = $gigas_styles->gigas_get_option('header-logobar-height');
	if( !empty( $logobar_height ) && isset( $logobar_height['height'] ) && !empty( $logobar_height['height'] ) ){
		echo '.header-logobar {';
			echo 'line-height: '. esc_attr( $logobar_height['height'] ) .'px;';
		echo '}';
	}
	
	$logobar_sticky_height = $gigas_styles->gigas_get_option('header-logobar-sticky-height');
	if( !empty( $logobar_sticky_height ) && isset( $logobar_sticky_height['height'] ) && !empty( $logobar_sticky_height['height'] ) ){
		echo '.header-sticky .header-logobar {';
			echo 'line-height: '. esc_attr( $logobar_sticky_height['height'] ) .'px;';
		echo '}';
	}
	
	$gigas_styles->gigas_bg_settings( 'header-logobar-background', '.header-logobar' );
	$gigas_styles->gigas_padding_settings( 'header-logobar-padding', '.header-logobar' );
	$gigas_styles->gigas_margin_settings( 'header-logobar-margin', '.header-logobar' );
	$gigas_styles->gigas_border_settings( 'header-logobar-border', '.header-logobar' ); 
	$gigas_styles->gigas_link_color( 'header-logobar-links-color', 'regular', '.header-logobar a, .header-logobar .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$gigas_styles->gigas_link_color( 'header-logobar-links-color', 'hover', '.header-logobar a:hover,.header-logobar .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$gigas_styles->gigas_link_color( 'header-logobar-links-color', 'active', '.header-logobar a:active, .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a,.header-logobar .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .header-logobar ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

	//logobar on sticky style
	$gigas_styles->gigas_bg_settings( 'header-logobar-sticky-background', '.sticky-head.header-sticky .header-logobar' );
	$gigas_styles->gigas_link_color( 'header-logobar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-logobar a, .sticky-head.header-sticky .header-logobar .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$gigas_styles->gigas_link_color( 'header-logobar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-logobar a:hover, .sticky-head.header-sticky .header-logobar .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$gigas_styles->gigas_link_color( 'header-logobar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-logobar a:active,.sticky-head.header-sticky .header-logobar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a,.sticky-head.header-sticky .header-logobar .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-logobar ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );
}

$navbar_style_chk = $gigas_styles->gigas_get_option('header-navbar-style-chk');
if( $navbar_style_chk == 'custom' ){
	//header navbar styles & link color
	$navbar_height = $gigas_styles->gigas_get_option('header-navbar-height');
	if( !empty( $navbar_height ) && isset( $navbar_height['height'] ) && !empty( $navbar_height['height'] ) ){
		echo '.header-navbar {';
			echo 'line-height: '. esc_attr( $navbar_height['height'] ) .'px;';
		echo '}';
	}
	
	$navbar_sticky_height = $gigas_styles->gigas_get_option('header-navbar-sticky-height');
	if( !empty( $navbar_sticky_height ) && isset( $navbar_sticky_height['height'] ) && !empty( $navbar_sticky_height['height'] ) ){
		echo '.header-sticky .header-navbar {';
			echo 'line-height: '. esc_attr( $navbar_sticky_height['height'] ) .'px;';
		echo '}';
	}
	
	$gigas_styles->gigas_bg_settings( 'header-navbar-background', '.header-navbar' );
	$gigas_styles->gigas_padding_settings( 'header-navbar-padding', '.header-navbar' );
	$gigas_styles->gigas_margin_settings( 'header-navbar-margin', '.header-navbar' );
	$gigas_styles->gigas_border_settings( 'header-navbar-border', '.header-navbar' );
	$gigas_styles->gigas_link_color( 'header-navbar-links-color', 'regular', '.header-navbar a, .header-navbar .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$gigas_styles->gigas_link_color( 'header-navbar-links-color', 'hover', '.header-navbar a:hover, .header-navbar .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$gigas_styles->gigas_link_color( 'header-navbar-links-color', 'active', '.header-navbar a:active, .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a,.header-navbar .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .header-navbar ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

	//navbar on sticky style
	$gigas_styles->gigas_bg_settings( 'header-navbar-sticky-background', '.sticky-head.header-sticky .header-navbar' );
	$gigas_styles->gigas_link_color( 'header-navbar-sticky-links-color', 'regular', '.sticky-head.header-sticky .header-navbar a, .sticky-head.header-sticky .header-navbar .primary-menu .menu-item-has-children ul.sub-menu li a' );
	$gigas_styles->gigas_link_color( 'header-navbar-sticky-links-color', 'hover', '.sticky-head.header-sticky .header-navbar a:hover, .sticky-head.header-sticky .header-navbar .primary-menu .menu-item-has-children ul.sub-menu li a:hover' );
	$gigas_styles->gigas_link_color( 'header-navbar-sticky-links-color', 'active', '.sticky-head.header-sticky .header-navbar a:active, .sticky-head.header-sticky .header-navbar ul.nav.wp-menu > li.menu-item-has-children.current-menu-ancestor > a,.sticky-head.header-sticky .header-navbar .primary-menu li.current-menu-parent > ul.sub-menu > li.current-menu-item > a, .sticky-head.header-sticky .header-navbar ul.wp-menu ul.sub-menu li.menu-item.current-menu-ancestor.menu-item-has-children > a' );

}

//Style end

$styles = ob_get_clean();
update_post_meta( $post_id, 'gigas_post_custom_styles', wp_slash( $styles ) );