<?php
/**
 * Header file for the Beruco WordPress theme.
 */

?><!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?>>

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>

		<?php wp_body_open(); // For wp wp_body_open action hook ?>

		<?php
			/*
			* Set beruco page meta
			*/
			if( is_singular() ){
				Beruco_Wp_Elements::$beruco_page_options = get_post_meta( get_the_ID(), 'beruco_post_meta', true );
			}
			$keys = array(
				'chk' => 'general-chk',
				'fields' => array(
					'site_layout' => 'site-layout'
				)			
			);
			$layout = Beruco_Wp_Elements::beruco_get_meta_and_option_values( $keys );
			$pageloader_opt = Beruco_Wp_Elements::beruco_options('page-loader-option');
		?>

			<div class="beruco-body-inner <?php
			  if( $layout['site_layout'] == 'boxed' ) {
			 	echo esc_attr( 'container' ); 
			} else if ( $layout['site_layout'] == 'wider' ) {
				echo esc_attr( 'container-fluid' );
			}
			?>">
		
			<?php if( $pageloader_opt == '1' ) : ?>
			<div class="page-loader"><span class="page-loader-divider"></span></div>
			<?php endif; ?>	

			<?php
			/*
			 * Beruco Header Before Action 
			 * 10 - beruco_mobile_header
			 */
			do_action( 'beruco_header_before' );
			?>
			
			<?php
			/*
			 * Beruco Header Action 
			 * 10 - beruco_desktop_header
			 */
			do_action( 'beruco_header' );
			?>
			
			<?php
			/*
			 * Beruco Header After Action 
			 * 10 - beruco_header_slider
			 */
			do_action( 'beruco_header_after' );
			?>