<?php
/**
 * The template for displaying pages.
 */

get_header();

Beruco_Wp_Elements::$template = apply_filters( 'beruco_define_page_template', 'page' );
Beruco_Wp_Elements::$beruco_page_options = get_post_meta( get_the_ID(), 'beruco_post_meta', true );

?>

<main id="site-content">

	<?php 
		/*
		* Page title template call
		*/
		get_template_part( 'template-parts/page', 'title' );
	?>

	<div class="beruco-content-wrap container page">
		<div class="row">
			<?php
				$content_col_class = Beruco_Wp_Elements::beruco_get_content_class();
			?>
			<div class="<?php echo esc_attr( $content_col_class ); ?>">
				<?php
					if ( have_posts() ) {
						while ( have_posts() ) {
							the_post();
							get_template_part( 'template-parts/content' );
						}
					}
				?>
			</div><!-- .col -->
			<?php get_template_part( 'template-parts/content-sidebar' ); ?>
		</div><!-- .row -->
	</div><!-- .container -->
</main><!-- #site-content -->

<?php get_footer(); ?>
