<?php 

class Gigas_Plugin_Info {
	
	private static $_parent_instance = null;
	
	public function __construct() {
		require_once GIGAS_DIR . '/admin/theme-plugins/tgm-init.php';
	}
		
	public static function gigas_get_plugins(){
		return get_plugins();
	}
		
	public static function gigas_does_plugin_require_update( $file_path ) {
		$repo_updates = get_site_transient( 'update_plugins' );
		$available_version = '';
		if ( isset( $repo_updates->response[ $file_path ]->new_version ) ) {
			$available_version = $repo_updates->response[ $file_path ]->new_version;			
		}
		return $available_version;
	}
		
	public static function gigas_tgm_install(){
		
		if ( ! isset( $_POST['gigas_bulk_nonce'] ) || ! wp_verify_nonce( $_POST['gigas_bulk_nonce'], 'gigas-bulk-plugin-install' ) ) wp_die("failed");
				
		require_once GIGAS_DIR . '/admin/theme-plugins/tgm-init.php';			
		$plugins = isset( $_POST['plugins'] ) ? $_POST['plugins'] : TGM_Plugin_Activation::$instance->plugins;
		if( isset( $_POST['gigas_bulk_plugins'] ) ) {
			$bulk_plugins = $_POST['gigas_bulk_plugins'];
			$bulk_action = isset( $_POST['gigas_bulk_action'] ) && ! empty( $_POST['gigas_bulk_action'] ) ? sanitize_text_field( $_POST['gigas_bulk_action'] ) : 'install';
		
			$tgm = new TGM_Plugin_Activation;			
			$tgm->plugins = $plugins;
			if( $bulk_action == 'install' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->gigas_do_plugin_install( $plugin_name );
				}
			}elseif( $bulk_action == 'active' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->gigas_do_plugin_activate( $plugin_name );
				}
			}elseif( $bulk_action == 'install-active' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->gigas_do_plugin_install( $plugin_name, true );
				}
			}elseif( $bulk_action == 'deactive' ){
				foreach( $bulk_plugins as $plugin_name ){
					$tgm->gigas_force_deactivation( $plugin_name );
				}
			}
		}
		wp_die("success");
	}
	
	public static function gigas_plugin_link( $item ) {
		
		include_once ABSPATH . 'wp-admin/includes/plugin.php';

		$installed_plugins = Gigas_Plugin_Info::gigas_get_plugins();
		$item['sanitized_plugin'] = $item['name'];
		 $is_plug_act = 'is_plugin_active';
		 
		if ( $is_plug_act( $item['file_path'] ) ) {
			
			$available_version = $item['source'] == 'repo' ? Gigas_Plugin_Info::gigas_does_plugin_require_update( $item['file_path'] ) : $item['version'];
			
			if ( version_compare( $available_version, $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
				$actions = array(
					'update' => sprintf(
						'<a href="%1$s" class="gigas-btn btn-default" title="%3$s %2$s">%3$s</a>',
						wp_nonce_url(
							add_query_arg(
								array(
									'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
									'plugin'		=> urlencode( $item['slug'] ),
									'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
									'plugin_source' => urlencode( $item['source'] ),
									'tgmpa-update' 	=> 'update-plugin',
									'version' 		=> urlencode( $item['version'] ),
									'return_url' 	=> 'gigas-plugins'
								),
								admin_url( TGM_Plugin_Activation::$instance->parent_slug )
							),
							'tgmpa-update',
							'tgmpa-nonce'
						),
						$item['sanitized_plugin'],
						esc_html__( 'Update', 'gigas' )
					),
				);
			}else{
				$actions = array(
					'deactivate' => sprintf(
						'<a href="%1$s" class="gigas-btn btn-default" title="%3$s %2$s">%3$s</a>',
						esc_url( add_query_arg(
							array(
								'plugin'					=> urlencode( $item['slug'] ),
								'plugin_name'		  		=> urlencode( $item['sanitized_plugin'] ),
								'plugin_source'				=> urlencode( $item['source'] ),
								'gigas-deactivate'	   		=> 'deactivate-plugin',
								'gigas-deactivate-nonce' 	=> wp_create_nonce( 'gigas-deactivate' ),
							),
							admin_url( 'admin.php?page=gigas-plugins' )
						) ),
						$item['sanitized_plugin'],
						esc_html__( 'Deactivate', 'gigas' )
					),
				);
			}
		}elseif ( ! isset( $installed_plugins[$item['file_path']] ) ) {
			$actions = array(
				'install' => sprintf(
					'<a href="%1$s" class="gigas-btn btn-default" title="%3$s %2$s">%3$s</a>',
					esc_url( wp_nonce_url(
						add_query_arg(
							array(
								'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
								'plugin'		=> urlencode( $item['slug'] ),
								'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
								'plugin_source' => urlencode( $item['source'] ),
								'tgmpa-install' => 'install-plugin',
								'return_url' 	=> 'gigas-plugins'
							),
							admin_url( TGM_Plugin_Activation::$instance->parent_slug )
						),
						'tgmpa-install',
						'tgmpa-nonce'
					) ),
					$item['sanitized_plugin'],
					esc_html__( 'Install', 'gigas' )
				),
			);
		}elseif ( is_plugin_inactive( $item['file_path'] ) ) {

			if ( version_compare( $item['version'], $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
				$actions = array(
					'update' => sprintf(
						'<a href="%1$s" class="gigas-btn btn-default" title="%3$s %2$s">%3$s</a>',
						wp_nonce_url(
							add_query_arg(
								array(
									'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
									'plugin'		=> urlencode( $item['slug'] ),
									'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
									'plugin_source' => urlencode( $item['source'] ),
									'tgmpa-update' 	=> 'update-plugin',
									'version' 		=> urlencode( $item['version'] ),
									'return_url' 	=> 'gigas-plugins'
								),
								admin_url( TGM_Plugin_Activation::$instance->parent_slug )
							),
							'tgmpa-update',
							'tgmpa-nonce'
						),
						$item['sanitized_plugin'],
						esc_html__( 'Update', 'gigas' )
					),
				);
			} else {
				$actions = array(
					'activate' => sprintf(
						'<a href="%1$s" class="gigas-btn btn-default" title="%3$s %2$s">%3$s</a>',
						esc_url( add_query_arg(
							array(
								'plugin'			   	=> urlencode( $item['slug'] ),
								'plugin_name'		  	=> urlencode( $item['sanitized_plugin'] ),
								'plugin_source'			=> urlencode( $item['source'] ),
								'gigas-activate'	   		=> 'activate-plugin',
								'gigas-activate-nonce' 	=> wp_create_nonce( 'gigas-activate' ),
							),
							admin_url( 'admin.php?page=gigas-plugins' )
						) ),
						$item['sanitized_plugin'],
						esc_html__( 'Activate', 'gigas' )
					),
				);
			}
		}elseif ( version_compare( $item['version'], $installed_plugins[$item['file_path']]['Version'], '>' ) ) {
			$actions = array(
				'update' => sprintf(
					'<a href="%1$s" class="gigas-btn btn-default" title="%3$s %2$s">%3$s</a>',
					wp_nonce_url(
						add_query_arg(
							array(
								'page'		  	=> urlencode( TGM_Plugin_Activation::$instance->menu ),
								'plugin'		=> urlencode( $item['slug'] ),
								'plugin_name'   => urlencode( $item['sanitized_plugin'] ),
								'plugin_source' => urlencode( $item['source'] ),
								'tgmpa-update' 	=> 'update-plugin',
								'version' 		=> urlencode( $item['version'] ),
								'return_url' 	=> 'gigas-plugins'
							),
							admin_url( TGM_Plugin_Activation::$instance->parent_slug )
						),
						'tgmpa-update',
						'tgmpa-nonce'
					),
					$item['sanitized_plugin'],
					esc_html__( 'Update', 'gigas' )
				),
			);
		}
		
		return $actions;
	}
	
	public static function get_parent_instance() {
		if ( is_null( self::$_parent_instance ) ) {
			self::$_parent_instance = new self();
		}
		return self::$_parent_instance;
	}
	
}

class Gigas_Plugins {
	
	private static $_instance = null;

	public function __construct() {
		Gigas_Plugin_Info::get_parent_instance();
		add_action( 'admin_menu', array( $this, 'gigas_admin_menu' ) );
	}
	
	public static function gigas_admin_menu(){
		add_submenu_page( 
			'gigas-welcome', 
			esc_html__( 'Theme Plugins', 'gigas' ),
			esc_html__( 'Theme Plugins', 'gigas' ), 
			'manage_options', 
			'gigas-plugins', 
			array( 'Gigas_Plugins', 'gigas_plugins_admin_page' )
		);		
	}
	
	public static function gigas_plugins_admin_page(){
		$gigas_theme = wp_get_theme(); ?>
		<div class="gigas-settings-wrap">	
			<div class="gigas-header-bar">
				<div class="gigas-header-left">
					<div class="gigas-admin-logo-inline">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/brand-logo.png' ); ?>" alt="gigas-logo">
					</div><!-- .gigas-admin-logo-inline -->
					<h2 class="title"><?php esc_html_e( 'Gigas Plugins', 'gigas' ); ?><span class="gigas-version"><?php echo esc_html( $gigas_theme->get( 'Version' ) ); ?></span></h2>
					<div class="nav-theme-options">
						<?php
						include_once ABSPATH . 'wp-admin/includes/plugin.php';
						$is_gigas_addon_active = class_exists( 'Gigas_Addon' );
						//$is_gigas_addon_active = is_plugin_active('gigas/gigas.php');
						$current_theme = wp_get_theme();
						$is_theme_active = ($current_theme->get('Name') === 'Gigas');
						$verfied_stat = get_option('verified_purchase_status');

						if ($is_gigas_addon_active) {
							echo '<a href="' . admin_url('admin.php?page=gigas-options') . '"><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						} else {
							echo '<a href="#" class="theme-options not-clickable" data-popup-message="Please install and activate the Gigas Addon plugin."><span class="dashicons dashicons-admin-tools"></span>Theme Options</a>';
						}
						if ($verfied_stat) {
							echo '<a href="' . admin_url('admin.php?page=gigas-plugins') . '" class="active-page"><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						} else {
							echo '<a href="#" class="not-clickable" data-popup-message="Please activate the Gigas theme."><span class="dashicons dashicons-admin-plugins"></span>Plugins</a>';
						}
						?>
						<div class="support-dropdown">
							<a href="#" class="dropdown-toggle"><span class="dashicons dashicons-buddicons-buddypress-logo"></span>Support</a>
							<div class="dropdown-content">
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-tickets-alt"></span>Ticket</a>
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-video-alt3"></span>Video</a>
								<a href="<?php echo esc_url('https://docs.zozothemes.com/gigas/');?>" target="_blank"><span class="dashicons dashicons-text-page"></span>Documentation</a>
								<a href="<?php echo esc_url('https://zozothemes.com/knowledge-base/');?>" target="_blank"><span class="dashicons dashicons-book-alt"></span>Knowledge Base</a>
							</div>
						</div>
						<a href="<?php echo esc_url('https://zozothemes.com/forum/')?>" target="_blank"><span class="dashicons dashicons-format-chat"></span>Forum</a>
					</div>
				</div><!-- .gigas-header-left -->
				<div class="gigas-header-right">
					<a href="<?php echo class_exists( 'Gigas_Addon' ) ? esc_url( admin_url( 'admin.php?page=gigas-importer' ) ) : '#'; ?>" class="button gigas-btn"><?php esc_html_e( 'Import Demo', 'gigas' ); ?></a>
				</div><!-- .gigas-header-right -->
			</div><!-- .gigas-header-bar -->
			
			<div class="gigas-inner-wrap">
			<?php 
				require_once GIGAS_DIR . '/admin/theme-plugins/tgm-init.php';			
				$plugins = TGM_Plugin_Activation::$instance->plugins;
				$plugin_custom_order = array(
					'elementor' 		=> $plugins['elementor'],
					'gigas-addon' 	=> $plugins['gigas-addon'],
					'classic-elementor-addons-pro' => $plugins['classic-elementor-addons-pro'],
					'cea-post-types' => $plugins['cea-post-types'],
					'zozo-header-footer' => $plugins['zozo-header-footer'],
					'revslider'			=> $plugins['revslider'],
					'contact-form-7' 	=> $plugins['contact-form-7'],
					'envato-market' 	=> $plugins['envato-market'],
				);
			
				$installed_plugins = Gigas_Plugin_Info::gigas_get_plugins();
				
				if( isset( $_GET['gigas-deactivate'] ) && $_GET['gigas-deactivate'] == 'deactivate-plugin' ) {
					check_admin_referer( 'gigas-deactivate', 'gigas-deactivate-nonce' );
					$plugins = TGM_Plugin_Activation::$instance->plugins;
					foreach( $plugins as $plugin ) {
						if( $plugin['slug'] == $_GET['plugin'] ) {
							deactivate_plugins( $plugin['file_path'] );
						}
					}
				}
				if( isset( $_GET['gigas-activate'] ) && $_GET['gigas-activate'] == 'activate-plugin' ) {
					check_admin_referer( 'gigas-activate', 'gigas-activate-nonce' );
					$plugins = TGM_Plugin_Activation::$instance->plugins;
					foreach( $plugins as $plugin ) {
						if( $plugin['slug'] == $_GET['plugin'] ) {
							activate_plugin( $plugin['file_path'] );
						}
					}
				}
				$plugins = $plugin_custom_order;
				
				?>
			
				<div class="gigas-settings-tabs">
					<div id="gigas-general" class="gigas-settings-tab gigas-elements-list active">
						<div class="container">
							<form id="multi-plugins-active-form" method="post" action="<?php echo esc_url( admin_url( 'admin.php?page=gigas-plugins' ) ); ?>" enctype="multipart/form-data">
								<input type="hidden" name="action" value="gigas_tgm_install" />
								<?php wp_nonce_field( 'gigas-bulk-plugin-install', 'gigas_bulk_nonce' ); ?>
								<p class="gigas-settings-msg">
									<span class="multi-select-wrap">
										<input type="checkbox" class="bulk-select-all" /> <?php echo esc_html__('Bulk Select', 'gigas'); ?>
									</span>
									<select class="bulk-plugins-action-trigger btn btn-default" name="gigas_bulk_action">
										<option value="install"><?php echo esc_html__('Install', 'gigas'); ?></option>
										<option value="active"><?php echo esc_html__('Activate', 'gigas'); ?></option>
										<option value="deactive"><?php echo esc_html__('Deactivate', 'gigas'); ?></option>
									</select>
									<a href="#" class="button gigas-bulk-action"><?php echo esc_html__('Apply', 'gigas'); ?></a>
									<img src="<?php echo esc_url( GIGAS_URI . '/admin/assets/images/loader.gif' ); ?>" alt="<?php echo esc_attr_e('Loader', 'gigas'); ?>" class="bulk-process-loader" />
								</p>
								<?php echo wp_nonce_field( 'gigas_activate_nonce', 'gigas-multi-plugin*^*' ); ?>
							</form>
							<div class="row multi-cols">
							<?php
								$active_action = '';
								if( isset( $_GET['plugin_status'] ) ) {
									$active_action = $_GET['plugin_status'];
								}
								$req_plugs = array();						
					
								foreach( $plugins as $plugin ):
									$class = '';
									$plugin_status = '';
									$active_action_class = '';
									$file_path = $plugin['file_path'];
									$plugin_action = Gigas_Plugin_Info::gigas_plugin_link( $plugin );
									foreach( $plugin_action as $action => $value ) {
										if( $active_action == $action ) {
											$active_action_class = ' plugin-' .$active_action. '';
										}
									}
									
									$is_plug_act = 'is_plugin_active';
									if( $is_plug_act( $file_path ) ) {
										$plugin_status = 'active';
										$class = ' active';
										$req_plugs[] = esc_html( $plugin['slug'] );
									}
									
									$class .= $active_action_class;
							?>
								<div class="col-4<?php echo esc_attr( $class ); ?>">
									<div class="media admin-box gigas-plugins-box">
										<div class="admin-box-icon p-0 mr-3">
											<span class="plugin-image-wrap"><img src="<?php echo esc_url( $plugin['image_url'] ); ?>" alt="<?php echo esc_attr( $plugin['name'] ); ?>" /></span>								
										</div>
										<div class="media-body admin-box-info">
											<h3 class="admin-box-title"><?php echo esc_html( $plugin['name'] ); ?></h3>
											<div class="admin-box-content">
												<?php if( $plugin['required'] ): ?>
												<div class="plugin-required"><span class="dashicons dashicons-star-filled" title="<?php echo esc_attr__('Required', 'gigas'); ?>"></span></div>
												<?php endif; ?>
												<?php if( isset( $installed_plugins[$plugin['file_path']] ) ): ?> 
												<div class="plugin-info"><?php 
													$current_version = $installed_plugins[$plugin['file_path']]['Version'];
													$available_version = $current_version;
													if( $plugin['source'] == 'repo' ){
														$available_version = Gigas_Plugin_Info::gigas_does_plugin_require_update( $plugin['file_path'] );
													}
												?>
													<?php echo sprintf( 'v%s | %s', $installed_plugins[$plugin['file_path']]['Version'], $installed_plugins[$plugin['file_path']]['Author'] ); ?>
												</div>
												<?php endif; ?>
												<div class="theme-actions--">
													<?php foreach( $plugin_action as $action ) { echo ( ''. $action ); } ?>
												</div>
												<?php $available_version = '';
												      $current_version = '';
													if( $plugin['source'] == 'repo' && version_compare( $available_version, $current_version, '>' ) ): ?>
													<div class="theme-update"><?php echo esc_html__('Update Available: Version', 'gigas'); ?> <?php echo esc_attr( $available_version ); ?></div>
												<?php
												elseif( isset( $plugin_action['update'] ) && $plugin_action['update'] ): ?>
													<div class="theme-update"><?php echo esc_html__('Update Available: Version', 'gigas'); ?> <?php echo esc_attr( $plugin['version'] ); ?></div>
												<?php endif; ?>
												
												<span class="multi-active-wrap"><input type="checkbox" class="bulk-activator" value="<?php echo esc_attr( $plugin['slug'] ); ?>" /></span>
												
											</div>
										</div>
									</div>
								</div><!-- .col -->
							<?php endforeach; ?>
							</div><!-- .row -->
						</div><!-- .container -->
					</div><!-- .gigas-settings-tab -->
				</div><!-- .gigas-settings-tabs -->
			
			</div><!-- .gigas-inner-wrap -->
		</div><!-- .gigas-settings-wrap -->
	<?php
	}
	
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

} Gigas_Plugins::get_instance();

//Plugin ajax functions
add_action( 'wp_ajax_gigas_tgm_install', array( 'Gigas_Plugin_Info', 'gigas_tgm_install' ) );
add_action( 'wp_ajax_nopriv_gigas_tgm_install', array( 'Gigas_Plugin_Info', 'gigas_tgm_install' )  );