<?php
/**
 * Header file for the Gigas WordPress theme.
 */

?><!DOCTYPE html>

<html class="no-js" <?php language_attributes(); ?>>

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1.0" >
		<link rel="profile" href="https://gmpg.org/xfn/11">
		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>

		<?php wp_body_open(); // For wp wp_body_open action hook ?>

		<?php
			/*
			* Set gigas page meta
			*/
			if( is_singular() ){
				Gigas_Wp_Elements::$gigas_page_options = get_post_meta( get_the_ID(), 'gigas_post_meta', true );
			}
			$keys = array(
				'chk' => 'general-chk',
				'fields' => array(
					'site_layout' => 'site-layout'
				)			
			);
			$layout = Gigas_Wp_Elements::gigas_get_meta_and_option_values( $keys );
			$pageloader_opt = Gigas_Wp_Elements::gigas_options('page-loader-option');
		?>

			<div class="gigas-body-inner <?php
			  if( $layout['site_layout'] == 'boxed' ) {
			 	echo esc_attr( 'container' ); 
			} else if ( $layout['site_layout'] == 'wider' ) {
				echo esc_attr( 'container-fluid' );
			}
			?>">
		
			<?php if( $pageloader_opt == '1' ) : ?>
			<div class="page-loader"><span class="page-loader-divider"></span></div>
			<?php endif; ?>	

			<?php
			/*
			 * Gigas Header Before Action 
			 * 10 - gigas_mobile_header
			 */
			do_action( 'gigas_header_before' );
			?>
			
			<?php
			/*
			 * Gigas Header Action 
			 * 10 - gigas_desktop_header
			 */
			do_action( 'gigas_header' );
			?>
			
			<?php
			/*
			 * Gigas Header After Action 
			 * 10 - gigas_header_slider
			 */
			do_action( 'gigas_header_after' );
			?>